/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.workspace;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.lax1dude.eaglercraft.v1_8.buildtools.workspace.Base64;

public class MakeOfflineDownload {
    private static final String USE_STRICT = "\"use strict\";";

    public static void main(String[] stringArray) throws IOException {
        FileOutputStream fileOutputStream;
        Object object;
        String string;
        if (stringArray.length != 4 && stringArray.length != 6) {
            System.err.println("Usage: MakeOfflineDownload.jar <template.html> <javascript files> <assets.epk> <en_US output.html> [international output.html] [languages dir/zip or cached languages.epk]");
        }
        System.out.println();
        System.out.println("Generating offline download...");
        System.out.println();
        System.out.println("Loading file: " + stringArray[0]);
        String string2 = new String(MakeOfflineDownload.loadFile(new File(stringArray[0])), StandardCharsets.UTF_8);
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray2 = stringArray[1].split("\\" + System.getProperty("path.separator"));
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println("Loading file: " + stringArray2[n]);
            string = new String(MakeOfflineDownload.loadFile(new File(stringArray2[n])), StandardCharsets.UTF_8);
            if (string.startsWith(USE_STRICT)) {
                string = string.substring(USE_STRICT.length());
            }
            if (n > 0) {
                stringBuilder.append("\n\n");
            }
            stringBuilder.append(string);
            ++n;
        }
        System.out.println("Loading file: " + stringArray[2]);
        String string3 = Base64.encodeBase64String(MakeOfflineDownload.loadFile(new File(stringArray[2])));
        string = null;
        if (stringArray.length == 6) {
            if (stringArray[5].endsWith(".epk")) {
                System.out.println("Loading file: " + stringArray[5]);
                string = Base64.encodeBase64String(MakeOfflineDownload.loadFile(new File(stringArray[5])));
            } else {
                System.out.println();
                System.out.println("Building EPK: " + stringArray[5]);
                object = new File(stringArray[5]);
                string = Base64.encodeBase64String(MakeOfflineDownload.makeEPK((File)object, new File(((File)object).getParentFile(), "languages.tmp.epk")));
            }
        }
        System.out.println();
        object = new SimpleDateFormat("MM/dd/yyyy").format(new Date());
        System.out.println("Using date: " + (String)object);
        System.out.println();
        System.out.println("Writing html to: " + stringArray[3]);
        System.out.println();
        String string4 = stringBuilder.toString();
        String string5 = string2.replace("${date}", (CharSequence)object).replace("${classes_js}", string4).replace("${assets_epk}", "\"data:application/octet-stream;base64," + string3 + "\"");
        Throwable throwable = null;
        Object var10_13 = null;
        try {
            fileOutputStream = new FileOutputStream(new File(stringArray[3]));
            try {
                fileOutputStream.write(string5.getBytes(StandardCharsets.UTF_8));
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (string != null) {
            System.out.println("Writing html to: " + stringArray[4]);
            System.out.println();
            string5 = string2.replace("${date}", (CharSequence)object).replace("${classes_js}", string4).replace("${assets_epk}", "[ { url: \"data:application/octet-stream;base64," + string3 + "\" }, { url: \"data:application/octet-stream;base64," + string + "\", path: \"assets/minecraft/lang/\" } ]");
            throwable = null;
            var10_13 = null;
            try {
                fileOutputStream = new FileOutputStream(new File(stringArray[4]));
                try {
                    fileOutputStream.write(string5.getBytes(StandardCharsets.UTF_8));
                }
                finally {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        System.out.println("Finished.");
        System.out.println();
    }

    private static byte[] loadFile(File file) throws IOException {
        byte[] byArray = new byte[(int)file.length()];
        int n = 0;
        Throwable throwable = null;
        Object var5_5 = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n2;
            while (n < byArray.length && (n2 = fileInputStream.read(byArray, n, byArray.length - n)) != -1) {
                n += n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return byArray;
    }

    private static byte[] makeEPK(File file, File file2) throws IOException {
        Object object;
        try {
            object = Class.forName("CompilePackage").getDeclaredMethod("main", String[].class);
            ((Method)object).invoke(null, new Object[]{new String[]{file.getAbsolutePath(), file2.getAbsolutePath()}});
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new IOException("Failed to run EPKCompiler!", throwable);
        }
        catch (Throwable throwable) {
            throw new IOException("Failed to run EPKCompiler!", throwable);
        }
        object = MakeOfflineDownload.loadFile(file2);
        file2.delete();
        return object;
    }
}

