/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ISkinService;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinPackets;
import net.md_5.bungee.UserConnection;

public class SkinServiceOffline
implements ISkinService {
    public static final int masterRateLimitPerPlayer = 250;
    private final Map<UUID, CachedSkin> skinCache = new HashMap<UUID, CachedSkin>();
    private final Multimap<UUID, UUID> onlinePlayersFromTexturesMap = MultimapBuilder.hashKeys().hashSetValues().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String uri, String driverClass, String driverPath, int keepObjectsDays, int keepProfilesDays, int maxObjects, int maxProfiles) {
        Map<UUID, CachedSkin> map = this.skinCache;
        synchronized (map) {
            this.skinCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processGetOtherSkin(UUID searchUUID, UserConnection sender) {
        if (((EaglerInitialHandler)sender.getPendingConnection()).skinLookupRateLimiter.rateLimit(250)) {
            CachedSkin cached;
            Map<UUID, CachedSkin> map = this.skinCache;
            synchronized (map) {
                cached = this.skinCache.get(searchUUID);
            }
            if (cached != null) {
                sender.sendData("EAG|Skins-1.8", cached.packet);
            } else {
                sender.sendData("EAG|Skins-1.8", SkinPackets.makePresetResponse(searchUUID));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processGetOtherSkin(UUID searchUUID, String skinURL, UserConnection sender) {
        Collection uuids;
        Multimap<UUID, UUID> multimap = this.onlinePlayersFromTexturesMap;
        synchronized (multimap) {
            uuids = this.onlinePlayersFromTexturesMap.get((Object)searchUUID);
        }
        if (uuids.size() > 0) {
            Map<UUID, CachedSkin> map = this.skinCache;
            synchronized (map) {
                Iterator uuidItr = uuids.iterator();
                while (uuidItr.hasNext()) {
                    CachedSkin cached = this.skinCache.get(uuidItr.next());
                    if (cached == null) continue;
                    sender.sendData("EAG|Skins-1.8", SkinPackets.rewriteUUID(searchUUID, cached.packet));
                }
            }
        }
        sender.sendData("EAG|Skins-1.8", SkinPackets.makePresetResponse(searchUUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEaglercraftPlayer(UUID clientUUID, byte[] generatedPacket, int modelId) throws IOException {
        Map<UUID, CachedSkin> map = this.skinCache;
        synchronized (map) {
            this.skinCache.put(clientUUID, new CachedSkin(clientUUID, generatedPacket));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterPlayer(UUID clientUUID) {
        Map<UUID, CachedSkin> map = this.skinCache;
        synchronized (map) {
            this.skinCache.remove(clientUUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTextureToPlayerAssociation(UUID textureUUID, UUID playerUUID) {
        Multimap<UUID, UUID> multimap = this.onlinePlayersFromTexturesMap;
        synchronized (multimap) {
            this.onlinePlayersFromTexturesMap.put((Object)textureUUID, (Object)playerUUID);
        }
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Map<UUID, CachedSkin> map = this.skinCache;
        synchronized (map) {
            this.skinCache.clear();
        }
    }

    private static class CachedSkin {
        protected final UUID uuid;
        protected final byte[] packet;

        protected CachedSkin(UUID uuid, byte[] packet) {
            this.uuid = uuid;
            this.packet = packet;
        }
    }
}

