/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.BinaryHttpClient;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ICacheProvider;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SimpleRateLimiter;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinPackets;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinRescaler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinService;
import org.apache.commons.codec.binary.Base64;

public class AsyncSkinProvider {
    private static final SimpleRateLimiter rateLimitDownload = new SimpleRateLimiter();
    private static final SimpleRateLimiter rateLimitLookup = new SimpleRateLimiter();

    public static void downloadSkin(String skinTexture, ICacheProvider cacheProvider, Consumer<byte[]> responseConsumer) {
        AsyncSkinProvider.downloadSkin(SkinPackets.createEaglerURLSkinUUID(skinTexture), skinTexture, cacheProvider, responseConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadSkin(UUID skinUUID, String skinTexture, ICacheProvider cacheProvider, Consumer<byte[]> responseConsumer) {
        URI uri;
        ICacheProvider.CacheLoadedSkin loadedSkin = cacheProvider.loadSkinByUUID(skinUUID);
        if (loadedSkin == null) {
            boolean isRateLimit;
            try {
                uri = URI.create(skinTexture);
            }
            catch (IllegalArgumentException ex) {
                try {
                    responseConsumer.accept(null);
                }
                catch (Throwable t) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown handling invalid skin!", t);
                }
                throw new CancelException();
            }
            int globalRatelimit = EaglerXBungee.getEagler().getConfig().getSkinRateLimitGlobal();
            SimpleRateLimiter simpleRateLimiter = rateLimitDownload;
            synchronized (simpleRateLimiter) {
                isRateLimit = !rateLimitDownload.rateLimit(globalRatelimit);
            }
            if (isRateLimit) {
                EaglerXBungee.logger().warning("skin system reached the global texture download ratelimit of " + globalRatelimit + " while downloading up \"" + skinTexture + "\"");
                throw new CancelException();
            }
        } else {
            try {
                responseConsumer.accept(loadedSkin.texture);
            }
            catch (Throwable t) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown processing cached skin!", t);
            }
            throw new CancelException();
        }
        BinaryHttpClient.asyncRequest("GET", uri, new SkinConsumerImpl(new SkinCachingConsumer(skinUUID, skinTexture, cacheProvider, responseConsumer)));
    }

    public static void lookupProfileByUUID(UUID playerUUID, ICacheProvider cacheProvider, Consumer<CacheFetchedProfile> responseConsumer) {
        AsyncSkinProvider.lookupProfileByUUID(playerUUID, cacheProvider, responseConsumer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lookupProfileByUUID(UUID playerUUID, ICacheProvider cacheProvider, Consumer<CacheFetchedProfile> responseConsumer, boolean rateLimit) {
        URI requestURI;
        ICacheProvider.CacheLoadedProfile profile = cacheProvider.loadProfileByUUID(playerUUID);
        if (profile == null) {
            boolean isRateLimit;
            requestURI = URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + SkinService.getMojangUUID(playerUUID));
            int globalRatelimit = EaglerXBungee.getEagler().getConfig().getUuidRateLimitGlobal();
            if (rateLimit) {
                SimpleRateLimiter simpleRateLimiter = rateLimitLookup;
                synchronized (simpleRateLimiter) {
                    isRateLimit = !rateLimitLookup.rateLimit(globalRatelimit);
                }
            } else {
                isRateLimit = false;
            }
            if (isRateLimit) {
                EaglerXBungee.logger().warning("skin system reached the global UUID lookup ratelimit of " + globalRatelimit + " while looking up \"" + playerUUID + "\"");
                throw new CancelException();
            }
        } else {
            try {
                responseConsumer.accept(new CacheFetchedProfile(profile));
            }
            catch (Throwable t) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown processing cached profile!", t);
            }
            throw new CancelException();
        }
        BinaryHttpClient.asyncRequest("GET", requestURI, new ProfileConsumerImpl(playerUUID, new ProfileCachingConsumer(playerUUID, cacheProvider, responseConsumer)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lookupProfileByUsername(String playerUsername, ICacheProvider cacheProvider, Consumer<CacheFetchedProfile> responseConsumer) {
        URI requestURI;
        String playerUsernameLower = playerUsername.toLowerCase();
        ICacheProvider.CacheLoadedProfile profile = cacheProvider.loadProfileByUsername(playerUsernameLower);
        if (profile == null) {
            boolean isRateLimit;
            if (!playerUsernameLower.equals(playerUsernameLower.replaceAll("[^a-z0-9_]", "_").trim())) {
                try {
                    responseConsumer.accept(null);
                }
                catch (Throwable t) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown processing invalid profile!", t);
                }
                throw new CancelException();
            }
            requestURI = URI.create("https://api.mojang.com/users/profiles/minecraft/" + playerUsername);
            int globalRatelimit = EaglerXBungee.getEagler().getConfig().getUuidRateLimitGlobal();
            SimpleRateLimiter simpleRateLimiter = rateLimitLookup;
            synchronized (simpleRateLimiter) {
                isRateLimit = !rateLimitLookup.rateLimit(globalRatelimit);
            }
            if (isRateLimit) {
                EaglerXBungee.logger().warning("skin system reached the global UUID lookup ratelimit of " + globalRatelimit + " while looking up \"" + playerUsername + "\"");
                throw new CancelException();
            }
        } else {
            try {
                responseConsumer.accept(new CacheFetchedProfile(profile));
            }
            catch (Throwable t) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown processing cached profile!", t);
            }
            throw new CancelException();
        }
        BinaryHttpClient.asyncRequest("GET", requestURI, new UsernameToUUIDConsumerImpl(playerUsername, cacheProvider, responseConsumer));
    }

    public static class CacheFetchedProfile {
        public final UUID uuid;
        public final String username;
        public final String texture;
        public final UUID textureUUID;
        public final String model;

        protected CacheFetchedProfile(UUID uuid, String username, String texture, String model) {
            this.uuid = uuid;
            this.username = username;
            this.texture = texture;
            this.textureUUID = SkinPackets.createEaglerURLSkinUUID(texture);
            this.model = model;
        }

        protected CacheFetchedProfile(ICacheProvider.CacheLoadedProfile profile) {
            this.uuid = profile.uuid;
            this.username = profile.username;
            this.texture = profile.texture;
            this.textureUUID = SkinPackets.createEaglerURLSkinUUID(profile.texture);
            this.model = profile.model;
        }
    }

    public static class CancelException
    extends RuntimeException {
    }

    private static class ProfileCachingConsumer
    implements Consumer<CacheFetchedProfile> {
        protected final UUID uuid;
        protected final ICacheProvider cacheProvider;
        protected final Consumer<CacheFetchedProfile> responseConsumer;

        protected ProfileCachingConsumer(UUID uuid, ICacheProvider cacheProvider, Consumer<CacheFetchedProfile> responseConsumer) {
            this.uuid = uuid;
            this.cacheProvider = cacheProvider;
            this.responseConsumer = responseConsumer;
        }

        @Override
        public void accept(CacheFetchedProfile profile) {
            if (profile != null) {
                try {
                    this.cacheProvider.cacheProfileByUUID(this.uuid, profile.username, profile.texture, profile.model);
                }
                catch (Throwable t) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown writing new profile to database!", t);
                }
                this.responseConsumer.accept(profile);
            } else {
                this.responseConsumer.accept(null);
            }
        }
    }

    private static class ProfileConsumerImpl
    implements Consumer<BinaryHttpClient.Response> {
        protected final UUID uuid;
        protected final Consumer<CacheFetchedProfile> responseConsumer;

        protected ProfileConsumerImpl(UUID uuid, Consumer<CacheFetchedProfile> responseConsumer) {
            this.uuid = uuid;
            this.responseConsumer = responseConsumer;
        }

        protected void doAccept(CacheFetchedProfile v) {
            try {
                this.responseConsumer.accept(v);
            }
            catch (Throwable t) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown caching new profile!", t);
            }
        }

        @Override
        public void accept(BinaryHttpClient.Response response) {
            if (response == null || response.exception != null || response.code != 200 || response.data == null) {
                this.doAccept(null);
            } else {
                try {
                    String model;
                    String texture;
                    String username;
                    block13: {
                        JsonObject json = new JsonParser().parse(new String(response.data, StandardCharsets.UTF_8)).getAsJsonObject();
                        username = json.get("name").getAsString().toLowerCase();
                        texture = null;
                        model = null;
                        JsonElement propsElement = json.get("properties");
                        if (propsElement != null) {
                            try {
                                JsonArray properties = propsElement.getAsJsonArray();
                                if (properties.size() <= 0) break block13;
                                int i = 0;
                                int l = properties.size();
                                while (i < l) {
                                    JsonObject propObj;
                                    JsonElement prop = properties.get(i);
                                    if (prop.isJsonObject() && (propObj = prop.getAsJsonObject()).get("name").getAsString().equals("textures")) {
                                        JsonElement skin;
                                        String value = new String(Base64.decodeBase64((String)propObj.get("value").getAsString()), StandardCharsets.UTF_8);
                                        JsonObject texturesJson = new JsonParser().parse(value).getAsJsonObject();
                                        if (texturesJson != null && texturesJson.has("textures") && (skin = (texturesJson = texturesJson.getAsJsonObject("textures")).get("SKIN")) != null) {
                                            JsonObject metaObj;
                                            JsonElement modelElement;
                                            JsonElement metaElement;
                                            model = "default";
                                            JsonObject skinObj = skin.getAsJsonObject();
                                            JsonElement urlElement = skinObj.get("url");
                                            if (urlElement != null && !urlElement.isJsonNull()) {
                                                texture = urlElement.getAsString();
                                            }
                                            if ((metaElement = skinObj.get("metadata")) != null && (modelElement = (metaObj = metaElement.getAsJsonObject()).get("model")) != null) {
                                                model = modelElement.getAsString();
                                            }
                                        }
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (texture == null && model == null) {
                        model = SkinService.isAlex(this.uuid) ? "slim" : "default";
                    }
                    this.doAccept(new CacheFetchedProfile(this.uuid, username, texture, model));
                }
                catch (Throwable ex) {
                    this.doAccept(null);
                }
            }
        }
    }

    private static class SkinCachingConsumer
    implements Consumer<byte[]> {
        protected final UUID skinUUID;
        protected final String skinTexture;
        protected final ICacheProvider cacheProvider;
        protected final Consumer<byte[]> responseConsumer;

        protected SkinCachingConsumer(UUID skinUUID, String skinTexture, ICacheProvider cacheProvider, Consumer<byte[]> responseConsumer) {
            this.skinUUID = skinUUID;
            this.skinTexture = skinTexture;
            this.cacheProvider = cacheProvider;
            this.responseConsumer = responseConsumer;
        }

        @Override
        public void accept(byte[] skin) {
            if (skin != null) {
                try {
                    this.cacheProvider.cacheSkinByUUID(this.skinUUID, this.skinTexture, skin);
                }
                catch (Throwable t) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown writing new skin to database!", t);
                }
                this.responseConsumer.accept(skin);
            } else {
                this.responseConsumer.accept(null);
            }
        }
    }

    private static class SkinConsumerImpl
    implements Consumer<BinaryHttpClient.Response> {
        protected final Consumer<byte[]> responseConsumer;

        protected SkinConsumerImpl(Consumer<byte[]> consumer) {
            this.responseConsumer = consumer;
        }

        protected void doAccept(byte[] v) {
            try {
                this.responseConsumer.accept(v);
            }
            catch (Throwable t) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown caching new skin!", t);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void accept(BinaryHttpClient.Response response) {
            BufferedImage image;
            if (response == null || response.exception != null || response.code != 200 || response.data == null) {
                this.doAccept(null);
                return;
            }
            try {
                image = ImageIO.read(new ByteArrayInputStream(response.data));
            }
            catch (IOException ex) {
                this.doAccept(null);
                return;
            }
            try {
                byte[] loadedPixels;
                int srcWidth = image.getWidth();
                int srcHeight = image.getHeight();
                if (srcWidth < 64 || srcWidth > 512 || srcHeight < 32 || srcHeight > 512) {
                    this.doAccept(null);
                    return;
                }
                if (srcWidth != 64 || srcHeight != 64) {
                    Graphics2D graphics;
                    BufferedImage scaled;
                    if (srcWidth % 64 != 0) {
                        this.doAccept(null);
                        return;
                    }
                    if (srcWidth == srcHeight * 2) {
                        scaled = new BufferedImage(64, 32, 2);
                        graphics = scaled.createGraphics();
                        graphics.drawImage(image, 0, 0, 64, 32, 0, 0, srcWidth, srcHeight, null);
                        graphics.dispose();
                        image = scaled;
                        srcWidth = 64;
                        srcHeight = 32;
                    } else {
                        if (srcWidth != srcHeight) {
                            this.doAccept(null);
                            return;
                        }
                        scaled = new BufferedImage(64, 64, 2);
                        graphics = scaled.createGraphics();
                        graphics.drawImage(image, 0, 0, 64, 64, 0, 0, srcWidth, srcHeight, null);
                        graphics.dispose();
                        image = scaled;
                        srcWidth = 64;
                        srcHeight = 64;
                    }
                }
                if (srcWidth == 64 && srcHeight == 64) {
                    int[] tmp = new int[4096];
                    loadedPixels = new byte[16384];
                    image.getRGB(0, 0, 64, 64, tmp, 0, 64);
                    SkinRescaler.convertToBytes(tmp, loadedPixels);
                    SkinPackets.setAlphaForChest(loadedPixels, (byte)-1);
                    this.doAccept(loadedPixels);
                    return;
                }
                if (srcWidth == 64 && srcHeight == 32) {
                    int[] tmp1 = new int[2048];
                    loadedPixels = new byte[16384];
                    image.getRGB(0, 0, 64, 32, tmp1, 0, 64);
                    SkinRescaler.convert64x32To64x64(tmp1, loadedPixels);
                    SkinPackets.setAlphaForChest(loadedPixels, (byte)-1);
                    this.doAccept(loadedPixels);
                    return;
                }
                this.doAccept(null);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class UsernameToUUIDConsumerImpl
    implements Consumer<BinaryHttpClient.Response> {
        protected final String username;
        protected final ICacheProvider cacheProvider;
        protected final Consumer<CacheFetchedProfile> responseConsumer;

        protected UsernameToUUIDConsumerImpl(String username, ICacheProvider cacheProvider, Consumer<CacheFetchedProfile> responseConsumer) {
            this.username = username;
            this.cacheProvider = cacheProvider;
            this.responseConsumer = responseConsumer;
        }

        protected void doAccept(CacheFetchedProfile v) {
            try {
                this.responseConsumer.accept(v);
            }
            catch (Throwable t) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception thrown caching new profile!", t);
            }
        }

        @Override
        public void accept(BinaryHttpClient.Response response) {
            if (response == null || response.exception != null || response.code != 200 || response.data == null) {
                this.doAccept(null);
            } else {
                try {
                    JsonObject json = new JsonParser().parse(new String(response.data, StandardCharsets.UTF_8)).getAsJsonObject();
                    String loadUsername = json.get("name").getAsString().toLowerCase();
                    if (!this.username.equals(loadUsername)) {
                        this.doAccept(null);
                    }
                    UUID mojangUUID = SkinService.parseMojangUUID(json.get("id").getAsString());
                    AsyncSkinProvider.lookupProfileByUUID(mojangUUID, this.cacheProvider, this.responseConsumer, false);
                }
                catch (Throwable t) {
                    this.doAccept(null);
                }
            }
        }
    }
}

