/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerConnectionInstance;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerPipeline;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.bungeeprotocol.EaglerBungeeProtocol;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.bungeeprotocol.EaglerProtocolAccessProxy;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EaglerMinecraftDecoder
extends MessageToMessageDecoder<WebSocketFrame> {
    private EaglerBungeeProtocol protocol;
    private final boolean server;
    private int protocolVersion;
    private static Constructor<PacketWrapper> packetWrapperConstructor = null;

    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        if (!ctx.channel().isActive()) {
            return;
        }
        EaglerConnectionInstance con = (EaglerConnectionInstance)ctx.channel().attr(EaglerPipeline.CONNECTION_INSTANCE).get();
        long millis = System.currentTimeMillis();
        if (frame instanceof BinaryWebSocketFrame) {
            BinaryWebSocketFrame in = (BinaryWebSocketFrame)frame;
            ByteBuf buf = in.content();
            int pktId = DefinedPacket.readVarInt((ByteBuf)buf);
            DefinedPacket pkt = EaglerProtocolAccessProxy.createPacket(this.protocol, this.protocolVersion, pktId, this.server);
            Protocol bungeeProtocol = null;
            switch (this.protocol) {
                case GAME: {
                    bungeeProtocol = Protocol.GAME;
                    break;
                }
                case HANDSHAKE: {
                    bungeeProtocol = Protocol.HANDSHAKE;
                    break;
                }
                case LOGIN: {
                    bungeeProtocol = Protocol.LOGIN;
                    break;
                }
                case STATUS: {
                    bungeeProtocol = Protocol.STATUS;
                }
            }
            if (pkt != null) {
                pkt.read(buf, this.server ? ProtocolConstants.Direction.TO_CLIENT : ProtocolConstants.Direction.TO_SERVER, this.protocolVersion);
                if (buf.isReadable()) {
                    EaglerXBungee.logger().severe("[DECODER][" + ctx.channel().remoteAddress() + "] Packet " + pkt.getClass().getSimpleName() + " had extra bytes! (" + buf.readableBytes() + ")");
                } else {
                    out.add(this.wrapPacket(pkt, buf, bungeeProtocol));
                }
            } else {
                out.add(this.wrapPacket(null, buf, bungeeProtocol));
            }
        } else if (frame instanceof PingWebSocketFrame) {
            if (millis - con.lastClientPingPacket > 500L) {
                ctx.write((Object)new PongWebSocketFrame());
                con.lastClientPingPacket = millis;
            }
        } else if (frame instanceof PongWebSocketFrame) {
            con.lastClientPongPacket = millis;
        } else {
            ctx.close();
        }
    }

    public EaglerMinecraftDecoder(EaglerBungeeProtocol protocol, boolean server, int protocolVersion) {
        this.protocol = protocol;
        this.server = server;
        this.protocolVersion = protocolVersion;
    }

    public void setProtocol(EaglerBungeeProtocol protocol) {
        this.protocol = protocol;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    /*
     * Unable to fully structure code
     */
    private PacketWrapper wrapPacket(DefinedPacket packet, ByteBuf buf, Protocol protocol) {
        block13: {
            cbuf = null;
            cbuf = buf.copy(0, buf.writerIndex());
            if (EaglerMinecraftDecoder.packetWrapperConstructor != null) {
                try {
                    pkt = EaglerMinecraftDecoder.packetWrapperConstructor.newInstance(new Object[]{packet, cbuf});
                    cbuf = null;
                    var10_8 = pkt;
                    return var10_8;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException var14) {
                    throw new RuntimeException(var14);
                }
            }
            ** try [egrp 3[TRYBLOCK] [3 : 77->97)] { 
lbl-1000:
            // 1 sources

            {
                pkt = new PacketWrapper(packet, cbuf, protocol);
                cbuf = null;
                var10_9 = pkt;
                return var10_9;
            }
lbl17:
            // 1 sources

            catch (NoSuchMethodError var15) {
                try {
                    EaglerMinecraftDecoder.packetWrapperConstructor = PacketWrapper.class.getDeclaredConstructor(new Class[]{DefinedPacket.class, ByteBuf.class});
                    pkt = EaglerMinecraftDecoder.packetWrapperConstructor.newInstance(new Object[]{packet, cbuf});
                    cbuf = null;
                    var7 = pkt;
                    break block13;
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException var13) {
                    throw new RuntimeException(var13);
                }
            }
            finally {
                if (cbuf != null) {
                    cbuf.release();
                }
            }
        }
        return var7;
    }
}

