/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SimpleRateLimiter;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Property;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.LegacyHandshake;
import net.md_5.bungee.protocol.packet.LegacyPing;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.StatusRequest;

public class EaglerInitialHandler
extends InitialHandler {
    private final int gameProtocolVersion;
    private final String username;
    private final UUID playerUUID;
    private LoginResult loginResult;
    private final InetSocketAddress eaglerAddress;
    private final InetSocketAddress virtualHost;
    private final Connection.Unsafe eaglerUnsafe;
    public final SimpleRateLimiter skinLookupRateLimiter;
    public final SimpleRateLimiter skinUUIDLookupRateLimiter;
    public final SimpleRateLimiter skinTextureDownloadRateLimiter;
    public final String origin;
    public final ClientCertificateHolder clientCertificate;
    public final Set<ClientCertificateHolder> certificatesToSend;
    public final TIntSet certificatesSent;

    public EaglerInitialHandler(BungeeCord bungee, ListenerInfo listener, final ChannelWrapper ch, int gameProtocolVersion, String username, UUID playerUUID, InetSocketAddress address, String host, String origin, ClientCertificateHolder clientCertificate) {
        super(bungee, listener);
        this.gameProtocolVersion = gameProtocolVersion;
        this.username = username;
        this.playerUUID = playerUUID;
        this.eaglerAddress = address;
        this.origin = origin;
        this.skinLookupRateLimiter = new SimpleRateLimiter();
        this.skinUUIDLookupRateLimiter = new SimpleRateLimiter();
        this.skinTextureDownloadRateLimiter = new SimpleRateLimiter();
        this.clientCertificate = clientCertificate;
        this.certificatesToSend = new HashSet<ClientCertificateHolder>();
        this.certificatesSent = new TIntHashSet();
        if (clientCertificate != null) {
            this.certificatesSent.add(clientCertificate.hashCode());
        }
        if (host == null) {
            host = "";
        }
        int port = 25565;
        if (host.contains(":")) {
            int ind = host.lastIndexOf(58);
            try {
                port = Integer.parseInt(host.substring(ind + 1));
                host = host.substring(0, ind);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.virtualHost = InetSocketAddress.createUnresolved(host, port);
        this.eaglerUnsafe = new Connection.Unsafe(){

            public void sendPacket(DefinedPacket arg0) {
                ch.getHandle().writeAndFlush((Object)arg0);
            }
        };
        this.setLoginProfile(new LoginResult(playerUUID.toString(), username, new Property[]{EaglerBungeeConfig.isEaglerProperty}));
        try {
            super.connected(ch);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setLoginProfile(LoginResult obj) {
        this.loginResult = obj;
        try {
            Field f = InitialHandler.class.getDeclaredField("loginProfile");
            f.setAccessible(true);
            f.set((Object)this, obj);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void handle(PacketWrapper packet) throws Exception {
    }

    public void handle(PluginMessage pluginMessage) throws Exception {
    }

    public void handle(LegacyHandshake legacyHandshake) throws Exception {
    }

    public void handle(LegacyPing ping) throws Exception {
    }

    public void handle(StatusRequest statusRequest) throws Exception {
    }

    public void handle(PingPacket ping) throws Exception {
    }

    public void handle(Handshake handshake) throws Exception {
    }

    public void handle(LoginRequest loginRequest) throws Exception {
    }

    public void handle(EncryptionResponse encryptResponse) throws Exception {
    }

    public void handle(LoginPayloadResponse response) throws Exception {
    }

    public void disconnect(String reason) {
        super.disconnect(reason);
    }

    public void disconnect(BaseComponent ... reason) {
        super.disconnect(reason);
    }

    public void disconnect(BaseComponent reason) {
        super.disconnect(reason);
    }

    public String getName() {
        return this.username;
    }

    public int getVersion() {
        return this.gameProtocolVersion;
    }

    public Handshake getHandshake() {
        return new Handshake(this.gameProtocolVersion, this.virtualHost.getHostName(), this.virtualHost.getPort(), this.gameProtocolVersion);
    }

    public LoginRequest getLoginRequest() {
        throw new UnsupportedOperationException("A plugin attempted to retrieve the LoginRequest packet from an EaglercraftX connection, which is not supported because Eaglercraft does not use online mode encryption. Please analyze the stack trace of this exception and reconfigure or remove the offending plugin to fix this issue.");
    }

    public PluginMessage getBrandMessage() {
        String brand = "EaglercraftX";
        byte[] pkt = new byte[brand.length() + 1];
        pkt[0] = (byte)brand.length();
        System.arraycopy(brand.getBytes(StandardCharsets.US_ASCII), 0, pkt, 1, brand.length());
        return new PluginMessage("MC|Brand", pkt, true);
    }

    public UUID getUniqueId() {
        return this.playerUUID;
    }

    public UUID getOfflineId() {
        return this.playerUUID;
    }

    public String getUUID() {
        return this.playerUUID.toString().replace("-", "");
    }

    public LoginResult getLoginProfile() {
        return this.loginResult;
    }

    public InetSocketAddress getVirtualHost() {
        return this.virtualHost;
    }

    public SocketAddress getSocketAddress() {
        return this.eaglerAddress;
    }

    public Connection.Unsafe unsafe() {
        return this.eaglerUnsafe;
    }

    public String getOrigin() {
        return this.origin;
    }

    public static class ClientCertificateHolder {
        public final byte[] data;
        public final int hash;

        public ClientCertificateHolder(byte[] data, int hash) {
            this.data = data;
            this.hash = hash;
        }
    }
}

