/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.RateLimitStatus;
import net.md_5.bungee.config.Configuration;

public class EaglerRateLimiter {
    private final int period;
    private final int limit;
    private final int limitLockout;
    private int effectiveLimit;
    private int effectiveLimitLockout;
    private final int lockoutDuration;
    private final List<String> exceptions;
    private final Map<String, RateLimiter> ratelimiters = new HashMap<String, RateLimiter>();

    private EaglerRateLimiter(int period, int limit, int limitLockout, int lockoutDuration, List<String> exceptions) {
        this.period = period * 1000 / limit;
        this.limit = this.effectiveLimit = limit;
        this.limitLockout = this.effectiveLimitLockout = limitLockout;
        this.lockoutDuration = lockoutDuration * 1000;
        this.exceptions = exceptions;
    }

    public void setDivisor(int d) {
        this.effectiveLimit = this.limit * d;
        this.effectiveLimitLockout = this.limitLockout * d;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getLimit() {
        return this.effectiveLimit;
    }

    public int getLimitLockout() {
        return this.effectiveLimitLockout;
    }

    public int getLockoutDuration() {
        return this.lockoutDuration;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public boolean isException(String addr) {
        int i = 0;
        int l = this.exceptions.size();
        while (i < l) {
            String str = this.exceptions.get(i);
            int ll = str.length() - 1;
            if (str.indexOf(42) == 0 ? addr.endsWith(str.substring(1)) : (str.lastIndexOf(42) == ll ? addr.startsWith(str.substring(ll)) : addr.equals(str))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateLimitStatus rateLimit(String addr) {
        RateLimiter limiter;
        if (this.isException(addr = addr.toLowerCase())) {
            return RateLimitStatus.OK;
        }
        Map<String, RateLimiter> map = this.ratelimiters;
        synchronized (map) {
            limiter = this.ratelimiters.get(addr);
            if (limiter == null) {
                limiter = new RateLimiter();
                this.ratelimiters.put(addr, limiter);
            }
        }
        return limiter.rateLimit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        long millis = System.currentTimeMillis();
        Map<String, RateLimiter> map = this.ratelimiters;
        synchronized (map) {
            Iterator<RateLimiter> itr = this.ratelimiters.values().iterator();
            while (itr.hasNext()) {
                RateLimiter i = itr.next();
                i.tick(millis);
                if (i.requestCounter > 0 || i.lockoutTimestamp > 0L) continue;
                itr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map<String, RateLimiter> map = this.ratelimiters;
        synchronized (map) {
            this.ratelimiters.clear();
        }
    }

    static EaglerRateLimiter loadConfig(Configuration config) {
        int period = config.getInt("period", -1);
        int limit = config.getInt("limit", -1);
        int limitLockout = config.getInt("limit_lockout", -1);
        int lockoutDuration = config.getInt("lockout_duration", -1);
        List exc = config.getList("exceptions");
        ArrayList<String> exceptions = new ArrayList<String>();
        for (String str : exc) {
            exceptions.add(str.toLowerCase());
        }
        if (period != -1 && limit != -1 && limitLockout != -1 && lockoutDuration != -1) {
            return new EaglerRateLimiter(period, limit, limitLockout, lockoutDuration, exceptions);
        }
        return null;
    }

    protected class RateLimiter {
        protected int requestCounter = 0;
        protected long lockoutTimestamp = 0L;
        protected long cooldownTimestamp = 0L;

        protected RateLimiter() {
        }

        protected RateLimitStatus rateLimit() {
            long millis = System.currentTimeMillis();
            this.tick(millis);
            if (this.lockoutTimestamp != 0L) {
                return RateLimitStatus.LOCKED_OUT;
            }
            if (++this.requestCounter > EaglerRateLimiter.this.effectiveLimitLockout) {
                this.lockoutTimestamp = millis;
                this.requestCounter = 0;
                return RateLimitStatus.LIMITED_NOW_LOCKED_OUT;
            }
            if (this.requestCounter > EaglerRateLimiter.this.effectiveLimit) {
                return RateLimitStatus.LIMITED;
            }
            return RateLimitStatus.OK;
        }

        protected void tick(long millis) {
            if (this.lockoutTimestamp != 0L) {
                if (millis - this.lockoutTimestamp > (long)EaglerRateLimiter.this.lockoutDuration) {
                    this.requestCounter = 0;
                    this.lockoutTimestamp = 0L;
                    this.cooldownTimestamp = millis;
                }
            } else {
                long delta = millis - this.cooldownTimestamp;
                long decr = delta / (long)EaglerRateLimiter.this.period;
                if (decr >= (long)this.requestCounter) {
                    this.requestCounter = 0;
                    this.cooldownTimestamp = millis;
                } else {
                    this.requestCounter = (int)((long)this.requestCounter - decr);
                    this.cooldownTimestamp += decr * (long)EaglerRateLimiter.this.period;
                    if (this.requestCounter < 0) {
                        this.requestCounter = 0;
                    }
                }
            }
        }
    }
}

