/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class AuthLoadingCache<K, V> {
    private final Map<K, CacheEntry<V>> cacheMap = new HashMap<K, CacheEntry<V>>();
    private final CacheLoader<K, V> provider;
    private final long cacheTTL;
    private long cacheTimer;

    public AuthLoadingCache(CacheLoader<K, V> provider, long cacheTTL) {
        this.provider = provider;
        this.cacheTTL = cacheTTL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        CacheEntry<V> etr;
        Map<K, CacheEntry<V>> map = this.cacheMap;
        synchronized (map) {
            etr = this.cacheMap.get(key);
        }
        if (etr == null) {
            V loaded = this.provider.load(key);
            Map<K, CacheEntry<V>> map2 = this.cacheMap;
            synchronized (map2) {
                this.cacheMap.put(key, new CacheEntry(loaded));
            }
            return loaded;
        }
        ((CacheEntry)etr).lastHit = System.currentTimeMillis();
        return (V)((CacheEntry)etr).instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(K key) {
        Map<K, CacheEntry<V>> map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll(CacheVisitor<K, V> visitor) {
        Map<K, CacheEntry<V>> map = this.cacheMap;
        synchronized (map) {
            Iterator<Map.Entry<K, CacheEntry<V>>> itr = this.cacheMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<K, CacheEntry<V>> etr = itr.next();
                if (!visitor.shouldEvict(etr.getKey(), ((CacheEntry)etr.getValue()).instance)) continue;
                itr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        long millis = System.currentTimeMillis();
        if (millis - this.cacheTimer > this.cacheTTL / 2L) {
            this.cacheTimer = millis;
            Map<K, CacheEntry<V>> map = this.cacheMap;
            synchronized (map) {
                Iterator<CacheEntry<V>> mapItr = this.cacheMap.values().iterator();
                while (mapItr.hasNext()) {
                    CacheEntry<V> etr = mapItr.next();
                    if (millis - ((CacheEntry)etr).lastHit <= this.cacheTTL) continue;
                    mapItr.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Map<K, CacheEntry<V>> map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.clear();
        }
    }

    private static class CacheEntry<V> {
        private long lastHit = System.currentTimeMillis();
        private V instance;

        private CacheEntry(V instance) {
            this.instance = instance;
        }
    }

    public static interface CacheLoader<K, V> {
        public V load(K var1);
    }

    public static interface CacheVisitor<K, V> {
        public boolean shouldEvict(K var1, V var2);
    }
}

