/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.gui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class TeaVMBinaries {
    public static final MavenJAREntry teavmCore = new MavenJAREntry("org/teavm/teavm-core/0.9.2/teavm-core-0.9.2.jar");
    public static final MavenJAREntry teavmCli = new MavenJAREntry("org/teavm/teavm-cli/0.9.2/teavm-cli-0.9.2.jar");
    public static final MavenJAREntry teavmTooling = new MavenJAREntry("org/teavm/teavm-tooling/0.9.2/teavm-tooling-0.9.2.jar");
    public static final MavenJAREntry teavmPlatform = new MavenJAREntry("org/teavm/teavm-platform/0.9.2/teavm-platform-0.9.2.jar");
    public static final MavenJAREntry teavmClasslib = new MavenJAREntry("org/teavm/teavm-classlib/0.9.2/teavm-classlib-0.9.2.jar");
    public static final MavenJAREntry teavmInterop = new MavenJAREntry("org/teavm/teavm-interop/0.9.2/teavm-interop-0.9.2.jar");
    public static final MavenJAREntry teavmJSO = new MavenJAREntry("org/teavm/teavm-jso/0.9.2/teavm-jso-0.9.2.jar");
    public static final MavenJAREntry teavmJSOApis = new MavenJAREntry("org/teavm/teavm-jso-apis/0.9.2/teavm-jso-apis-0.9.2.jar");
    public static final MavenJAREntry teavmJSOImpl = new MavenJAREntry("org/teavm/teavm-jso-impl/0.9.2/teavm-jso-impl-0.9.2.jar");
    public static final MavenJAREntry teavmRelocatedLibsASM = new MavenJAREntry("org/teavm/teavm-relocated-libs-asm/0.9.2/teavm-relocated-libs-asm-0.9.2.jar");
    public static final MavenJAREntry teavmRelocatedLibsASMAnalysis = new MavenJAREntry("org/teavm/teavm-relocated-libs-asm-analysis/0.9.2/teavm-relocated-libs-asm-analysis-0.9.2.jar");
    public static final MavenJAREntry teavmRelocatedLibsASMCommons = new MavenJAREntry("org/teavm/teavm-relocated-libs-asm-commons/0.9.2/teavm-relocated-libs-asm-commons-0.9.2.jar");
    public static final MavenJAREntry teavmRelocatedLibsASMTree = new MavenJAREntry("org/teavm/teavm-relocated-libs-asm-tree/0.9.2/teavm-relocated-libs-asm-tree-0.9.2.jar");
    public static final MavenJAREntry teavmRelocatedLibsASMUtil = new MavenJAREntry("org/teavm/teavm-relocated-libs-asm-util/0.9.2/teavm-relocated-libs-asm-util-0.9.2.jar");
    public static final MavenJAREntry teavmRelocatedLibsHPPC = new MavenJAREntry("org/teavm/teavm-relocated-libs-hppc/0.9.2/teavm-relocated-libs-hppc-0.9.2.jar");
    public static final MavenJAREntry teavmRelocatedLibsRhino = new MavenJAREntry("org/teavm/teavm-relocated-libs-rhino/0.9.2/teavm-relocated-libs-rhino-0.9.2.jar");
    public static final MavenJAREntry asm = new MavenJAREntry("org/ow2/asm/asm/9.5/asm-9.5.jar");
    public static final MavenJAREntry asmAnalysis = new MavenJAREntry("org/ow2/asm/asm-analysis/9.5/asm-analysis-9.5.jar");
    public static final MavenJAREntry asmCommons = new MavenJAREntry("org/ow2/asm/asm-commons/9.5/asm-commons-9.5.jar");
    public static final MavenJAREntry asmTree = new MavenJAREntry("org/ow2/asm/asm-tree/9.5/asm-tree-9.5.jar");
    public static final MavenJAREntry asmUtil = new MavenJAREntry("org/ow2/asm/asm-util/9.5/asm-util-9.5.jar");
    public static final MavenJAREntry hppc = new MavenJAREntry("com/carrotsearch/hppc/0.9.1/hppc-0.9.1.jar");
    public static final MavenJAREntry rhino = new MavenJAREntry("org/mozilla/rhino/1.7.14/rhino-1.7.14.jar");
    public static final MavenJAREntry teavmMetaprogrammingAPI = new MavenJAREntry("org/teavm/teavm-metaprogramming-api/0.9.2/teavm-metaprogramming-api-0.9.2.jar");
    public static final MavenJAREntry teavmMetaprogrammingImpl = new MavenJAREntry("org/teavm/teavm-metaprogramming-impl/0.9.2/teavm-metaprogramming-impl-0.9.2.jar");
    public static final MavenJAREntry teavmJodaTime = new MavenJAREntry("joda-time/joda-time/2.12.2/joda-time-2.12.2.jar");
    public static final MavenJAREntry teavmJZLIB = new MavenJAREntry("com/jcraft/jzlib/1.1.3/jzlib-1.1.3.jar");
    private static final MavenJAREntry[] jarsList = new MavenJAREntry[]{teavmCore, teavmCli, teavmTooling, teavmPlatform, teavmClasslib, teavmInterop, teavmJSO, teavmJSOApis, teavmJSOImpl, teavmRelocatedLibsASM, teavmRelocatedLibsASMAnalysis, teavmRelocatedLibsASMCommons, teavmRelocatedLibsASMTree, teavmRelocatedLibsASMUtil, teavmRelocatedLibsHPPC, teavmRelocatedLibsRhino, asm, asmAnalysis, asmCommons, asmTree, asmUtil, hppc, rhino, teavmMetaprogrammingAPI, teavmMetaprogrammingImpl, teavmJodaTime, teavmJZLIB};
    public static File teavmBridge = null;

    public static void downloadFromMaven(String string, File file) throws MissingJARsException {
        int n = 0;
        while (n < jarsList.length) {
            TeaVMBinaries.jarsList[n].file = null;
            ++n;
        }
        if (string.lastIndexOf(47) != string.length() - 1) {
            string = String.valueOf(string) + "/";
        }
        n = 0;
        while (n < jarsList.length) {
            MavenJAREntry mavenJAREntry = jarsList[n];
            String string2 = String.valueOf(string) + mavenJAREntry.maven;
            try {
                File file2 = new File(file, mavenJAREntry.jar);
                TeaVMBinaries.copyURLToFileCheck404(string2, file2);
                mavenJAREntry.file = file2;
            }
            catch (IOException iOException) {
                System.err.println("Could not download JAR: " + string2);
                iOException.printStackTrace();
                throw new MissingJARsException("The following JAR file could not be downloaded: " + string2, Arrays.asList(string2));
            }
            ++n;
        }
    }

    public static void loadFromDirectory(File file) throws MissingJARsException {
        int n = 0;
        while (n < jarsList.length) {
            TeaVMBinaries.jarsList[n].file = null;
            ++n;
        }
        TeaVMBinaries.discoverJars(file);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < jarsList.length) {
            MavenJAREntry mavenJAREntry = jarsList[n2];
            if (mavenJAREntry.file == null) {
                arrayList.add(mavenJAREntry.jar);
            }
            ++n2;
        }
        if (arrayList.size() > 0) {
            throw new MissingJARsException(arrayList);
        }
    }

    private static void discoverJars(File file) {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            if (file2.isDirectory()) {
                TeaVMBinaries.discoverJars(file2);
            } else {
                String string = file2.getName();
                int n2 = 0;
                while (n2 < jarsList.length) {
                    if (string.equals(TeaVMBinaries.jarsList[n2].jar)) {
                        TeaVMBinaries.jarsList[n2].file = file2;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private static void copyURLToFileCheck404(String string, File file) throws IOException {
        URL uRL;
        System.out.println("downloading: " + string);
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("Invalid URL: " + string, malformedURLException);
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(5000);
        httpURLConnection.setReadTimeout(5000);
        int n = httpURLConnection.getResponseCode();
        if (n != 200) {
            httpURLConnection.disconnect();
            throw new IOException("Recieved response code: " + n);
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream inputStream = httpURLConnection.getInputStream();){
                FileUtils.copyInputStreamToFile(inputStream, file);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    public static boolean tryLoadTeaVMBridge() {
        File file;
        String string = System.getProperty("eaglercraft.TeaVMBridge");
        if (string != null) {
            file = new File(string);
        } else {
            try {
                file = new File(new File(URLDecoder.decode(TeaVMBinaries.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath(), "UTF-8")).getParent(), "TeaVMBridge.jar");
            }
            catch (UnsupportedEncodingException | URISyntaxException exception) {
                System.err.println("Failed to locate TeaVMBridge.jar relative to BuildTools jar!");
                exception.printStackTrace();
                return false;
            }
        }
        if (file.exists()) {
            teavmBridge = file;
            return true;
        }
        System.err.println("File does not exist: " + file.getAbsolutePath());
        return false;
    }

    public static File[] getTeaVMCompilerClasspath() {
        return new File[]{TeaVMBinaries.teavmCore.file, TeaVMBinaries.teavmCli.file, TeaVMBinaries.teavmTooling.file, TeaVMBinaries.teavmInterop.file, TeaVMBinaries.teavmRelocatedLibsASM.file, TeaVMBinaries.teavmRelocatedLibsASMAnalysis.file, TeaVMBinaries.teavmRelocatedLibsASMCommons.file, TeaVMBinaries.teavmRelocatedLibsASMTree.file, TeaVMBinaries.teavmRelocatedLibsASMUtil.file, TeaVMBinaries.teavmRelocatedLibsHPPC.file, TeaVMBinaries.teavmRelocatedLibsRhino.file, TeaVMBinaries.asm.file, TeaVMBinaries.asmAnalysis.file, TeaVMBinaries.asmCommons.file, TeaVMBinaries.asmTree.file, TeaVMBinaries.asmUtil.file, TeaVMBinaries.hppc.file, TeaVMBinaries.rhino.file, TeaVMBinaries.teavmMetaprogrammingAPI.file, teavmBridge};
    }

    public static String[] getTeaVMRuntimeClasspath() {
        return new String[]{TeaVMBinaries.teavmJodaTime.file.getAbsolutePath(), TeaVMBinaries.teavmJZLIB.file.getAbsolutePath(), TeaVMBinaries.teavmClasslib.file.getAbsolutePath(), TeaVMBinaries.teavmInterop.file.getAbsolutePath(), TeaVMBinaries.teavmJSO.file.getAbsolutePath(), TeaVMBinaries.teavmJSOApis.file.getAbsolutePath(), TeaVMBinaries.teavmJSOImpl.file.getAbsolutePath(), TeaVMBinaries.teavmMetaprogrammingAPI.file.getAbsolutePath(), TeaVMBinaries.teavmMetaprogrammingImpl.file.getAbsolutePath(), TeaVMBinaries.teavmPlatform.file.getAbsolutePath()};
    }

    public static class MavenJAREntry {
        public final String jar;
        public final String maven;
        public File file;

        private MavenJAREntry(String string) {
            this.jar = string.substring(string.lastIndexOf(47) + 1);
            this.maven = string;
        }
    }

    public static class MissingJARsException
    extends RuntimeException {
        public final List<String> jars;

        public MissingJARsException(String string, List<String> list) {
            super(string);
            this.jars = list;
        }

        public MissingJARsException(List<String> list) {
            this("The following JAR files were not found: " + String.join((CharSequence)", ", list), list);
        }
    }
}

