/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.lax1dude.eaglercraft.v1_8.buildtools.FileChooserTool;
import org.json.JSONObject;

public class EaglerBuildToolsConfig {
    public static File temporary_directory = new File(System.getProperty("user.home"), ".eaglercraft_1.8_buildtools");
    private static boolean temporary_directory_isInit = false;
    private static boolean temporary_directory_mentioned = false;
    public static File workspace_directory = new File("../eaglercraft_1.8_workspace");
    private static boolean workspace_directory_isInit = false;
    private static boolean workspace_directory_mentioned = false;
    private static boolean config_file_loaded = false;
    public static final File configFile = new File("./buildtools_config.json");

    public static void load() {
        if (configFile.exists()) {
            try {
                Throwable throwable = null;
                Object var1_3 = null;
                try (FileInputStream fileInputStream = new FileInputStream(configFile);){
                    byte[] byArray = new byte[(int)configFile.length()];
                    fileInputStream.read(byArray);
                    fileInputStream.close();
                    String string = new String(byArray, StandardCharsets.UTF_8);
                    JSONObject jSONObject = new JSONObject(string);
                    String string2 = jSONObject.optString("temporary_directory", null);
                    if (string2 != null) {
                        temporary_directory = new File(string2);
                        temporary_directory_isInit = true;
                    }
                    if ((string2 = jSONObject.optString("workspace_directory", null)) != null) {
                        workspace_directory = new File(string2);
                        workspace_directory_isInit = true;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                System.err.println("Failed to read config!");
                throwable.printStackTrace();
            }
        }
    }

    public static void save() {
        JSONObject jSONObject = new JSONObject();
        if (temporary_directory_isInit) {
            jSONObject.put("temporary_directory", temporary_directory.getAbsolutePath());
        }
        if (workspace_directory_isInit) {
            jSONObject.put("workspace_directory", workspace_directory.getAbsoluteFile());
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(configFile);){
                fileOutputStream.write(jSONObject.toString(4).getBytes(StandardCharsets.UTF_8));
                fileOutputStream.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to write config!");
            iOException.printStackTrace();
        }
    }

    private static void mentionConfigPath() {
        System.out.println("Edit '" + configFile.getName() + "' to change");
    }

    public static File getTemporaryDirectory() {
        if (!config_file_loaded) {
            EaglerBuildToolsConfig.load();
            config_file_loaded = true;
        }
        if (!temporary_directory_isInit) {
            File file = temporary_directory;
            System.out.println();
            System.out.println("Using temporary directory: " + file.getAbsolutePath());
            temporary_directory_mentioned = true;
            temporary_directory = file = EaglerBuildToolsConfig.askIfChangeIsWanted(file);
            temporary_directory_isInit = true;
            while (!temporary_directory.isDirectory() && !temporary_directory.mkdirs()) {
                System.err.println("Failed to create: " + file.getAbsolutePath());
                temporary_directory = EaglerBuildToolsConfig.askIfChangeIsWanted(file);
            }
            EaglerBuildToolsConfig.save();
            System.out.println();
            return temporary_directory;
        }
        if (!temporary_directory_mentioned) {
            System.out.println("Using temporary directory: " + temporary_directory.getAbsolutePath());
            temporary_directory_mentioned = true;
            while (!temporary_directory.isDirectory() && !temporary_directory.mkdirs()) {
                System.err.println("Failed to create: " + temporary_directory.getAbsolutePath());
                temporary_directory = EaglerBuildToolsConfig.askIfChangeIsWanted(temporary_directory);
            }
            EaglerBuildToolsConfig.mentionConfigPath();
        }
        return temporary_directory;
    }

    public static File getWorkspaceDirectory() {
        if (!config_file_loaded) {
            EaglerBuildToolsConfig.load();
            config_file_loaded = true;
        }
        if (!workspace_directory_isInit) {
            File file = workspace_directory;
            System.out.println();
            System.out.println("Using workspace directory: " + file.getAbsolutePath());
            workspace_directory_mentioned = true;
            workspace_directory = file = EaglerBuildToolsConfig.askIfChangeIsWanted(file);
            workspace_directory_isInit = true;
            while (!workspace_directory.isDirectory() && !workspace_directory.mkdirs()) {
                System.err.println("Failed to create: " + file.getAbsolutePath());
                workspace_directory = EaglerBuildToolsConfig.askIfChangeIsWanted(file);
            }
            EaglerBuildToolsConfig.save();
            System.out.println();
            return workspace_directory;
        }
        if (!workspace_directory_mentioned) {
            System.out.println("Using workspace directory: " + workspace_directory.getAbsolutePath());
            workspace_directory_mentioned = true;
            while (!workspace_directory.isDirectory() && !workspace_directory.mkdirs()) {
                System.err.println("Failed to create: " + workspace_directory.getAbsolutePath());
                workspace_directory = EaglerBuildToolsConfig.askIfChangeIsWanted(workspace_directory);
            }
            EaglerBuildToolsConfig.mentionConfigPath();
        }
        return workspace_directory;
    }

    public static File askIfChangeIsWanted(File file) {
        System.out.println("Would you like to change this directory?");
        System.out.println("Enter 'Y' for yes or 'N' for no: ");
        String string = "N";
        try {
            string = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException iOException) {}
        if (string != null && ((string = string.trim()).equalsIgnoreCase("y") || string.equalsIgnoreCase("yes"))) {
            System.out.println();
            System.out.println("Type a new filename or hit 'Enter' to browse: ");
            try {
                string = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            catch (IOException iOException) {}
            if (string != null && (string = string.trim()).length() > 0) {
                file = new File(string);
            } else {
                File file2 = FileChooserTool.load(true);
                if (file2 == null) {
                    System.out.println("You hit cancel on the file chooser, the directory '" + file.getAbsolutePath() + "' will be used.");
                    file = EaglerBuildToolsConfig.askIfChangeIsWanted(file);
                } else {
                    file = file2;
                }
            }
        }
        return file;
    }
}

