/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.media.audio;

import dev.onvoid.webrtc.internal.DisposableNativeObject;
import dev.onvoid.webrtc.internal.NativeLoader;
import dev.onvoid.webrtc.media.audio.AudioProcessingConfig;
import dev.onvoid.webrtc.media.audio.AudioProcessingStats;
import dev.onvoid.webrtc.media.audio.AudioProcessingStreamConfig;

public class AudioProcessing
extends DisposableNativeObject {
    private final AudioProcessingStats stats = new AudioProcessingStats();

    public AudioProcessing() {
        this.initialize();
    }

    public AudioProcessingStats getStatistics() {
        this.updateStats();
        return this.stats;
    }

    public int getTargetBufferSize(AudioProcessingStreamConfig inputConfig, AudioProcessingStreamConfig outputConfig) {
        int nSamplesIn = inputConfig.sampleRate / 100;
        int nSamplesOut = outputConfig.sampleRate / 100;
        return Math.max(nSamplesIn, nSamplesOut) * outputConfig.channels * 2;
    }

    public native void applyConfig(AudioProcessingConfig var1);

    public native void setStreamDelayMs(int var1);

    public native int getStreamDelayMs();

    public native int processStream(byte[] var1, AudioProcessingStreamConfig var2, AudioProcessingStreamConfig var3, byte[] var4);

    public native int processReverseStream(byte[] var1, AudioProcessingStreamConfig var2, AudioProcessingStreamConfig var3, byte[] var4);

    @Override
    public native void dispose();

    private native void initialize();

    private native void updateStats();

    static {
        try {
            NativeLoader.loadLibrary("webrtc-java");
        }
        catch (Exception e) {
            throw new RuntimeException("Load library 'webrtc-java' failed", e);
        }
    }
}

