/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.media.audio;

import dev.onvoid.webrtc.internal.DisposableNativeObject;

public class AudioConverter
extends DisposableNativeObject {
    private final int srcSamples;
    private final int dstSamples;
    private final int dstSamplesOut;

    public AudioConverter(int srcSampleRate, int srcChannels, int dstSampleRate, int dstChannels) {
        this.srcSamples = srcSampleRate / 100 * srcChannels;
        this.dstSamples = Math.max(srcSampleRate, dstSampleRate) / 100 * dstChannels;
        this.dstSamplesOut = dstSampleRate / 100 * dstChannels;
        this.initialize(srcSampleRate, srcChannels, dstSampleRate, dstChannels);
    }

    public int getTargetBufferSize() {
        return this.dstSamples * 2;
    }

    public int convert(byte[] src, byte[] dst) {
        if (src.length / 2 < this.srcSamples) {
            throw new IllegalArgumentException(String.format("Insufficient samples input length: %d vs. %d", src.length / 2, this.srcSamples));
        }
        if (dst.length / 2 < this.dstSamples) {
            throw new IllegalArgumentException(String.format("Insufficient samples output length: %d vs. %d", dst.length / 2, this.dstSamples));
        }
        this.convertInternal(src, this.srcSamples, dst, this.dstSamples);
        return this.dstSamplesOut;
    }

    @Override
    public native void dispose();

    private native void initialize(int var1, int var2, int var3, int var4);

    public native void convertInternal(byte[] var1, int var2, byte[] var3, int var4);
}

