package net.lax1dude.eaglercraft.v1_8.opengl.ext.deferred;

import java.io.IOException;

import net.lax1dude.eaglercraft.v1_8.log4j.LogManager;
import net.lax1dude.eaglercraft.v1_8.log4j.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;

/**
 * Copyright (c) 2023 lax1dude. All Rights Reserved.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 */
public class ShaderPackInfoReloadListener implements IResourceManagerReloadListener {

	private static final Logger logger = LogManager.getLogger();

	@Override
	public void onResourceManagerReload(IResourceManager mcResourceManager) {
		Minecraft mc = Minecraft.getMinecraft();
		try {
			mc.gameSettings.deferredShaderConf.reloadShaderPackInfo(mcResourceManager);
		}catch(IOException ex) {
			logger.info("Could not reload shader pack info!");
			logger.info(ex);
			logger.info("Shaders have been disabled");
			mc.gameSettings.shaders = false;
		}
		TextureMap tm = mc.getTextureMapBlocks();
		if(tm != null) {
			mc.getTextureMapBlocks().setEnablePBREagler(mc.gameSettings.shaders);
		}
	}

}
