/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.teavm;

import java.util.List;
import java.util.Map;
import org.teavm.diagnostics.Problem;
import org.teavm.diagnostics.ProblemProvider;
import org.teavm.tooling.TeaVMTargetType;
import org.teavm.tooling.builder.BuildException;
import org.teavm.tooling.builder.BuildResult;
import org.teavm.tooling.builder.InProcessBuildStrategy;
import org.teavm.vm.TeaVMOptimizationLevel;
import org.teavm.vm.TeaVMPhase;
import org.teavm.vm.TeaVMProgressFeedback;
import org.teavm.vm.TeaVMProgressListener;

public class TeaVMBridgeImpl {
    static {
        System.out.println("[TeaVMBridge] Class was loaded");
    }

    public static boolean compileTeaVM(Map<String, Object> map) throws RuntimeException {
        System.out.println();
        System.out.println("[TeaVMBridge] Configuring InProcessBuildStrategy:");
        for (Map.Entry<String, Object> inProcessBuildStrategy2 : map.entrySet()) {
            System.out.println("[TeaVMBridge]     " + inProcessBuildStrategy2.getKey() + " = " + inProcessBuildStrategy2.getValue());
        }
        System.out.println();
        InProcessBuildStrategy inProcessBuildStrategy = new InProcessBuildStrategy();
        long l = System.currentTimeMillis();
        BuildResult buildResult = null;
        inProcessBuildStrategy.setClassPathEntries((List)map.get("classPathEntries"));
        inProcessBuildStrategy.setDebugInformationGenerated(false);
        inProcessBuildStrategy.setEntryPointName((String)map.get("entryPointName"));
        inProcessBuildStrategy.setMainClass((String)map.get("mainClass"));
        inProcessBuildStrategy.setMaxTopLevelNames(16000);
        inProcessBuildStrategy.setObfuscated(((Boolean)map.get("minifying")).booleanValue());
        inProcessBuildStrategy.setOptimizationLevel(TeaVMOptimizationLevel.valueOf((String)((String)map.get("optimizationLevel"))));
        inProcessBuildStrategy.setSourceFilesCopied(false);
        inProcessBuildStrategy.setSourceMapsFileGenerated(((Boolean)map.get("generateSourceMaps")).booleanValue());
        inProcessBuildStrategy.setTargetDirectory((String)map.get("targetDirectory"));
        inProcessBuildStrategy.setTargetFileName((String)map.get("targetFileName"));
        inProcessBuildStrategy.setTargetType(TeaVMTargetType.JAVASCRIPT);
        inProcessBuildStrategy.setProgressListener(new TeaVMProgressListener(){

            public TeaVMProgressFeedback progressReached(int n) {
                return TeaVMProgressFeedback.CONTINUE;
            }

            public TeaVMProgressFeedback phaseStarted(TeaVMPhase teaVMPhase, int n) {
                if (teaVMPhase == TeaVMPhase.DEPENDENCY_ANALYSIS) {
                    System.out.println("[TeaVMBridge] Analyzing dependencies...");
                } else if (teaVMPhase == TeaVMPhase.COMPILING) {
                    System.out.println("[TeaVMBridge] Running compiler...");
                }
                return TeaVMProgressFeedback.CONTINUE;
            }
        });
        try {
            buildResult = inProcessBuildStrategy.build();
        }
        catch (BuildException throwable) {
            throw new RuntimeException("[TeaVMBridge] BuildException thrown while building!", throwable.getCause());
        }
        catch (Throwable bl) {
            throw new RuntimeException("[TeaVMBridge] Unhandled exception thrown while building!", bl);
        }
        System.out.println();
        System.out.println("[TeaVMBridge] Build complete! Took " + (System.currentTimeMillis() - l) / 1000L + " seconds");
        boolean bl = false;
        ProblemProvider problemProvider = buildResult.getProblems();
        if (problemProvider != null) {
            List list;
            int n;
            List list2 = problemProvider.getProblems();
            if (list2 != null && list2.size() > 0) {
                bl = true;
                System.err.println("[TeaVMBridge] Encountered " + list2.size() + " problems while building:");
                int list3 = 0;
                n = list2.size();
                while (list3 < n) {
                    Problem n3 = (Problem)list2.get(list3);
                    System.err.println("[TeaVMBridge]     - " + n3.getSeverity() + ": " + n3.getClass() + " : " + n3.getLocation() + " - " + n3.getText() + " - params: " + TeaVMBridgeImpl.collectionToString(n3.getParams()));
                    ++list3;
                }
                System.err.println();
            }
            if ((list = problemProvider.getSevereProblems()) != null && list.size() > 0) {
                bl = true;
                System.err.println("[TeaVMBridge] Encountered " + list.size() + " high-severity problems while building:");
                n = 0;
                int n2 = list.size();
                while (n < n2) {
                    Problem problem = (Problem)list.get(n);
                    System.err.println("[TeaVMBridge]     - " + problem.getSeverity() + ": " + problem.getClass() + " : " + problem.getLocation() + " - " + problem.getText() + " - params: " + TeaVMBridgeImpl.collectionToString(problem.getParams()));
                    ++n;
                }
                System.err.println();
            }
        }
        return !bl;
    }

    private static String collectionToString(Object[] objectArray) {
        if (objectArray.length == 0) {
            return "[ ]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        int n = 0;
        while (n < objectArray.length) {
            if (n > 0) {
                stringBuilder.append(" , ");
            }
            stringBuilder.append(objectArray[n]);
            ++n;
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

