/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.placeholder_server;

import java.nio.ByteBuffer;
import net.lax1dude.eaglercraft.v1_8.placeholder_server.PlaceholderServerConfig;
import org.java_websocket.WebSocket;
import org.json.JSONArray;
import org.json.JSONObject;

public class DummyConnection {
    public final long age = System.currentTimeMillis();
    public long sendRedirectAt = 0L;
    public final WebSocket sock;
    private boolean hasFirstPacket = false;

    public DummyConnection(WebSocket sock) {
        this.sock = sock;
    }

    public void processString(String str) {
        if (!this.hasFirstPacket) {
            this.hasFirstPacket = true;
            if ((str = str.toLowerCase()).startsWith("accept:") && (str = str.substring(7).trim()).startsWith("motd")) {
                String subType = "motd";
                int i = str.indexOf(46);
                if (i > 0 && i != str.length() - 1) {
                    subType = str.substring(i + 1);
                }
                JSONObject json = new JSONObject();
                json.put("name", PlaceholderServerConfig.serverName);
                json.put("brand", "lax1dude");
                json.put("vers", "EaglerXPlaceholder/1.0");
                json.put("cracked", true);
                json.put("secure", false);
                json.put("time", System.currentTimeMillis());
                json.put("uuid", PlaceholderServerConfig.serverUUID);
                json.put("type", str);
                JSONObject motdData = new JSONObject();
                boolean icon = false;
                if (subType.startsWith("cache.anim")) {
                    motdData.put("unsupported", true);
                } else {
                    if (subType.startsWith("cache")) {
                        JSONArray arr = new JSONArray();
                        arr.put("animation");
                        arr.put("results");
                        arr.put("trending");
                        arr.put("portfolio");
                        motdData.put("cache", arr);
                        motdData.put("ttl", 7200);
                    } else {
                        motdData.put("cache", true);
                    }
                    JSONArray motdLines = new JSONArray();
                    String motd1 = PlaceholderServerConfig.motd1;
                    String motd2 = PlaceholderServerConfig.motd2;
                    if (motd1 != null && motd1.length() > 0) {
                        motdLines.put(motd1);
                    }
                    if (motd2 != null && motd2.length() > 0) {
                        motdLines.put(motd2);
                    }
                    motdData.put("motd", motdLines);
                    icon = PlaceholderServerConfig.cachedIconPacket != null && !subType.startsWith("noicon") && !subType.startsWith("cache.noicon");
                    motdData.put("icon", icon);
                    motdData.put("online", 0);
                    motdData.put("max", 0);
                    motdData.put("players", new JSONArray());
                }
                json.put("data", motdData);
                this.sock.send(json.toString());
                if (icon) {
                    this.sock.send(PlaceholderServerConfig.cachedIconPacket);
                }
            }
            this.sock.close();
        }
    }

    public void processBinary(ByteBuffer bin) {
        if (!this.hasFirstPacket) {
            this.hasFirstPacket = true;
            if (bin.remaining() > 2) {
                if (bin.get(0) == 2 && bin.get(1) == 69) {
                    this.sock.send(PlaceholderServerConfig.cachedLegacyKickRedirectPacket);
                    this.sendRedirectAt = System.currentTimeMillis();
                    return;
                }
                if (bin.get(0) == 1) {
                    this.sock.send(PlaceholderServerConfig.cachedKickPacket);
                }
            }
            this.sock.close();
        }
    }
}

