/*
 * Decompiled with CFR 0.152.
 */
package dev.onvoid.webrtc.logging;

import dev.onvoid.webrtc.internal.NativeLoader;
import dev.onvoid.webrtc.logging.LogSink;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Logging {
    public static native void addLogSink(Severity var0, LogSink var1);

    public static native void log(Severity var0, String var1);

    public static native void logToDebug(Severity var0);

    public static native void logThreads(boolean var0);

    public static native void logTimestamps(boolean var0);

    public static void verbose(String message) {
        Logging.log(Severity.VERBOSE, message);
    }

    public static void info(String message) {
        Logging.log(Severity.INFO, message);
    }

    public static void warn(String message) {
        Logging.log(Severity.WARNING, message);
    }

    public static void error(String message) {
        Logging.log(Severity.ERROR, message);
    }

    public static void error(String message, Throwable e) {
        Logging.log(Severity.ERROR, message);
        Logging.log(Severity.ERROR, e.toString());
        Logging.log(Severity.ERROR, Logging.getStackTraceString(e));
    }

    private static String getStackTraceString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    static {
        try {
            NativeLoader.loadLibrary("webrtc-java");
        }
        catch (Exception e) {
            throw new RuntimeException("Load library 'webrtc-java' failed", e);
        }
    }

    public static enum Severity {
        VERBOSE,
        INFO,
        WARNING,
        ERROR,
        NONE;

    }
}

