/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.sqlite;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import org.codehaus.plexus.util.FileUtils;

public class EaglerDrivers {
    private static final Map<String, URLClassLoader> driversJARs = new HashMap<String, URLClassLoader>();
    private static final Map<String, Driver> driversDrivers = new HashMap<String, Driver>();

    private static Driver initializeDriver(String address, String driverClass) {
        Class<?> loadedDriver;
        URLClassLoader classLoader = driversJARs.get(address);
        if (classLoader == null) {
            URL driverURL;
            File driver;
            if (address.equalsIgnoreCase("internal")) {
                driver = new File(EaglerXBungee.getEagler().getDataFolder(), "drivers/sqlite-jdbc.jar");
                driver.getParentFile().mkdirs();
                if (!driver.exists()) {
                    try {
                        URL u = new URL("https://repo1.maven.org/maven2/org/xerial/sqlite-jdbc/3.45.0.0/sqlite-jdbc-3.45.0.0.jar");
                        EaglerXBungee.logger().info("Downloading from maven: " + u.toString());
                        FileUtils.copyURLToFile((URL)u, (File)driver);
                    }
                    catch (Throwable ex) {
                        EaglerXBungee.logger().severe("Could not download sqlite-jdbc.jar from repo1.maven.org!");
                        EaglerXBungee.logger().severe("Please download \"org.xerial:sqlite-jdbc:3.45.0.0\" jar to file: " + driver.getAbsolutePath());
                        throw new ExceptionInInitializerError(ex);
                    }
                }
            } else {
                driver = new File(address);
            }
            try {
                driverURL = driver.toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                EaglerXBungee.logger().severe("Invalid JDBC driver path: " + address);
                throw new ExceptionInInitializerError(ex2);
            }
            classLoader = new URLClassLoader(new URL[]{driverURL}, ClassLoader.getSystemClassLoader());
            driversJARs.put(address, classLoader);
        }
        try {
            loadedDriver = classLoader.loadClass(driverClass);
        }
        catch (ClassNotFoundException ex) {
            try {
                classLoader.close();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            EaglerXBungee.logger().severe("Could not find JDBC driver class: " + driverClass);
            throw new ExceptionInInitializerError(ex);
        }
        Driver sqlDriver = null;
        try {
            sqlDriver = (Driver)loadedDriver.newInstance();
        }
        catch (Throwable ex) {
            try {
                classLoader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            EaglerXBungee.logger().severe("Could not initialize JDBC driver class: " + driverClass);
            throw new ExceptionInInitializerError(ex);
        }
        return sqlDriver;
    }

    public static Connection connectToDatabase(String address, String driverClass, String driverPath, Properties props) throws SQLException {
        if (driverClass.equalsIgnoreCase("internal")) {
            driverClass = "org.sqlite.JDBC";
        }
        if (driverPath == null) {
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException("Driver class not found in JRE: " + driverClass, e);
            }
            return DriverManager.getConnection(address, props);
        }
        String driverMapPath = driverPath + "?" + driverClass;
        Driver dv = driversDrivers.get(driverMapPath);
        if (dv == null) {
            dv = EaglerDrivers.initializeDriver(driverPath, driverClass);
            driversDrivers.put(driverMapPath, dv);
        }
        return dv.connect(address, props);
    }
}

