/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ISkinService;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinService;
import net.md_5.bungee.UserConnection;

public class SkinPackets {
    public static final int PACKET_MY_SKIN_PRESET = 1;
    public static final int PACKET_MY_SKIN_CUSTOM = 2;
    public static final int PACKET_GET_OTHER_SKIN = 3;
    public static final int PACKET_OTHER_SKIN_PRESET = 4;
    public static final int PACKET_OTHER_SKIN_CUSTOM = 5;
    public static final int PACKET_GET_SKIN_BY_URL = 6;
    private static final String hex = "0123456789abcdef";

    public static void processPacket(byte[] data, UserConnection sender, ISkinService skinService) throws IOException {
        if (data.length == 0) {
            throw new IOException("Zero-length packet recieved");
        }
        int packetId = data[0] & 0xFF;
        try {
            switch (packetId) {
                case 3: {
                    SkinPackets.processGetOtherSkin(data, sender, skinService);
                    break;
                }
                case 6: {
                    SkinPackets.processGetOtherSkinByURL(data, sender, skinService);
                    break;
                }
                default: {
                    throw new IOException("Unknown packet type " + packetId);
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new IOException("Unhandled exception handling packet type " + packetId, t);
        }
    }

    private static void processGetOtherSkin(byte[] data, UserConnection sender, ISkinService skinService) throws IOException {
        if (data.length != 17) {
            throw new IOException("Invalid length " + data.length + " for skin request packet");
        }
        UUID searchUUID = SkinPackets.bytesToUUID(data, 1);
        skinService.processGetOtherSkin(searchUUID, sender);
    }

    private static void processGetOtherSkinByURL(byte[] data, UserConnection sender, ISkinService skinService) throws IOException {
        URL url;
        if (data.length < 20) {
            throw new IOException("Invalid length " + data.length + " for skin request packet");
        }
        UUID searchUUID = SkinPackets.bytesToUUID(data, 1);
        int urlLength = data[17] << 8 | data[18];
        if (data.length < 19 + urlLength) {
            throw new IOException("Invalid length " + data.length + " for skin request packet with " + urlLength + " length URL");
        }
        String urlStr = SkinPackets.bytesToAscii(data, 19, urlLength);
        if ((urlStr = SkinService.sanitizeTextureURL(urlStr)) == null) {
            throw new IOException("Invalid URL for skin request packet");
        }
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException t) {
            throw new IOException("Invalid URL for skin request packet", t);
        }
        String host = url.getHost();
        if (EaglerXBungee.getEagler().getConfig().isValidSkinHost(host)) {
            UUID validUUID = SkinPackets.createEaglerURLSkinUUID(urlStr);
            if (!searchUUID.equals(validUUID)) {
                throw new IOException("Invalid generated UUID from skin URL");
            }
        } else {
            throw new IOException("Invalid host in skin packet: " + host);
        }
        skinService.processGetOtherSkin(searchUUID, urlStr, sender);
    }

    public static void registerEaglerPlayer(UUID clientUUID, byte[] bs, ISkinService skinService) throws IOException {
        byte[] generatedPacket;
        if (bs.length == 0) {
            throw new IOException("Zero-length packet recieved");
        }
        int skinModel = -1;
        int packetType = bs[0] & 0xFF;
        switch (packetType) {
            case 1: {
                if (bs.length != 5) {
                    throw new IOException("Invalid length " + bs.length + " for preset skin packet");
                }
                generatedPacket = SkinPackets.makePresetResponse(clientUUID, bs[1] << 24 | bs[2] << 16 | bs[3] << 8 | bs[4] & 0xFF);
                break;
            }
            case 2: {
                byte[] pixels = new byte[16384];
                if (bs.length != 2 + pixels.length) {
                    throw new IOException("Invalid length " + bs.length + " for custom skin packet");
                }
                SkinPackets.setAlphaForChest(pixels, (byte)-1);
                System.arraycopy(bs, 2, pixels, 0, pixels.length);
                skinModel = bs[1] & 0xFF;
                generatedPacket = SkinPackets.makeCustomResponse(clientUUID, skinModel, pixels);
                break;
            }
            default: {
                throw new IOException("Unknown skin packet type: " + packetType);
            }
        }
        skinService.registerEaglercraftPlayer(clientUUID, generatedPacket, skinModel);
    }

    public static void registerEaglerPlayerFallback(UUID clientUUID, ISkinService skinService) throws IOException {
        int skinModel = (clientUUID.hashCode() & 1) != 0 ? 1 : 0;
        byte[] generatedPacket = SkinPackets.makePresetResponse(clientUUID, skinModel);
        skinService.registerEaglercraftPlayer(clientUUID, generatedPacket, skinModel);
    }

    public static void setAlphaForChest(byte[] skin64x64, byte alpha) {
        if (skin64x64.length != 16384) {
            throw new IllegalArgumentException("Skin is not 64x64!");
        }
        int y = 20;
        while (y < 32) {
            int x = 16;
            while (x < 40) {
                skin64x64[y << 8 | x << 2] = alpha;
                ++x;
            }
            ++y;
        }
    }

    public static byte[] makePresetResponse(UUID uuid) {
        return SkinPackets.makePresetResponse(uuid, (uuid.hashCode() & 1) != 0 ? 1 : 0);
    }

    public static byte[] makePresetResponse(UUID uuid, int presetId) {
        byte[] ret = new byte[21];
        ret[0] = 4;
        SkinPackets.UUIDToBytes(uuid, ret, 1);
        ret[17] = (byte)(presetId >> 24);
        ret[18] = (byte)(presetId >> 16);
        ret[19] = (byte)(presetId >> 8);
        ret[20] = (byte)(presetId & 0xFF);
        return ret;
    }

    public static byte[] makeCustomResponse(UUID uuid, int model, byte[] pixels) {
        byte[] ret = new byte[18 + pixels.length];
        ret[0] = 5;
        SkinPackets.UUIDToBytes(uuid, ret, 1);
        ret[17] = (byte)model;
        System.arraycopy(pixels, 0, ret, 18, pixels.length);
        return ret;
    }

    public static UUID bytesToUUID(byte[] bytes, int off) {
        long msb = ((long)bytes[off] & 0xFFL) << 56 | ((long)bytes[off + 1] & 0xFFL) << 48 | ((long)bytes[off + 2] & 0xFFL) << 40 | ((long)bytes[off + 3] & 0xFFL) << 32 | ((long)bytes[off + 4] & 0xFFL) << 24 | ((long)bytes[off + 5] & 0xFFL) << 16 | ((long)bytes[off + 6] & 0xFFL) << 8 | (long)bytes[off + 7] & 0xFFL;
        long lsb = ((long)bytes[off + 8] & 0xFFL) << 56 | ((long)bytes[off + 9] & 0xFFL) << 48 | ((long)bytes[off + 10] & 0xFFL) << 40 | ((long)bytes[off + 11] & 0xFFL) << 32 | ((long)bytes[off + 12] & 0xFFL) << 24 | ((long)bytes[off + 13] & 0xFFL) << 16 | ((long)bytes[off + 14] & 0xFFL) << 8 | (long)bytes[off + 15] & 0xFFL;
        return new UUID(msb, lsb);
    }

    public static String bytesToString(byte[] bytes, int off, int len) {
        char[] ret = new char[len << 1];
        int i = 0;
        while (i < len) {
            ret[i * 2] = hex.charAt(bytes[off + i] >> 4 & 0xF);
            ret[i * 2 + 1] = hex.charAt(bytes[off + i] & 0xF);
            ++i;
        }
        return new String(ret);
    }

    public static String bytesToAscii(byte[] bytes, int off, int len) {
        char[] ret = new char[len];
        int i = 0;
        while (i < len) {
            ret[i] = (char)(bytes[off + i] & 0xFF);
            ++i;
        }
        return new String(ret);
    }

    public static String bytesToAscii(byte[] bytes) {
        return SkinPackets.bytesToAscii(bytes, 0, bytes.length);
    }

    public static void UUIDToBytes(UUID uuid, byte[] bytes, int off) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        bytes[off] = (byte)(msb >> 56);
        bytes[off + 1] = (byte)(msb >> 48);
        bytes[off + 2] = (byte)(msb >> 40);
        bytes[off + 3] = (byte)(msb >> 32);
        bytes[off + 4] = (byte)(msb >> 24);
        bytes[off + 5] = (byte)(msb >> 16);
        bytes[off + 6] = (byte)(msb >> 8);
        bytes[off + 7] = (byte)(msb & 0xFFL);
        bytes[off + 8] = (byte)(lsb >> 56);
        bytes[off + 9] = (byte)(lsb >> 48);
        bytes[off + 10] = (byte)(lsb >> 40);
        bytes[off + 11] = (byte)(lsb >> 32);
        bytes[off + 12] = (byte)(lsb >> 24);
        bytes[off + 13] = (byte)(lsb >> 16);
        bytes[off + 14] = (byte)(lsb >> 8);
        bytes[off + 15] = (byte)(lsb & 0xFFL);
    }

    public static byte[] asciiString(String string) {
        byte[] str = new byte[string.length()];
        int i = 0;
        while (i < str.length) {
            str[i] = (byte)string.charAt(i);
            ++i;
        }
        return str;
    }

    public static UUID createEaglerURLSkinUUID(String skinUrl) {
        return UUID.nameUUIDFromBytes(SkinPackets.asciiString("EaglercraftSkinURL:" + skinUrl));
    }

    public static int getModelId(String modelName) {
        return "slim".equalsIgnoreCase(modelName) ? 1 : 0;
    }

    public static byte[] rewriteUUID(UUID newUUID, byte[] pkt) {
        byte[] ret = new byte[pkt.length];
        System.arraycopy(pkt, 0, ret, 0, pkt.length);
        SkinPackets.UUIDToBytes(newUUID, ret, 1);
        return ret;
    }

    public static byte[] rewriteUUIDModel(UUID newUUID, byte[] pkt, int model) {
        byte[] ret = new byte[pkt.length];
        System.arraycopy(pkt, 0, ret, 0, pkt.length);
        SkinPackets.UUIDToBytes(newUUID, ret, 1);
        if (ret[0] == 5) {
            ret[17] = (byte)model;
        }
        return ret;
    }
}

