/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.md_5.bungee.netty.PipelineUtils;

public class BinaryHttpClient {
    private static final Cache<String, InetAddress> addressCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    private static EventLoopGroup eventLoop = null;

    public static void asyncRequest(String method, URI uri, Consumer<Response> responseCallback) {
        String host;
        InetAddress inetHost;
        String scheme;
        EventLoopGroup eventLoop = BinaryHttpClient.getEventLoopGroup();
        int port = uri.getPort();
        boolean ssl = false;
        switch (scheme = uri.getScheme()) {
            case "http": {
                if (port != -1) break;
                port = 80;
                break;
            }
            case "https": {
                if (port == -1) {
                    port = 443;
                }
                ssl = true;
                break;
            }
            default: {
                responseCallback.accept(new Response(new UnsupportedOperationException("Unsupported scheme: " + scheme)));
                return;
            }
        }
        if ((inetHost = (InetAddress)addressCache.getIfPresent((Object)(host = uri.getHost()))) == null) {
            try {
                inetHost = InetAddress.getByName(host);
            }
            catch (UnknownHostException ex) {
                responseCallback.accept(new Response(ex));
                return;
            }
            addressCache.put((Object)host, (Object)inetHost);
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(PipelineUtils.getChannel(null))).group(eventLoop)).handler((ChannelHandler)new NettyHttpChannelInitializer(responseCallback, ssl, host, port))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).option(ChannelOption.TCP_NODELAY, (Object)true)).remoteAddress(inetHost, port).connect().addListener((GenericFutureListener)new NettyHttpChannelFutureListener(method, uri, responseCallback));
    }

    private static EventLoopGroup getEventLoopGroup() {
        if (eventLoop == null) {
            eventLoop = PipelineUtils.newEventLoopGroup((int)0, (ThreadFactory)new ThreadFactoryBuilder().setNameFormat("Skin Download Thread #%1$d").build());
        }
        return eventLoop;
    }

    public static void killEventLoop() {
        if (eventLoop != null) {
            EaglerXBungee.logger().info("Stopping skin cache HTTP client...");
            eventLoop.shutdownGracefully();
            try {
                eventLoop.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            eventLoop = null;
        }
    }

    private static class NettyHttpChannelFutureListener
    implements ChannelFutureListener {
        protected final String method;
        protected final URI requestURI;
        protected final Consumer<Response> responseCallback;

        protected NettyHttpChannelFutureListener(String method, URI requestURI, Consumer<Response> responseCallback) {
            this.method = method;
            this.requestURI = requestURI;
            this.responseCallback = responseCallback;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                String path = String.valueOf(this.requestURI.getRawPath()) + (this.requestURI.getRawQuery() == null ? "" : "?" + this.requestURI.getRawQuery());
                DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)this.method), path);
                request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)this.requestURI.getHost());
                request.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)("Mozilla/5.0 EaglerXBungee/" + EaglerXBungee.getEagler().getDescription().getVersion()));
                future.channel().writeAndFlush((Object)request);
            } else {
                addressCache.invalidate((Object)this.requestURI.getHost());
                this.responseCallback.accept(new Response(new IOException("Connection failed")));
            }
        }
    }

    private static class NettyHttpChannelInitializer
    extends ChannelInitializer<Channel> {
        protected final Consumer<Response> responseCallback;
        protected final boolean ssl;
        protected final String host;
        protected final int port;

        protected NettyHttpChannelInitializer(Consumer<Response> responseCallback, boolean ssl, String host, int port) {
            this.responseCallback = responseCallback;
            this.ssl = ssl;
            this.host = host;
            this.port = port;
        }

        protected void initChannel(Channel ch) throws Exception {
            ch.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(5L, TimeUnit.SECONDS));
            if (this.ssl) {
                SSLEngine engine = SslContextBuilder.forClient().build().newEngine(ch.alloc(), this.host, this.port);
                ch.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(engine));
            }
            ch.pipeline().addLast("http", (ChannelHandler)new HttpClientCodec());
            ch.pipeline().addLast("handler", (ChannelHandler)new NettyHttpResponseHandler(this.responseCallback));
        }
    }

    private static class NettyHttpResponseHandler
    extends SimpleChannelInboundHandler<HttpObject> {
        protected final Consumer<Response> responseCallback;
        protected int responseCode = -1;
        protected ByteBuf buffer = null;

        protected NettyHttpResponseHandler(Consumer<Response> responseCallback) {
            this.responseCallback = responseCallback;
        }

        protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                this.responseCode = response.status().code();
                if (this.responseCode == HttpResponseStatus.NO_CONTENT.code()) {
                    this.done(ctx);
                    return;
                }
            }
            if (msg instanceof HttpContent) {
                HttpContent content = (HttpContent)msg;
                if (this.buffer == null) {
                    this.buffer = ctx.alloc().buffer();
                }
                this.buffer.writeBytes(content.content());
                if (msg instanceof LastHttpContent) {
                    this.done(ctx);
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.responseCallback.accept(new Response(cause));
        }

        private void done(ChannelHandlerContext ctx) {
            try {
                byte[] array;
                if (this.buffer != null) {
                    array = new byte[this.buffer.readableBytes()];
                    this.buffer.readBytes(array);
                    this.buffer.release();
                } else {
                    array = new byte[]{};
                }
                this.responseCallback.accept(new Response(this.responseCode, array));
            }
            finally {
                ctx.channel().pipeline().remove((ChannelHandler)this);
                ctx.channel().close();
            }
        }
    }

    public static class Response {
        public final int code;
        public final byte[] data;
        public final Throwable exception;

        public Response(int code, byte[] data) {
            this.code = code;
            this.data = data;
            this.exception = null;
        }

        public Response(Throwable exception) {
            this.code = -1;
            this.data = null;
            this.exception = exception;
        }
    }
}

