/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpContentType;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpMemoryCache;

public class HttpWebServer {
    public final File directory;
    public final Map<String, HttpContentType> contentTypes;
    private final Map<String, HttpMemoryCache> filesCache;
    private final List<String> index;
    private final String page404;
    private static HttpMemoryCache default404Page;
    private static HttpMemoryCache default404UpgradePage;
    private static final Object cacheClearLock;

    static {
        cacheClearLock = new Object();
    }

    public HttpWebServer(File directory, Map<String, HttpContentType> contentTypes, List<String> index, String page404) {
        this.directory = directory;
        this.contentTypes = contentTypes;
        this.filesCache = new HashMap<String, HttpMemoryCache>();
        this.index = index;
        this.page404 = page404;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        long millis = System.currentTimeMillis();
        Object object = cacheClearLock;
        synchronized (object) {
            Map<String, HttpMemoryCache> map = this.filesCache;
            synchronized (map) {
                Iterator<HttpMemoryCache> itr = this.filesCache.values().iterator();
                while (itr.hasNext()) {
                    HttpMemoryCache i = itr.next();
                    if (i.contentType.fileBrowserCacheTTL == Long.MAX_VALUE || millis - i.lastCacheHit <= 900000L) continue;
                    i.fileData.release();
                    itr.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - bad return control flow
     */
    public HttpMemoryCache retrieveFile(String path) {
        ArrayList<String> pathList;
        block45: {
            String[] pathSplit = path.split("(\\\\|\\/)+");
            pathList = pathSplit.length == 0 ? null : new ArrayList<String>();
            int i = 0;
            while (i < pathSplit.length) {
                pathSplit[i] = pathSplit[i].trim();
                if (pathSplit[i].length() > 0 && !pathSplit[i].equals(".") && !pathSplit[i].startsWith("..")) {
                    pathList.add(pathSplit[i]);
                }
                ++i;
            }
            if (pathList != null && pathList.size() != 0) break block45;
            int i2 = 0;
            int l = this.index.size();
            while (i2 < l) {
                HttpMemoryCache cached = this.retrieveFile(this.index.get(i2));
                if (cached != null) {
                    return cached;
                }
                ++i2;
            }
            return null;
        }
        try {
            String joinedPath = String.join((CharSequence)"/", pathList);
            Object object = cacheClearLock;
            synchronized (object) {
                File f;
                HttpMemoryCache cached;
                Map<String, HttpMemoryCache> map = this.filesCache;
                synchronized (map) {
                    cached = this.filesCache.get(joinedPath);
                }
                if (cached != null) {
                    if ((cached = this.validateCache(cached)) != null) {
                        return cached;
                    }
                    map = this.filesCache;
                    synchronized (map) {
                        this.filesCache.remove(joinedPath);
                    }
                }
                if (!(f = new File(this.directory, joinedPath)).exists()) {
                    if (this.page404 == null || path.equals(this.page404)) {
                        return default404Page;
                    }
                    return this.retrieveFile(this.page404);
                }
                if (f.isDirectory()) {
                    String p;
                    int i2 = 0;
                    int l = this.index.size();
                    while (i2 < l) {
                        p = String.valueOf(joinedPath) + "/" + this.index.get(i2);
                        Map<String, HttpMemoryCache> map2 = this.filesCache;
                        synchronized (map2) {
                            cached = this.filesCache.get(p);
                        }
                        if (cached != null) {
                            if ((cached = this.validateCache(cached)) != null) {
                                map2 = this.filesCache;
                                synchronized (map2) {
                                    this.filesCache.put(joinedPath, cached);
                                }
                            }
                            map2 = this.filesCache;
                            synchronized (map2) {
                                this.filesCache.remove(p);
                            }
                            if (this.page404 == null || path.equals(this.page404)) {
                                return default404Page;
                            }
                            return this.retrieveFile(this.page404);
                            return cached;
                        }
                        ++i2;
                    }
                    i2 = 0;
                    l = this.index.size();
                    while (i2 < l) {
                        HttpMemoryCache memCache;
                        p = String.valueOf(joinedPath) + "/" + this.index.get(i2);
                        File ff = new File(this.directory, p);
                        if (ff.isFile() && (memCache = this.retrieveFile(ff, p)) != null) {
                            Map<String, HttpMemoryCache> map3 = this.filesCache;
                            synchronized (map3) {
                                this.filesCache.put(joinedPath, memCache);
                            }
                            return memCache;
                        }
                        ++i2;
                    }
                    if (this.page404 == null || path.equals(this.page404)) {
                        return default404Page;
                    }
                    return this.retrieveFile(this.page404);
                }
                HttpMemoryCache memCache = this.retrieveFile(f, joinedPath);
                if (memCache != null) {
                    Map<String, HttpMemoryCache> map4 = this.filesCache;
                    synchronized (map4) {
                        this.filesCache.put(joinedPath, memCache);
                    }
                    return memCache;
                }
                if (this.page404 == null || path.equals(this.page404)) {
                    return default404Page;
                }
                return this.retrieveFile(this.page404);
            }
        }
        catch (Throwable t) {
            return default404Page;
        }
    }

    private HttpMemoryCache retrieveFile(File path, String requestCachePath) {
        int fileSize = (int)path.length();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream is = new FileInputStream(path);){
                ByteBuf file = Unpooled.buffer((int)fileSize, (int)fileSize);
                file.writeBytes((InputStream)is, fileSize);
                String ext = path.getName();
                HttpContentType ct = null;
                int i = ext.lastIndexOf(46);
                if (i != -1) {
                    ct = this.contentTypes.get(ext.substring(i + 1));
                }
                if (ct == null) {
                    ct = HttpContentType.defaultType;
                }
                long millis = System.currentTimeMillis();
                return new HttpMemoryCache(path, requestCachePath, file, ct, millis, millis, path.lastModified());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            return null;
        }
    }

    private HttpMemoryCache validateCache(HttpMemoryCache file) {
        long millis;
        if (file.fileObject == null) {
            return file;
        }
        file.lastCacheHit = millis = System.currentTimeMillis();
        if (millis - file.lastDiskReload > 4000L) {
            File f = file.fileObject;
            if (!f.isFile()) {
                return null;
            }
            long lastMod = f.lastModified();
            if (lastMod != file.lastDiskModified) {
                int fileSize = (int)f.length();
                try {
                    Throwable throwable = null;
                    Object var9_9 = null;
                    try (FileInputStream is = new FileInputStream(f);){
                        file.fileData = Unpooled.buffer((int)fileSize, (int)fileSize);
                        file.fileData.writeBytes((InputStream)is, fileSize);
                        file.lastDiskReload = millis;
                        file.lastDiskModified = lastMod;
                        return file;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable t) {
                    return null;
                }
            }
            return file;
        }
        return file;
    }

    public static void regenerate404Pages() {
        if (default404Page != null) {
            HttpWebServer.default404Page.fileData.release();
        }
        default404Page = HttpWebServer.regenerateDefault404();
        if (default404UpgradePage != null) {
            HttpWebServer.default404UpgradePage.fileData.release();
        }
        default404UpgradePage = HttpWebServer.regenerateDefaultUpgrade404();
    }

    public static HttpMemoryCache getHTTP404() {
        return default404Page;
    }

    public static HttpMemoryCache getWebSocket404() {
        return default404UpgradePage;
    }

    private static HttpMemoryCache regenerateDefault404() {
        EaglerXBungee plugin = EaglerXBungee.getEagler();
        byte[] src = ("<!DOCTYPE html><html><head><title>" + HttpWebServer.htmlEntities(plugin.getConfig().getServerName()) + "</title><script type=\"text/javascript\">" + "window.addEventListener(\"load\",()=>document.getElementById(\"addr\").innerText=window.location.href);</script></head>" + "<body style=\"font-family:sans-serif;text-align:center;\"><h1>404 Not Found</h1><hr /><p style=\"font-size:1.2em;\">" + "The requested resource <span id=\"addr\" style=\"font-family:monospace;font-weight:bold;background-color:#EEEEEE;padding:3px 4px;\">" + "</span> could not be found on this server!</p><p>" + HttpWebServer.htmlEntities(plugin.getDescription().getName()) + "/" + HttpWebServer.htmlEntities(plugin.getDescription().getVersion()) + "</p></body></html>").getBytes(StandardCharsets.UTF_8);
        HttpContentType htmlContentType = new HttpContentType(new HashSet<String>(Arrays.asList("html")), "text/html", "utf-8", 120000L);
        long millis = System.currentTimeMillis();
        return new HttpMemoryCache(null, "~404", Unpooled.wrappedBuffer((byte[])src), htmlContentType, millis, millis, millis);
    }

    private static HttpMemoryCache regenerateDefaultUpgrade404() {
        EaglerXBungee plugin = EaglerXBungee.getEagler();
        String name = HttpWebServer.htmlEntities(plugin.getConfig().getServerName());
        byte[] src = ("<!DOCTYPE html><html><head><meta charset=\"UTF-8\" /><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\" /><title>" + name + "</title><script type=\"text/javascript\">window.addEventListener(\"load\",()=>{var src=window.location.href;const gEI=(i)=>document.getElementById(i);" + "if(src.startsWith(\"http:\")){src=\"ws:\"+src.substring(5);}else if(src.startsWith(\"https:\")){src=\"wss:\"+src.substring(6);}else{return;}" + "gEI(\"wsUri\").innerHTML=\"<span id=\\\"wsField\\\" style=\\\"font-family:monospace;font-weight:bold;background-color:#EEEEEE;padding:3px 4px;\\\">" + "</span>\";gEI(\"wsField\").innerText=src;});</script></head><body style=\"font-family:sans-serif;margin:0px;padding:12px;\"><h1 style=\"margin-block-start:0px;\">" + "404 'Websocket Upgrade Failure' (rip)</h1><h3>The URL you have requested is the physical WebSocket address of '" + name + "'</h3><p style=\"font-size:1.2em;" + "line-height:1.3em;\">To correctly join this server, load the latest EaglercraftX 1.8 client, click the 'Direct Connect' button<br />on the 'Multiplayer' screen, " + "and enter <span id=\"wsUri\">this URL</span> as the server address</p></body></html>").getBytes(StandardCharsets.UTF_8);
        HttpContentType htmlContentType = new HttpContentType(new HashSet<String>(Arrays.asList("html")), "text/html", "utf-8", 14400000L);
        long millis = System.currentTimeMillis();
        return new HttpMemoryCache(null, "~404", Unpooled.wrappedBuffer((byte[])src), htmlContentType, millis, millis, millis);
    }

    public static String htmlEntities(String input) {
        return input.replace("<", "&lt;").replace(">", "&gt;");
    }
}

