/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpContentType;

public class HttpMemoryCache {
    public File fileObject;
    public String filePath;
    public ByteBuf fileData;
    public HttpContentType contentType;
    public long lastCacheHit;
    public long lastDiskReload;
    public long lastDiskModified;
    private final String server;
    private static final SimpleDateFormat gmt = new SimpleDateFormat();

    static {
        gmt.setTimeZone(new SimpleTimeZone(0, "GMT"));
        gmt.applyPattern("dd MMM yyyy HH:mm:ss z");
    }

    public HttpMemoryCache(File fileObject, String filePath, ByteBuf fileData, HttpContentType contentType, long lastCacheHit, long lastDiskReload, long lastDiskModified) {
        this.fileObject = fileObject;
        this.filePath = filePath;
        this.fileData = fileData;
        this.contentType = contentType;
        this.lastCacheHit = lastCacheHit;
        this.lastDiskReload = lastDiskReload;
        this.lastDiskModified = lastDiskModified;
        this.server = "EaglerXBungee/" + EaglerXBungee.getEagler().getDescription().getVersion();
    }

    public DefaultFullHttpResponse createHTTPResponse() {
        return this.createHTTPResponse(HttpResponseStatus.OK);
    }

    public DefaultFullHttpResponse createHTTPResponse(HttpResponseStatus code) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, code, Unpooled.copiedBuffer((ByteBuf)this.fileData));
        HttpHeaders responseHeaders = response.headers();
        Date d = new Date();
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)this.contentType.httpHeader);
        responseHeaders.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.fileData.readableBytes());
        responseHeaders.add((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)this.contentType.cacheControlHeader);
        responseHeaders.add((CharSequence)HttpHeaderNames.DATE, (Object)gmt.format(d));
        long l = this.contentType.fileBrowserCacheTTL;
        if (l > 0L && l != Long.MAX_VALUE) {
            d.setTime(d.getTime() + l);
            responseHeaders.add((CharSequence)HttpHeaderNames.EXPIRES, (Object)gmt.format(d));
        }
        d.setTime(this.lastDiskModified);
        responseHeaders.add((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)gmt.format(d));
        responseHeaders.add((CharSequence)HttpHeaderNames.SERVER, (Object)this.server);
        return response;
    }
}

