/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.HttpServerQueryHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query.MOTDQueryHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query.VersionQueryHandler;
import net.md_5.bungee.api.plugin.PluginDescription;

public class QueryManager {
    private static final Map<String, Class<? extends HttpServerQueryHandler>> queryTypes = new HashMap<String, Class<? extends HttpServerQueryHandler>>();

    static {
        queryTypes.put("motd", MOTDQueryHandler.class);
        queryTypes.put("motd.cache", MOTDQueryHandler.class);
        queryTypes.put("version", VersionQueryHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpServerQueryHandler createQueryHandler(String type) {
        Class<? extends HttpServerQueryHandler> clazz;
        Map<String, Class<? extends HttpServerQueryHandler>> map = queryTypes;
        synchronized (map) {
            clazz = queryTypes.get(type);
        }
        if (clazz != null) {
            HttpServerQueryHandler obj = null;
            try {
                obj = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception creating query handler for '" + type + "'!", e);
            }
            if (obj != null) {
                return obj;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerQueryType(String name, Class<? extends HttpServerQueryHandler> clazz) {
        Map<String, Class<? extends HttpServerQueryHandler>> map = queryTypes;
        synchronized (map) {
            if (queryTypes.put(name, clazz) != null) {
                EaglerXBungee.logger().warning("Query type '" + name + "' was registered twice, probably by two different plugins!");
                Thread.dumpStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterQueryType(String name) {
        Map<String, Class<? extends HttpServerQueryHandler>> map = queryTypes;
        synchronized (map) {
            queryTypes.remove(name);
        }
    }

    private static JsonObject createBaseResponse() {
        EaglerXBungee plugin = EaglerXBungee.getEagler();
        EaglerBungeeConfig conf = plugin.getConfig();
        JsonObject json = new JsonObject();
        json.addProperty("name", conf.getServerName());
        json.addProperty("brand", "lax1dude");
        PluginDescription desc = plugin.getDescription();
        json.addProperty("vers", "EaglerXBungee/" + desc.getVersion());
        json.addProperty("cracked", Boolean.valueOf(conf.isCracked()));
        json.addProperty("secure", Boolean.valueOf(false));
        json.addProperty("time", (Number)System.currentTimeMillis());
        json.addProperty("uuid", conf.getServerUUID().toString());
        return json;
    }

    public static JsonObject createStringResponse(String type, String str) {
        JsonObject ret = QueryManager.createBaseResponse();
        ret.addProperty("type", type);
        ret.addProperty("data", str);
        return ret;
    }

    public static JsonObject createJsonObjectResponse(String type, JsonObject json) {
        JsonObject ret = QueryManager.createBaseResponse();
        ret.addProperty("type", type);
        ret.add("data", (JsonElement)json);
        return ret;
    }
}

