/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerPipeline;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query.QueryManager;

public abstract class HttpServerQueryHandler
extends ChannelInboundHandlerAdapter {
    private static final InetAddress localhost;
    private EaglerListenerConfig conf;
    private ChannelHandlerContext context;
    private String accept;
    private boolean acceptTextPacket = false;
    private boolean acceptBinaryPacket = false;
    private boolean hasClosed = false;
    private boolean keepAlive = false;

    static {
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (Throwable t) {
            throw new RuntimeException("localhost doesn't exist?!", t);
        }
    }

    public void beginHandleQuery(EaglerListenerConfig conf, ChannelHandlerContext context, String accept) {
        this.conf = conf;
        this.context = context;
        this.accept = accept;
        this.begin(accept);
    }

    protected void acceptText() {
        this.acceptText(true);
    }

    protected void acceptText(boolean bool) {
        this.acceptTextPacket = bool;
    }

    protected void acceptBinary() {
        this.acceptBinary(true);
    }

    protected void acceptBinary(boolean bool) {
        this.acceptBinaryPacket = bool;
    }

    public void close() {
        this.context.close();
        this.hasClosed = true;
    }

    public boolean isClosed() {
        return this.hasClosed;
    }

    public InetAddress getAddress() {
        InetAddress addr = (InetAddress)this.context.channel().attr(EaglerPipeline.REAL_ADDRESS).get();
        if (addr != null) {
            return addr;
        }
        SocketAddress sockAddr = this.context.channel().remoteAddress();
        return sockAddr instanceof InetSocketAddress ? ((InetSocketAddress)sockAddr).getAddress() : localhost;
    }

    public ChannelHandlerContext getContext() {
        return this.context;
    }

    public EaglerListenerConfig getListener() {
        return this.conf;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof WebSocketFrame) {
            if (msg instanceof BinaryWebSocketFrame) {
                this.handleBinary(ctx, ((BinaryWebSocketFrame)msg).content());
            } else if (msg instanceof TextWebSocketFrame) {
                this.handleText(ctx, ((TextWebSocketFrame)msg).text());
            } else if (msg instanceof PingWebSocketFrame) {
                ctx.writeAndFlush((Object)new PongWebSocketFrame());
            } else if (msg instanceof CloseWebSocketFrame) {
                ctx.close();
            }
        } else {
            EaglerXBungee.logger().severe("Unexpected Packet: " + msg.getClass().getSimpleName());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx.channel().isActive()) {
            EaglerXBungee.logger().warning("[" + ctx.channel().remoteAddress() + "]: Exception Caught: " + cause.toString());
        }
    }

    private void handleBinary(ChannelHandlerContext ctx, ByteBuf buffer) {
        if (!this.acceptBinaryPacket) {
            ctx.close();
            return;
        }
        byte[] packet = new byte[buffer.readableBytes()];
        buffer.readBytes(packet);
        this.processBytes(packet);
    }

    private void handleText(ChannelHandlerContext ctx, String str) {
        if (!this.acceptTextPacket) {
            ctx.close();
            return;
        }
        JsonObject obj = null;
        if (str.indexOf(123) == 0) {
            try {
                obj = new JsonParser().parse(str).getAsJsonObject();
            }
            catch (JsonParseException jsonParseException) {
                // empty catch block
            }
        }
        if (obj != null) {
            this.processJson(obj);
        } else {
            this.processString(str);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        EaglerPipeline.closeChannel(ctx.channel());
        this.hasClosed = true;
        this.closed();
    }

    public String getAccept() {
        return this.accept;
    }

    public void sendStringResponse(String type, String str) {
        this.context.writeAndFlush((Object)new TextWebSocketFrame(QueryManager.createStringResponse(this.accept, str).toString()));
    }

    public void sendStringResponseAndClose(String type, String str) {
        this.context.writeAndFlush((Object)new TextWebSocketFrame(QueryManager.createStringResponse(this.accept, str).toString())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendJsonResponse(String type, JsonObject obj) {
        this.context.writeAndFlush((Object)new TextWebSocketFrame(QueryManager.createJsonObjectResponse(this.accept, obj).toString()));
    }

    public void sendJsonResponseAndClose(String type, JsonObject obj) {
        this.context.writeAndFlush((Object)new TextWebSocketFrame(QueryManager.createJsonObjectResponse(this.accept, obj).toString())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendBinaryResponse(byte[] bytes) {
        ByteBuf buf = Unpooled.buffer((int)bytes.length, (int)bytes.length);
        buf.writeBytes(bytes);
        this.context.writeAndFlush((Object)new BinaryWebSocketFrame(buf));
    }

    public void sendBinaryResponseAndClose(byte[] bytes) {
        ByteBuf buf = Unpooled.buffer((int)bytes.length, (int)bytes.length);
        buf.writeBytes(bytes);
        this.context.writeAndFlush((Object)new BinaryWebSocketFrame(buf)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void setKeepAlive(boolean enable) {
        this.keepAlive = enable;
    }

    public boolean shouldKeepAlive() {
        return this.keepAlive;
    }

    protected abstract void begin(String var1);

    protected abstract void processString(String var1);

    protected abstract void processJson(JsonObject var1);

    protected abstract void processBytes(byte[] var1);

    protected abstract void closed();

    public static class UnexpectedDataException
    extends RuntimeException {
        public UnexpectedDataException() {
        }

        public UnexpectedDataException(String message, Throwable cause) {
            super(message, cause);
        }

        public UnexpectedDataException(String message) {
            super(message);
        }

        public UnexpectedDataException(Throwable cause) {
            super(cause);
        }
    }
}

