/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerRateLimiter;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.RateLimitStatus;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerConnectionInstance;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerPipeline;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.HttpWebSocketHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpMemoryCache;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpWebServer;

public class HttpHandshakeHandler
extends ChannelInboundHandlerAdapter {
    private static final byte[] error429Bytes = "<h3>429 Too Many Requests<br /><small>(Try again later)</small></h3>".getBytes(StandardCharsets.UTF_8);
    private final EaglerListenerConfig conf;

    public HttpHandshakeHandler(EaglerListenerConfig conf) {
        this.conf = conf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpMemoryCache ch;
        int j;
        if (!(msg instanceof HttpRequest)) {
            ctx.close();
            return;
        }
        EaglerConnectionInstance pingTracker = (EaglerConnectionInstance)ctx.channel().attr(EaglerPipeline.CONNECTION_INSTANCE).get();
        HttpRequest req = (HttpRequest)msg;
        HttpHeaders headers = req.headers();
        String rateLimitHost = null;
        if (this.conf.isForwardIp()) {
            String str = headers.get(this.conf.getForwardIpHeader());
            if (str == null) {
                EaglerXBungee.logger().warning("[" + ctx.channel().remoteAddress() + "]: Connected without a '" + this.conf.getForwardIpHeader() + "' header, disconnecting...");
                ctx.close();
                return;
            }
            rateLimitHost = str.split(",", 2)[0];
            try {
                ctx.channel().attr(EaglerPipeline.REAL_ADDRESS).set((Object)InetAddress.getByName(rateLimitHost));
            }
            catch (UnknownHostException ex) {
                EaglerXBungee.logger().warning("[" + ctx.channel().remoteAddress() + "]: Connected with an invalid '" + this.conf.getForwardIpHeader() + "' header, disconnecting...");
                ctx.close();
                return;
            }
        } else {
            SocketAddress addr = ctx.channel().remoteAddress();
            if (addr instanceof InetSocketAddress) {
                rateLimitHost = ((InetSocketAddress)addr).getAddress().getHostAddress();
            }
        }
        EaglerRateLimiter ipRateLimiter = this.conf.getRatelimitIp();
        RateLimitStatus ipRateLimit = RateLimitStatus.OK;
        if (ipRateLimiter != null && rateLimitHost != null) {
            ipRateLimit = ipRateLimiter.rateLimit(rateLimitHost);
        }
        if (ipRateLimit == RateLimitStatus.LOCKED_OUT) {
            ctx.close();
            return;
        }
        if (headers.get((CharSequence)HttpHeaderNames.CONNECTION) != null && headers.get((CharSequence)HttpHeaderNames.CONNECTION).toLowerCase().contains("upgrade") && "websocket".equalsIgnoreCase(headers.get((CharSequence)HttpHeaderNames.UPGRADE))) {
            WebSocketServerHandshakerFactory wsFactory;
            WebSocketServerHandshaker hs;
            String origin = headers.get((CharSequence)HttpHeaderNames.ORIGIN);
            if (origin != null) {
                ctx.channel().attr(EaglerPipeline.ORIGIN).set((Object)origin);
            }
            if (ipRateLimit == RateLimitStatus.OK) {
                ctx.channel().attr(EaglerPipeline.HOST).set((Object)headers.get((CharSequence)HttpHeaderNames.HOST));
                ctx.pipeline().replace((ChannelHandler)this, "HttpWebSocketHandler", (ChannelHandler)new HttpWebSocketHandler(this.conf));
            }
            if ((hs = (wsFactory = new WebSocketServerHandshakerFactory("ws://" + headers.get((CharSequence)HttpHeaderNames.HOST) + req.uri(), null, true, 1048575)).newHandshaker(req)) != null) {
                pingTracker.isWebSocket = true;
                ChannelFuture future = hs.handshake(ctx.channel(), req);
                if (ipRateLimit == RateLimitStatus.OK) return;
                final RateLimitStatus rateLimitTypeFinal = ipRateLimit;
                future.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture paramF) throws Exception {
                        ctx.writeAndFlush((Object)new TextWebSocketFrame(rateLimitTypeFinal == RateLimitStatus.LIMITED_NOW_LOCKED_OUT ? "LOCKED" : "BLOCKED")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                });
                return;
            }
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        if (ipRateLimit != RateLimitStatus.OK) {
            ByteBuf error429Buffer = ctx.alloc().buffer(error429Bytes.length, error429Bytes.length);
            error429Buffer.writeBytes(error429Bytes);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.TOO_MANY_REQUESTS, error429Buffer);
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        pingTracker.isRegularHttp = true;
        HttpWebServer srv = this.conf.getWebServer();
        if (srv == null) {
            ctx.writeAndFlush((Object)HttpWebServer.getWebSocket404().createHTTPResponse(HttpResponseStatus.NOT_FOUND)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        String uri = req.uri();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if ((j = uri.indexOf(63)) != -1) {
            uri = uri.substring(0, j);
        }
        if ((ch = srv.retrieveFile(uri)) != null) {
            ctx.writeAndFlush((Object)ch.createHTTPResponse()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return;
        }
        ctx.writeAndFlush((Object)HttpWebServer.getWebSocket404().createHTTPResponse(HttpResponseStatus.NOT_FOUND)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx.channel().isActive()) {
            EaglerXBungee.logger().log(Level.WARNING, "[Pre][" + ctx.channel().remoteAddress() + "]: Exception Caught: " + cause.toString(), cause);
            ctx.close();
        }
    }

    private static String formatAddressFor404(String str) {
        return "<span style=\"font-family:monospace;font-weight:bold;background-color:#EEEEEE;padding:3px 4px;\">" + str.replace("<", "&lt;").replace(">", "&gt;") + "</span>";
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        EaglerPipeline.closeChannel(ctx.channel());
    }
}

