/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.BinaryHttpClient;
import net.md_5.bungee.protocol.Property;

class VanillaDefaultSkinProfileLoader
implements Consumer<BinaryHttpClient.Response> {
    private final EaglerBungeeConfig config;
    private volatile boolean isLocked = true;
    private final Object lock = new Object();

    private VanillaDefaultSkinProfileLoader(EaglerBungeeConfig config) {
        this.config = config;
    }

    @Override
    public void accept(BinaryHttpClient.Response response) {
        if (response == null) {
            EaglerXBungee.logger().severe("Request error (null)");
            this.doNotify();
        } else if (response.exception != null) {
            EaglerXBungee.logger().log(Level.SEVERE, "Exception loading vanilla default profile!", response.exception);
            this.doNotify();
        } else if (response.code != 200) {
            EaglerXBungee.logger().severe("Recieved code " + response.code + " while looking up UUID of " + this.config.getEaglerPlayersVanillaSkin());
            this.doNotify();
        } else if (response.data == null) {
            EaglerXBungee.logger().severe("Recieved null payload while looking up UUID of " + this.config.getEaglerPlayersVanillaSkin());
            this.doNotify();
        } else {
            try {
                JsonObject json = new JsonParser().parse(new String(response.data, StandardCharsets.UTF_8)).getAsJsonObject();
                String uuid = json.get("id").getAsString();
                URI requestURI = URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false");
                BinaryHttpClient.asyncRequest("GET", requestURI, new ProfileSkinConsumerImpl(uuid));
            }
            catch (Throwable t) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception processing name to UUID lookup response!", t);
                this.doNotify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotify() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isLocked) {
                this.isLocked = false;
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void lookupVanillaSkinUser(EaglerBungeeConfig config) {
        String user = config.getEaglerPlayersVanillaSkin();
        EaglerXBungee.logger().info("Loading vanilla profile: " + user);
        URI requestURI = URI.create("https://api.mojang.com/users/profiles/minecraft/" + user);
        VanillaDefaultSkinProfileLoader loader = new VanillaDefaultSkinProfileLoader(config);
        Object object = loader.lock;
        synchronized (object) {
            BinaryHttpClient.asyncRequest("GET", requestURI, loader);
            if (loader.isLocked) {
                try {
                    loader.lock.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (loader.isLocked) {
                    EaglerXBungee.logger().warning("Profile load timed out");
                }
            }
        }
    }

    private class ProfileSkinConsumerImpl
    implements Consumer<BinaryHttpClient.Response> {
        private final String uuid;

        private ProfileSkinConsumerImpl(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public void accept(BinaryHttpClient.Response response) {
            if (response == null) {
                EaglerXBungee.logger().severe("Request error (null)");
                VanillaDefaultSkinProfileLoader.this.doNotify();
            } else if (response.exception != null) {
                EaglerXBungee.logger().log(Level.SEVERE, "Exception loading vanilla default profile!", response.exception);
                VanillaDefaultSkinProfileLoader.this.doNotify();
            } else if (response.code != 200) {
                EaglerXBungee.logger().severe("Recieved code " + response.code + " while looking up profile of " + this.uuid);
                VanillaDefaultSkinProfileLoader.this.doNotify();
            } else if (response.data == null) {
                EaglerXBungee.logger().severe("Recieved null payload while looking up profile of " + this.uuid);
                VanillaDefaultSkinProfileLoader.this.doNotify();
            } else {
                try {
                    JsonArray properties;
                    JsonObject json = new JsonParser().parse(new String(response.data, StandardCharsets.UTF_8)).getAsJsonObject();
                    JsonElement propsElement = json.get("properties");
                    if (propsElement != null && (properties = propsElement.getAsJsonArray()).size() > 0) {
                        int i = 0;
                        int l = properties.size();
                        while (i < l) {
                            JsonObject propObj;
                            JsonElement prop = properties.get(i);
                            if (prop.isJsonObject() && (propObj = prop.getAsJsonObject()).get("name").getAsString().equals("textures")) {
                                JsonElement value = propObj.get("value");
                                JsonElement signature = propObj.get("signature");
                                if (value != null) {
                                    Property newProp = new Property("textures", value.getAsString(), signature != null ? signature.getAsString() : null);
                                    ((VanillaDefaultSkinProfileLoader)VanillaDefaultSkinProfileLoader.this).config.eaglerPlayersVanillaSkinCached = new Property[]{newProp, EaglerBungeeConfig.isEaglerProperty};
                                }
                                EaglerXBungee.logger().info("Loaded vanilla profile: " + VanillaDefaultSkinProfileLoader.this.config.getEaglerPlayersVanillaSkin());
                                VanillaDefaultSkinProfileLoader.this.doNotify();
                                return;
                            }
                            ++i;
                        }
                    }
                    EaglerXBungee.logger().warning("No skin was found for: " + VanillaDefaultSkinProfileLoader.this.config.getEaglerPlayersVanillaSkin());
                }
                catch (Throwable t) {
                    EaglerXBungee.logger().log(Level.SEVERE, "Exception processing name to UUID lookup response!", t);
                }
                VanillaDefaultSkinProfileLoader.this.doNotify();
            }
        }
    }
}

