/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.command;

import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.DefaultAuthSystem;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;

public class CommandEaglerRegister
extends Command {
    public CommandEaglerRegister(String name) {
        super(name);
    }

    public void execute(CommandSender sender, String[] args) {
        if (sender instanceof ProxiedPlayer) {
            DefaultAuthSystem srv;
            ProxiedPlayer player = (ProxiedPlayer)sender;
            if (args.length != 1) {
                TextComponent comp = new TextComponent("Use: /" + this.getName() + " <password>");
                comp.setColor(ChatColor.RED);
                player.sendMessage((BaseComponent)comp);
                return;
            }
            EaglerAuthConfig authConf = EaglerXBungee.getEagler().getConfig().getAuthConfig();
            if (authConf.isEnableAuthentication() && authConf.isUseBuiltInAuthentication() && (srv = EaglerXBungee.getEagler().getAuthService()) != null) {
                if (!(player.getPendingConnection() instanceof EaglerInitialHandler)) {
                    try {
                        srv.processSetPassword(player, args[0]);
                        sender.sendMessage((BaseComponent)new TextComponent(authConf.getCommandSuccessText()));
                    }
                    catch (DefaultAuthSystem.TooManyRegisteredOnIPException ex) {
                        String tooManyReg = authConf.getTooManyRegistrationsMessage();
                        sender.sendMessage((BaseComponent)new TextComponent(tooManyReg));
                    }
                    catch (DefaultAuthSystem.AuthException ex) {
                        EaglerXBungee.logger().log(Level.SEVERE, "Internal exception while processing password change from \"" + player.getName() + "\"", ex);
                        TextComponent comp = new TextComponent("Internal error, check console logs");
                        comp.setColor(ChatColor.RED);
                        sender.sendMessage((BaseComponent)comp);
                    }
                } else {
                    player.sendMessage((BaseComponent)new TextComponent(authConf.getNeedVanillaToRegisterMessage()));
                }
            }
        } else {
            TextComponent comp = new TextComponent("You must be a player to use this command!");
            comp.setColor(ChatColor.RED);
            sender.sendMessage((BaseComponent)comp);
        }
    }
}

