/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftHandleAuthPasswordEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.event.EaglercraftIsAuthRequiredEvent;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.AuthLoadingCache;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.HashUtils;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.SHA256Digest;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.sqlite.EaglerDrivers;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.protocol.Property;
import org.apache.commons.codec.binary.Base64;

public class DefaultAuthSystem {
    protected final String uri;
    protected final Connection databaseConnection;
    protected final String passwordPromptScreenText;
    protected final String wrongPasswordScreenText;
    protected final String notRegisteredScreenText;
    protected final String eaglerCommandName;
    protected final String useRegisterCommandText;
    protected final String useChangeCommandText;
    protected final String commandSuccessText;
    protected final String lastEaglerLoginMessage;
    protected final String tooManyRegistrationsMessage;
    protected final String needVanillaToRegisterMessage;
    protected final boolean overrideEaglerToVanillaSkins;
    protected final int maxRegistrationsPerIP;
    protected final SecureRandom secureRandom;
    protected final PreparedStatement registerUser;
    protected final PreparedStatement isRegisteredUser;
    protected final PreparedStatement pruneUsers;
    protected final PreparedStatement updatePassword;
    protected final PreparedStatement updateMojangUsername;
    protected final PreparedStatement getRegistrationsOnIP;
    protected final PreparedStatement checkRegistrationByUUID;
    protected final PreparedStatement checkRegistrationByName;
    protected final PreparedStatement setLastLogin;
    protected final PreparedStatement updateTextures;
    protected final AuthLoadingCache<String, CachedAccountInfo> authLoadingCache;
    private static final String hexString = "0123456789abcdef";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static DefaultAuthSystem initializeAuthSystem(EaglerAuthConfig config) throws AuthSystemException {
        Connection conn;
        String databaseURI = config.getDatabaseURI();
        try {
            conn = EaglerDrivers.connectToDatabase(databaseURI, config.getDriverClass(), config.getDriverPath(), new Properties());
            if (conn == null) {
                throw new IllegalStateException("Connection is null");
            }
        }
        catch (Throwable t) {
            throw new AuthSystemException("Could not initialize '" + databaseURI + "'!", t);
        }
        EaglerXBungee.logger().info("Connected to database: " + databaseURI);
        try {
            t = null;
            Object var4_8 = null;
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS \"eaglercraft_accounts\" (\"Version\"\tTINYINT NOT NULL,\"MojangUUID\"\tTEXT(32) NOT NULL,\"MojangUsername\"\tTEXT(16) NOT NULL,\"HashBase\"\tBLOB NOT NULL,\"HashSalt\"\tBLOB NOT NULL,\"MojangTextures\"\tBLOB,\"Registered\"\tDATETIME NOT NULL,\"RegisteredIP\"\tVARCHAR(42) NOT NULL,\"LastLogin\"\tDATETIME,\"LastLoginIP\"\tVARCHAR(42),PRIMARY KEY(\"MojangUUID\"))");
                stmt.execute("CREATE UNIQUE INDEX IF NOT EXISTS \"MojangUsername\" ON \"eaglercraft_accounts\" (\"MojangUsername\")");
            }
            catch (Throwable throwable) {
                if (t == null) {
                    t = throwable;
                } else if (t != throwable) {
                    t.addSuppressed(throwable);
                }
                throw t;
            }
            return new DefaultAuthSystem(databaseURI, conn, config.getPasswordPromptScreenText(), config.getWrongPasswordScreenText(), config.getNotRegisteredScreenText(), config.getEaglerCommandName(), config.getUseRegisterCommandText(), config.getUseChangeCommandText(), config.getCommandSuccessText(), config.getLastEaglerLoginMessage(), config.getTooManyRegistrationsMessage(), config.getNeedVanillaToRegisterMessage(), config.getOverrideEaglerToVanillaSkins(), config.getMaxRegistrationsPerIP());
        }
        catch (AuthSystemException ex) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw ex;
        }
        catch (Throwable t) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new AuthSystemException("Could not initialize '" + databaseURI + "'!", t);
        }
    }

    protected DefaultAuthSystem(String uri, Connection databaseConnection, String passwordPromptScreenText, String wrongPasswordScreenText, String notRegisteredScreenText, String eaglerCommandName, String useRegisterCommandText, String useChangeCommandText, String commandSuccessText, String lastEaglerLoginMessage, String tooManyRegistrationsMessage, String needVanillaToRegisterMessage, boolean overrideEaglerToVanillaSkins, int maxRegistrationsPerIP) throws SQLException {
        this.uri = uri;
        this.databaseConnection = databaseConnection;
        this.passwordPromptScreenText = passwordPromptScreenText;
        this.wrongPasswordScreenText = wrongPasswordScreenText;
        this.notRegisteredScreenText = notRegisteredScreenText;
        this.eaglerCommandName = eaglerCommandName;
        this.useRegisterCommandText = useRegisterCommandText;
        this.useChangeCommandText = useChangeCommandText;
        this.commandSuccessText = commandSuccessText;
        this.lastEaglerLoginMessage = lastEaglerLoginMessage;
        this.tooManyRegistrationsMessage = tooManyRegistrationsMessage;
        this.needVanillaToRegisterMessage = needVanillaToRegisterMessage;
        this.overrideEaglerToVanillaSkins = overrideEaglerToVanillaSkins;
        this.maxRegistrationsPerIP = maxRegistrationsPerIP;
        this.registerUser = databaseConnection.prepareStatement("INSERT INTO eaglercraft_accounts (Version, MojangUUID, MojangUsername, MojangTextures, HashBase, HashSalt, Registered, RegisteredIP) VALUES(?, ?, ?, ?, ?, ?, ?, ?)");
        this.isRegisteredUser = databaseConnection.prepareStatement("SELECT COUNT(MojangUUID) AS total_accounts FROM eaglercraft_accounts WHERE MojangUUID = ?");
        this.pruneUsers = databaseConnection.prepareStatement("DELETE FROM eaglercraft_accounts WHERE LastLogin < ?");
        this.updatePassword = databaseConnection.prepareStatement("UPDATE eaglercraft_accounts SET HashBase = ?, HashSalt = ? WHERE MojangUUID = ?");
        this.updateMojangUsername = databaseConnection.prepareStatement("UPDATE eaglercraft_accounts SET MojangUsername = ? WHERE MojangUUID = ?");
        this.getRegistrationsOnIP = databaseConnection.prepareStatement("SELECT COUNT(MojangUUID) AS total_accounts FROM eaglercraft_accounts WHERE RegisteredIP = ?");
        this.checkRegistrationByUUID = databaseConnection.prepareStatement("SELECT Version, MojangUsername, LastLogin, LastLoginIP FROM eaglercraft_accounts WHERE MojangUUID = ?");
        this.checkRegistrationByName = databaseConnection.prepareStatement("SELECT Version, MojangUUID, MojangTextures, HashBase, HashSalt, Registered, RegisteredIP, LastLogin, LastLoginIP FROM eaglercraft_accounts WHERE MojangUsername = ?");
        this.setLastLogin = databaseConnection.prepareStatement("UPDATE eaglercraft_accounts SET LastLogin = ?, LastLoginIP = ? WHERE MojangUUID = ?");
        this.updateTextures = databaseConnection.prepareStatement("UPDATE eaglercraft_accounts SET MojangTextures = ? WHERE MojangUUID = ?");
        this.authLoadingCache = new AuthLoadingCache<String, CachedAccountInfo>(new AccountLoader(), 120000L);
        this.secureRandom = new SecureRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIsAuthRequiredEvent(EaglercraftIsAuthRequiredEvent event) {
        Random rng;
        String username = new String(event.getAuthUsername(), StandardCharsets.US_ASCII);
        String usrs = username.toString();
        if (!usrs.equals(usrs.replaceAll("[^A-Za-z0-9_]", "_").trim())) {
            event.kickUser("Invalid characters in username");
            return;
        }
        if (username.length() < 3) {
            event.kickUser("Username must be at least 3 characters");
            return;
        }
        if (username.length() > 16) {
            event.kickUser("Username must be under 16 characters");
            return;
        }
        CachedAccountInfo info = this.authLoadingCache.get(username);
        if (info == null) {
            event.kickUser(this.notRegisteredScreenText);
            return;
        }
        event.setAuthAttachment(info);
        event.setAuthRequired(EaglercraftIsAuthRequiredEvent.AuthResponse.REQUIRE);
        event.setAuthMessage(this.passwordPromptScreenText);
        event.setUseAuthMethod(EaglercraftIsAuthRequiredEvent.AuthMethod.EAGLER_SHA256);
        byte[] randomBytes = new byte[32];
        SecureRandom secureRandom = this.secureRandom;
        synchronized (secureRandom) {
            rng = new Random(this.secureRandom.nextLong());
        }
        rng.nextBytes(randomBytes);
        byte[] saltingData = new byte[64];
        System.arraycopy(info.hashSalt, 0, saltingData, 0, 32);
        System.arraycopy(randomBytes, 0, saltingData, 32, 32);
        event.setSaltingData(saltingData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAuthPasswordEvent(EaglercraftHandleAuthPasswordEvent event) {
        CachedAccountInfo info = (CachedAccountInfo)event.getAuthAttachment();
        if (info == null) {
            event.setLoginDenied(this.notRegisteredScreenText);
            return;
        }
        byte[] responseHash = event.getAuthPasswordDataResponse();
        if (responseHash.length != 32) {
            event.setLoginDenied("Wrong number of bits in checksum!");
            return;
        }
        byte[] saltingData = event.getAuthSaltingData();
        SHA256Digest digest = new SHA256Digest();
        digest.update(info.hashBase, 0, 32);
        digest.update(saltingData, 32, 32);
        digest.update(HashUtils.EAGLER_SHA256_SALT_BASE, 0, 32);
        byte[] hashed = new byte[32];
        digest.doFinal(hashed, 0);
        if (!Arrays.equals(hashed, responseHash)) {
            event.setLoginDenied(this.wrongPasswordScreenText);
            EaglerXBungee.logger().warning("User \"" + info.mojangUsername + "\" entered the wrong password while logging in from: " + event.getRemoteAddress().getHostAddress());
            return;
        }
        try {
            PreparedStatement preparedStatement = this.setLastLogin;
            synchronized (preparedStatement) {
                this.setLastLogin.setDate(1, new Date(System.currentTimeMillis()));
                this.setLastLogin.setString(2, event.getRemoteAddress().getHostAddress());
                this.setLastLogin.setString(3, DefaultAuthSystem.getMojangUUID(info.mojangUUID));
                if (this.setLastLogin.executeUpdate() == 0) {
                    throw new SQLException("Query did not alter the database");
                }
            }
        }
        catch (SQLException ex) {
            EaglerXBungee.logger().log(Level.SEVERE, "Could not update last login for \"" + info.mojangUUID.toString() + "\"", ex);
        }
        event.setLoginAllowed();
        event.setProfileUsername(info.mojangUsername);
        event.setProfileUUID(info.mojangUUID);
        byte[] texturesProp = info.texturesProperty;
        if (texturesProp != null) {
            try {
                DataInputStream dis = new DataInputStream(new ByteArrayInputStream(texturesProp));
                int valueLen = dis.readInt();
                int sigLen = dis.readInt();
                byte[] valueBytes = new byte[valueLen];
                dis.read(valueBytes);
                String valueB64 = Base64.encodeBase64String((byte[])valueBytes);
                String sigB64 = null;
                if (sigLen > 0) {
                    valueBytes = new byte[sigLen];
                    dis.read(valueBytes);
                    sigB64 = Base64.encodeBase64String((byte[])valueBytes);
                }
                event.applyTexturesProperty(valueB64, sigB64);
                event.setOverrideEaglerToVanillaSkins(this.overrideEaglerToVanillaSkins);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processSetPassword(ProxiedPlayer player, String password) throws TooManyRegisteredOnIPException, AuthException {
        PendingConnection conn = player.getPendingConnection();
        if (conn instanceof EaglerInitialHandler) {
            throw new AuthException("Cannot register from an eaglercraft account!");
        }
        if (!conn.isOnlineMode()) {
            throw new AuthException("Cannot register without online mode enabled!");
        }
        try {
            String uuid = DefaultAuthSystem.getMojangUUID(player.getUniqueId());
            PreparedStatement preparedStatement = this.registerUser;
            synchronized (preparedStatement) {
                int cnt;
                PreparedStatement preparedStatement2 = this.isRegisteredUser;
                synchronized (preparedStatement2) {
                    block34: {
                        this.isRegisteredUser.setString(1, uuid);
                        Throwable throwable = null;
                        Object var9_11 = null;
                        try (ResultSet set = this.isRegisteredUser.executeQuery();){
                            if (set.next()) {
                                cnt = set.getInt(1);
                                break block34;
                            }
                            throw new SQLException("Empty ResultSet recieved while checking if user exists");
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                }
                SHA256Digest digest = new SHA256Digest();
                int passLen = password.length();
                digest.update((byte)(passLen >> 8 & 0xFF));
                digest.update((byte)(passLen & 0xFF));
                int i = 0;
                while (i < passLen) {
                    char codePoint = password.charAt(i);
                    digest.update((byte)(codePoint >> 8 & 0xFF));
                    digest.update((byte)(codePoint & 0xFF));
                    ++i;
                }
                digest.update(HashUtils.EAGLER_SHA256_SALT_SAVE, 0, 32);
                byte[] hashed = new byte[32];
                digest.doFinal(hashed, 0);
                byte[] randomBytes = new byte[32];
                SecureRandom secureRandom = this.secureRandom;
                synchronized (secureRandom) {
                    this.secureRandom.nextBytes(randomBytes);
                }
                digest.reset();
                digest.update(hashed, 0, 32);
                digest.update(randomBytes, 0, 32);
                digest.update(HashUtils.EAGLER_SHA256_SALT_BASE, 0, 32);
                digest.doFinal(hashed, 0);
                String username = player.getName();
                this.authLoadingCache.evict(username);
                if (cnt > 0) {
                    PreparedStatement preparedStatement3 = this.updatePassword;
                    synchronized (preparedStatement3) {
                        this.updatePassword.setBytes(1, hashed);
                        this.updatePassword.setBytes(2, randomBytes);
                        this.updatePassword.setString(3, uuid);
                        if (this.updatePassword.executeUpdate() <= 0) {
                            throw new AuthException("Update password query did not alter the database!");
                        }
                    }
                } else {
                    String sockAddr = DefaultAuthSystem.sockAddrToString(player.getSocketAddress());
                    if (this.maxRegistrationsPerIP > 0 && this.countUsersOnIP(sockAddr) >= this.maxRegistrationsPerIP) {
                        throw new TooManyRegisteredOnIPException(sockAddr);
                    }
                    Date nowDate = new Date(System.currentTimeMillis());
                    this.registerUser.setInt(1, 1);
                    this.registerUser.setString(2, uuid);
                    this.registerUser.setString(3, username);
                    LoginResult res = ((InitialHandler)player.getPendingConnection()).getLoginProfile();
                    if (res != null) {
                        this.registerUser.setBytes(4, DefaultAuthSystem.getTexturesProperty(res));
                    } else {
                        this.registerUser.setBytes(4, null);
                    }
                    this.registerUser.setBytes(5, hashed);
                    this.registerUser.setBytes(6, randomBytes);
                    this.registerUser.setDate(7, nowDate);
                    this.registerUser.setString(8, sockAddr);
                    if (this.registerUser.executeUpdate() <= 0) {
                        throw new AuthException("Registration query did not alter the database!");
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new AuthException("Failed to query database!", ex);
        }
    }

    private static byte[] getTexturesProperty(LoginResult profile) {
        try {
            Property[] props = profile.getProperties();
            int i = 0;
            while (i < props.length) {
                Property prop = props[i];
                if ("textures".equals(prop.getName())) {
                    byte[] texturesData = Base64.decodeBase64((String)prop.getValue());
                    byte[] signatureData = prop.getSignature() == null ? new byte[]{} : Base64.decodeBase64((String)prop.getSignature());
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    DataOutputStream dao = new DataOutputStream(bao);
                    dao.writeInt(texturesData.length);
                    dao.writeInt(signatureData.length);
                    dao.write(texturesData);
                    dao.write(signatureData);
                    return bao.toByteArray();
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pruneUsers(long before) throws AuthException {
        try {
            this.authLoadingCache.flush();
            PreparedStatement preparedStatement = this.pruneUsers;
            synchronized (preparedStatement) {
                this.pruneUsers.setDate(1, new Date(before));
                return this.pruneUsers.executeUpdate();
            }
        }
        catch (SQLException ex) {
            throw new AuthException("Failed to query database!", ex);
        }
    }

    public int countUsersOnIP(String addr) throws AuthException {
        PreparedStatement preparedStatement = this.getRegistrationsOnIP;
        synchronized (preparedStatement) {
            try {
                this.getRegistrationsOnIP.setString(1, addr);
                Throwable throwable = null;
                Object var4_6 = null;
                try (ResultSet set = this.getRegistrationsOnIP.executeQuery();){
                    if (set.next()) {
                        return set.getInt(1);
                    }
                    throw new SQLException("Empty ResultSet recieved while counting accounts");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException ex) {
                throw new AuthException("Failed to query database!", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleVanillaLogin(PostLoginEvent loginEvent) {
        ProxiedPlayer player = loginEvent.getPlayer();
        PendingConnection con = player.getPendingConnection();
        if (!(con instanceof EaglerInitialHandler)) {
            java.util.Date lastLogin = null;
            String lastLoginIP = null;
            boolean isRegistered = false;
            PreparedStatement preparedStatement = this.checkRegistrationByUUID;
            synchronized (preparedStatement) {
                block26: {
                    UUID uuid = player.getUniqueId();
                    try {
                        PreparedStatement preparedStatement2;
                        String uuidString;
                        block25: {
                            uuidString = DefaultAuthSystem.getMojangUUID(uuid);
                            this.checkRegistrationByUUID.setString(1, DefaultAuthSystem.getMojangUUID(player.getUniqueId()));
                            Throwable throwable = null;
                            preparedStatement2 = null;
                            try (ResultSet res = this.checkRegistrationByUUID.executeQuery();){
                                if (!res.next()) break block25;
                                isRegistered = true;
                                int vers = res.getInt(1);
                                String username = res.getString(2);
                                lastLogin = res.getDate(3);
                                lastLoginIP = res.getString(4);
                                String playerName = player.getName();
                                if (playerName.equals(username)) break block25;
                                EaglerXBungee.logger().info("Player \"" + uuid.toString() + "\" changed their username from \"" + username + " to \"" + playerName + "\", updating authentication database...");
                                PreparedStatement preparedStatement3 = this.updateMojangUsername;
                                synchronized (preparedStatement3) {
                                    this.updateMojangUsername.setString(1, playerName);
                                    this.updateMojangUsername.setString(2, uuidString);
                                    if (this.updateMojangUsername.executeUpdate() == 0) {
                                        throw new SQLException("Failed to update username to \"" + playerName + "\"");
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        byte[] texProperty = DefaultAuthSystem.getTexturesProperty(((InitialHandler)con).getLoginProfile());
                        if (texProperty == null) break block26;
                        preparedStatement2 = this.updateTextures;
                        synchronized (preparedStatement2) {
                            this.updateTextures.setBytes(1, texProperty);
                            this.updateTextures.setString(2, uuidString);
                            this.updateTextures.executeUpdate();
                        }
                    }
                    catch (SQLException ex) {
                        EaglerXBungee.logger().log(Level.SEVERE, "Could not look up UUID \"" + uuid.toString() + "\" in auth database!", ex);
                    }
                }
            }
            if (isRegistered) {
                if (lastLogin != null) {
                    java.util.Date juLastLogin = new java.util.Date(lastLogin.getTime());
                    Calendar calendar = Calendar.getInstance();
                    int yearToday = calendar.get(1);
                    calendar.setTime(juLastLogin);
                    String dateStr = calendar.get(1) != yearToday ? new SimpleDateFormat("EE, MMM d, yyyy, HH:mm z").format(juLastLogin) : new SimpleDateFormat("EE, MMM d, HH:mm z").format(juLastLogin);
                    TextComponent comp = new TextComponent(this.lastEaglerLoginMessage.replace("$date", dateStr).replace("$ip", lastLoginIP));
                    comp.setColor(ChatColor.GREEN);
                    player.sendMessage((BaseComponent)comp);
                }
                player.sendMessage((BaseComponent)new TextComponent(this.useChangeCommandText));
            } else {
                player.sendMessage((BaseComponent)new TextComponent(this.useRegisterCommandText));
            }
        }
    }

    private void destroyStatement(Statement stmt) {
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void flush() {
        this.authLoadingCache.flush();
    }

    public void destroy() {
        this.destroyStatement(this.registerUser);
        this.destroyStatement(this.isRegisteredUser);
        this.destroyStatement(this.pruneUsers);
        this.destroyStatement(this.updatePassword);
        this.destroyStatement(this.updateMojangUsername);
        this.destroyStatement(this.getRegistrationsOnIP);
        this.destroyStatement(this.checkRegistrationByUUID);
        this.destroyStatement(this.checkRegistrationByName);
        this.destroyStatement(this.setLastLogin);
        this.destroyStatement(this.updateTextures);
        try {
            this.databaseConnection.close();
            EaglerXBungee.logger().info("Successfully disconnected from database '" + this.uri + "'");
        }
        catch (SQLException e) {
            EaglerXBungee.logger().log(Level.WARNING, "Exception disconnecting from database '" + this.uri + "'!", e);
        }
    }

    public static String getMojangUUID(UUID uuid) {
        char[] ret = new char[32];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        int i = 0;
        while (i < 16) {
            int j = 15 - i << 2;
            ret[i] = HEX[(int)(msb >> j & 0xFL)];
            ret[i + 16] = HEX[(int)(lsb >> j & 0xFL)];
            ++i;
        }
        return new String(ret);
    }

    public static UUID parseMojangUUID(String uuid) {
        long msb = 0L;
        long lsb = 0L;
        int i = 0;
        while (i < 16) {
            int j = 15 - i << 2;
            msb |= (long)hexString.indexOf(uuid.charAt(i)) << j;
            lsb |= (long)hexString.indexOf(uuid.charAt(i + 16)) << j;
            ++i;
        }
        return new UUID(msb, lsb);
    }

    private static String sockAddrToString(SocketAddress addr) {
        if (addr instanceof InetSocketAddress) {
            return ((InetSocketAddress)addr).getAddress().getHostAddress();
        }
        return "127.0.0.1";
    }

    protected class AccountLoader
    implements AuthLoadingCache.CacheLoader<String, CachedAccountInfo> {
        protected AccountLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CachedAccountInfo load(String key) {
            try {
                CachedAccountInfo cachedInfo = null;
                PreparedStatement preparedStatement = DefaultAuthSystem.this.checkRegistrationByName;
                synchronized (preparedStatement) {
                    DefaultAuthSystem.this.checkRegistrationByName.setString(1, key);
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (ResultSet res = DefaultAuthSystem.this.checkRegistrationByName.executeQuery();){
                        if (res.next()) {
                            cachedInfo = new CachedAccountInfo(res.getInt(1), DefaultAuthSystem.parseMojangUUID(res.getString(2)), key, res.getBytes(3), res.getBytes(4), res.getBytes(5), res.getDate(6), res.getString(7), res.getDate(8), res.getString(9));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                return cachedInfo;
            }
            catch (SQLException ex) {
                throw new AuthException("Failed to query database!", ex);
            }
        }
    }

    public static class AuthException
    extends RuntimeException {
        public AuthException(String msg) {
            super(msg);
        }

        public AuthException(Throwable t) {
            super(t);
        }

        public AuthException(String msg, Throwable t) {
            super(msg, t);
        }
    }

    public static class AuthSystemException
    extends RuntimeException {
        public AuthSystemException() {
        }

        public AuthSystemException(String message, Throwable cause) {
            super(message, cause);
        }

        public AuthSystemException(String message) {
            super(message);
        }

        public AuthSystemException(Throwable cause) {
            super(cause);
        }
    }

    protected class CachedAccountInfo {
        protected int version;
        protected UUID mojangUUID;
        protected String mojangUsername;
        protected byte[] texturesProperty;
        protected byte[] hashBase;
        protected byte[] hashSalt;
        protected long registered;
        protected String registeredIP;
        protected long lastLogin;
        protected String lastLoginIP;

        protected CachedAccountInfo(int version, UUID mojangUUID, String mojangUsername, byte[] texturesProperty, byte[] hashBase, byte[] hashSalt, Date registered, String registeredIP, Date lastLogin, String lastLoginIP) {
            this(version, mojangUUID, mojangUsername, texturesProperty, hashBase, hashSalt, registered == null ? 0L : registered.getTime(), registeredIP, lastLogin == null ? 0L : lastLogin.getTime(), lastLoginIP);
        }

        protected CachedAccountInfo(int version, UUID mojangUUID, String mojangUsername, byte[] texturesProperty, byte[] hashBase, byte[] hashSalt, long registered, String registeredIP, long lastLogin, String lastLoginIP) {
            this.version = version;
            this.mojangUUID = mojangUUID;
            this.mojangUsername = mojangUsername;
            this.texturesProperty = texturesProperty;
            this.hashBase = hashBase;
            this.hashSalt = hashSalt;
            this.registered = registered;
            this.registeredIP = registeredIP;
            this.lastLogin = lastLogin;
            this.lastLoginIP = lastLoginIP;
        }
    }

    public static class TooManyRegisteredOnIPException
    extends AuthException {
        public TooManyRegisteredOnIPException(String ip) {
            super(ip);
        }
    }
}

