/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.teavm;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import net.lax1dude.eaglercraft.v1_8.buildtools.gui.TeaVMBinaries;

public class TeaVMBridge {
    private static URLClassLoader classLoader = null;

    public static boolean compileTeaVM(Map<String, Object> map) throws TeaVMClassLoadException, TeaVMRuntimeException {
        Object object;
        File[] fileArray = TeaVMBinaries.getTeaVMCompilerClasspath();
        URL[] uRLArray = new URL[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            try {
                uRLArray[n] = fileArray[n].toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new TeaVMClassLoadException("Could not resolve URL for: " + fileArray[n].getAbsolutePath(), malformedURLException);
            }
            ++n;
        }
        Method method = null;
        try {
            if (classLoader == null) {
                classLoader = new URLClassLoader(uRLArray, ClassLoader.getSystemClassLoader());
            }
            object = classLoader.loadClass("net.lax1dude.eaglercraft.v1_8.buildtools.task.teavm.TeaVMBridgeImpl");
            Method[] methodArray = ((Class)object).getDeclaredMethods();
            int n2 = 0;
            while (n2 < methodArray.length) {
                Method method2 = methodArray[n2];
                if (method2.getName().equals("compileTeaVM")) {
                    method = method2;
                }
                ++n2;
            }
            if (method == null) {
                throw new NoSuchMethodException("compileTeaVM");
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | TeaVMClassLoadException exception) {
            throw new TeaVMClassLoadException("Could not link TeaVM compiler!", exception);
        }
        catch (RuntimeException runtimeException) {
            String string = runtimeException.getMessage();
            if (string.startsWith("[TeaVMBridge]")) {
                throw new TeaVMRuntimeException(string.substring(13).trim(), runtimeException.getCause());
            }
            throw new TeaVMRuntimeException("Uncaught exception was thrown!", runtimeException);
        }
        catch (Throwable throwable) {
            throw new TeaVMRuntimeException("Uncaught exception was thrown!", throwable);
        }
        try {
            object = method.invoke(null, map);
            return object != null && object instanceof Boolean && (Boolean)object != false;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new TeaVMRuntimeException("Uncaught exception was thrown!", invocationTargetException.getCause());
        }
        catch (Throwable throwable) {
            throw new TeaVMRuntimeException("Failed to invoke 'compileTeaVM'!", throwable);
        }
    }

    public static void free() {
        if (classLoader != null) {
            try {
                classLoader.close();
                classLoader = null;
            }
            catch (IOException iOException) {
                System.err.println("Memory leak, failed to release TeaVM JAR ClassLoader!");
                iOException.printStackTrace();
            }
        }
    }

    public static class TeaVMClassLoadException
    extends RuntimeException {
        public TeaVMClassLoadException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public TeaVMClassLoadException(String string) {
            super(string);
        }
    }

    public static class TeaVMRuntimeException
    extends RuntimeException {
        public TeaVMRuntimeException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public TeaVMRuntimeException(String string) {
            super(string);
        }
    }
}

