/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildTools;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildToolsConfig;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.DecompileMinecraft;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.FFMPEG;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.InitMCP;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.MinecraftLocator;
import org.apache.commons.io.FileUtils;

public class InitTask {
    private static File locatedMCPZip = null;
    private static File locatedMinecraftJar = null;
    private static File locatedAssetsJson = null;

    public static boolean initTask() {
        try {
            return InitTask.initTask0();
        }
        catch (Throwable throwable) {
            System.err.println();
            System.err.println("Exception encountered while running task 'init'!");
            throwable.printStackTrace();
            return false;
        }
    }

    private static boolean initTask0() throws Throwable {
        File file;
        File file2;
        System.out.println("Scanning 'mcp918' folder...");
        File file3 = new File(EaglerBuildTools.repositoryRoot, "mcp918");
        if (!file3.isDirectory()) {
            System.err.println("ERROR: \"" + file3.getAbsolutePath() + "\" is not a directory!");
            return false;
        }
        File[] fileArray = file3.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            file2 = fileArray[n2];
            if (file2.getName().equalsIgnoreCase("mcp918.zip")) {
                locatedMCPZip = file2;
            }
            if (locatedMCPZip == null && file2.getName().endsWith(".zip")) {
                locatedMCPZip = file2;
            }
            if (file2.getName().equalsIgnoreCase("1.8.8.jar")) {
                locatedMinecraftJar = file2;
            }
            if (locatedMinecraftJar == null && file2.getName().endsWith(".jar")) {
                locatedMinecraftJar = file2;
            }
            if (file2.getName().equalsIgnoreCase("1.8.json")) {
                locatedAssetsJson = file2;
            }
            if (locatedAssetsJson == null && file2.getName().endsWith(".json")) {
                locatedAssetsJson = file2;
            }
            ++n2;
        }
        if (locatedMCPZip == null) {
            System.err.println("ERROR: could not find ./mcp918/mcp918.zip! Please locate it and copy it into the 'mcp918' folder.");
            return false;
        }
        if (locatedMinecraftJar == null && (locatedMinecraftJar = MinecraftLocator.locateMinecraftVersionJar("1.8.8")) == null) {
            System.err.println("ERROR: could not find ./mcp918/1.8.8.jar! Please locate it and copy it into the 'mcp918' folder.");
            return false;
        }
        if (locatedAssetsJson == null && (locatedAssetsJson = MinecraftLocator.locateMinecraftVersionAssets("1.8")) == null) {
            System.err.println("ERROR: could not find ./mcp918/1.8.json! Please locate it and copy it into the 'mcp918' folder.");
            return false;
        }
        FFMPEG.confirmFFMPEG();
        file2 = EaglerBuildToolsConfig.getTemporaryDirectory();
        n2 = file2.exists() ? 1 : 0;
        if (!(n2 == 0 || file2.isDirectory() && file2.list().length == 0)) {
            System.out.println();
            System.out.println("Notice: BuildTools is already initialized.");
            System.out.println();
            System.out.println("you must revert all changes in the 'patches' directory of");
            System.out.println("this repo back to the main repository's current commits,");
            System.out.println("otherwise the 'pullrequest' command wll not work properly");
            System.out.println();
            System.out.print("Do you want to re-initialize? [Y/n]: ");
            String string = "n";
            try {
                string = new BufferedReader(new InputStreamReader(System.in)).readLine();
            }
            catch (IOException iOException) {}
            string = string.toLowerCase();
            if (!string.startsWith("y")) {
                System.out.println();
                System.out.println("Ok nice, the re-init will be cancelled. (thank god)");
                return true;
            }
            try {
                FileUtils.deleteDirectory(file2);
                n2 = 0;
            }
            catch (IOException iOException) {
                System.err.println("ERROR: Could not delete \"" + file2.getAbsolutePath() + "\"!");
                iOException.printStackTrace();
                return false;
            }
        }
        if (!(file = new File(file2, "ModCoderPack")).isDirectory() && !file.mkdirs()) {
            System.err.println("ERROR: failed to create \"" + file.getAbsolutePath() + "\"!");
            return false;
        }
        boolean bl = false;
        if (!bl && !InitMCP.initTask(locatedMCPZip, file)) {
            System.err.println("ERROR: could not initialize MCP from \"" + locatedMCPZip.getAbsolutePath() + "\"!");
            return false;
        }
        File file4 = new File(file2, "MinecraftSrc");
        if (!file4.isDirectory() && !file4.mkdirs()) {
            System.err.println("ERROR: failed to create \"" + file4.getAbsolutePath() + "\"!");
            return false;
        }
        if (!DecompileMinecraft.decompileMinecraft(file, locatedMinecraftJar, file4, locatedAssetsJson, true)) {
            System.err.println("ERROR: could not decompile and patch 1.8.8.jar from \"" + locatedMinecraftJar.getAbsolutePath() + "\"!");
            return false;
        }
        return true;
    }
}

