/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.diff;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.Patch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildToolsConfig;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.ApplyPatchesToZip;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.EaglerContextRedacted;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.JARMemoryCache;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.Lines;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.diff.PullRequestTask;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.CSVMappings;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.InsertJavaDoc;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.SetupWorkspace;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class MergePullRequest {
    private static final CharsetDecoder utf8Decoder = StandardCharsets.UTF_8.newDecoder();

    public static boolean mergeTask() {
        try {
            return MergePullRequest.mergeTask0();
        }
        catch (Throwable throwable) {
            System.err.println();
            System.err.println("Exception encountered while running task 'merge'!");
            throwable.printStackTrace();
            return false;
        }
    }

    private static boolean mergeTask0() throws Throwable {
        int n;
        File file;
        File file2;
        File file3;
        Comparable<File> comparable;
        Serializable serializable;
        Object object;
        boolean bl;
        File file4 = new File("pullrequest");
        if (!file4.isDirectory() || FileUtils.isEmptyDirectory(file4)) {
            System.err.println("ERROR: the 'pullrequest' directory does not exist or is empty, aborting merge because there's nothing to merge");
            return false;
        }
        if (new File(file4, "merged.txt").exists()) {
            System.err.println("ERROR: the 'pullrequest' directory has already been merged, aborting merge because there's nothing to merge");
            System.err.println("To override, delete 'merged.txt' from the folder.");
            return false;
        }
        System.out.println();
        System.out.println("Warning: running 'merge' is a command only intended to be used");
        System.out.println("by the repository's owner, it will perminantly incorporate all");
        System.out.println("changes in the 'pullrequest' directory into this repository's");
        System.out.println("patch file directory!");
        System.out.println();
        System.out.println("Doing so will make it impossible to reliably create any future");
        System.out.println("pull requests back to this project's main repository, unless the");
        System.out.println("main repository has merged the same pull request into it's patch");
        System.out.println("file directory too.");
        System.out.println();
        System.out.println("Back up the current state of the patch file directory in a local");
        System.out.println("commit or branch to allow you to undo any unintentional changes");
        System.out.println("made to the directory as a result of running this command.");
        System.out.println();
        System.out.print("Do you really want to do this? [Y/n]: ");
        String string = "n";
        try {
            string = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException iOException) {}
        string = string.toLowerCase();
        if (!string.startsWith("y")) {
            System.out.println();
            System.out.println("OKAY THANK GOD, crisis averted!");
            System.out.println();
            System.out.println("Thank the author of this tool kindly for providing this check.");
            return true;
        }
        System.out.println();
        System.out.println("Warning: close all programs that may have files or folders open");
        System.out.println("in the repository or the merge could fail catastrophically");
        System.out.println();
        System.out.println("This folder: " + new File(".").getAbsolutePath());
        System.out.println();
        System.out.println("Check for any file explorer windows displaying the contents of a");
        System.out.println("file or folder in this directory.");
        System.out.println();
        System.out.println("Close any programs with files open someplace in this folder.");
        System.out.println();
        System.out.println("If merging fails, revert all changes in this directory with git");
        System.out.println("or a backup, re-run 'init', then run 'pullrequest' and 'merge'");
        System.out.println();
        System.out.print("Did you close everything? [Y/n]: ");
        string = "n";
        try {
            string = new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException iOException) {}
        string = string.toLowerCase();
        if (!string.startsWith("y")) {
            System.out.println();
            System.out.println("OKAY THANK GOD, crisis averted!");
            System.out.println();
            System.out.println("Thank the author of this tool kindly for providing this check.");
            return true;
        }
        System.out.println();
        File file5 = EaglerBuildToolsConfig.getTemporaryDirectory();
        System.out.println();
        File file6 = new File(file4, "source");
        File file7 = new File(file4, "resources");
        boolean bl2 = file6.isDirectory() && !FileUtils.isEmptyDirectory(file6);
        boolean bl3 = bl = file7.isDirectory() && !FileUtils.isEmptyDirectory(file7);
        if (!bl2 && !bl) {
            System.err.println("ERROR: the 'pullrequest' directory does not exist or is empty, aborting merge because there's nothing to merge");
            return false;
        }
        if (bl2) {
            object = new File(file5, "MinecraftSrc/minecraft_src.jar");
            if (!((File)object).isFile()) {
                System.err.println("ERROR: file '" + ((File)object).getName() + "' was not found!");
                System.err.println("Run the 'init' task again to re-generate it");
                return false;
            }
            serializable = new File(file5, "MinecraftSrc/minecraft_src_patch.jar");
            if (!((File)serializable).isFile()) {
                System.err.println("ERROR: file '" + ((File)serializable).getName() + "' was not found!");
                System.err.println("Run the 'init' task again to re-generate it");
                return false;
            }
            comparable = new File(file5, "MinecraftSrc/minecraft_src_merge.jar");
            file3 = new File(file5, "MinecraftSrc/minecraft_src_merge_diffs.zip");
            System.out.println("Applying pull request to '" + ((File)serializable).getName() + "'...");
            System.out.println();
            ApplyPatchesToZip.applyPatches((File)serializable, (File)object, file6, (File)comparable, true, false);
            try {
                MergePullRequest.createMergeDiffs((File)comparable, (File)object, file3);
            }
            catch (Throwable throwable) {
                ((File)comparable).delete();
                throw throwable;
            }
            System.out.println();
            file2 = new File("./patches/minecraft");
            file = new File("./patches.bak/minecraft");
            if (file2.exists()) {
                System.out.println("Backing up '" + file2.getAbsolutePath() + "'...");
                try {
                    FileUtils.deleteDirectory(file);
                    FileUtils.moveDirectory(file2, file);
                }
                catch (Throwable throwable) {
                    ((File)comparable).delete();
                    throw throwable;
                }
            }
            FileUtils.copyFile(new File(file, "output_license.txt"), new File(file2, "output_license.txt"));
            System.out.println("Extracting '" + file3 + "' to 'patches/minecraft'...");
            n = SetupWorkspace.extractJarTo(file3, file2);
            if (!file3.delete()) {
                System.err.println("ERROR: could not delete '" + file3.getName() + "'!");
            }
            System.out.println("Wrote " + n + " files.");
            System.out.println("Copying '" + ((File)comparable).getName() + "' to '" + ((File)serializable).getName() + "'...");
            if (((File)serializable).exists() && !((File)serializable).delete() || !((File)comparable).renameTo((File)serializable)) {
                System.err.println("ERROR: could not copy '" + ((File)comparable).getName() + "' to '" + ((File)serializable).getName() + "'!");
                System.err.println("Run the 'init' task again before proceeding");
                ((File)serializable).delete();
            } else {
                File file8 = new File(file5, "MinecraftSrc/minecraft_src_javadoc.jar");
                CSVMappings cSVMappings = new CSVMappings();
                if (!InsertJavaDoc.processSource((File)serializable, file8, new File(file5, "ModCoderPack"), cSVMappings)) {
                    System.err.println();
                    System.err.println("ERROR: Could not create javadoc!");
                    return false;
                }
            }
            if (((File)comparable).exists()) {
                ((File)comparable).delete();
            }
            System.out.println("Deleting backup folder...");
            try {
                FileUtils.deleteDirectory(file);
            }
            catch (Throwable throwable) {
                System.err.println("ERROR: could not delete 'patches.bak/minecraft'!");
                System.err.println(throwable.toString());
            }
            System.out.println();
        }
        if (bl) {
            object = new File(file5, "MinecraftSrc/minecraft_res.jar");
            if (!((File)object).isFile()) {
                System.err.println("ERROR: file '" + ((File)object).getName() + "' was not found!");
                System.err.println("Run the 'init' task again to re-generate it");
                return false;
            }
            serializable = new File(file5, "MinecraftSrc/minecraft_res_patch.jar");
            if (!((File)serializable).isFile()) {
                System.err.println("ERROR: file '" + ((File)serializable).getName() + "' was not found!");
                System.err.println("Run the 'init' task again to re-generate it");
                return false;
            }
            comparable = new File(file5, "MinecraftSrc/minecraft_res_merge.jar");
            file3 = new File(file5, "MinecraftSrc/minecraft_res_merge_diffs.zip");
            System.out.println("Applying pull request to '" + ((File)serializable).getName() + "'...");
            System.out.println();
            ApplyPatchesToZip.applyPatches((File)serializable, (File)object, file7, (File)comparable, true, false);
            try {
                MergePullRequest.createMergeDiffs(comparable, (File)object, file3);
            }
            catch (Throwable throwable) {
                ((File)comparable).delete();
                throw throwable;
            }
            System.out.println();
            file2 = new File("./patches/resources");
            file = new File("./patches.bak/resources");
            if (file2.exists()) {
                System.out.println("Backing up '" + file2.getAbsolutePath() + "'...");
                try {
                    FileUtils.deleteDirectory(file);
                    FileUtils.moveDirectory(file2, file);
                }
                catch (Throwable throwable) {
                    ((File)comparable).delete();
                    throw throwable;
                }
            }
            System.out.println("Extracting '" + file3 + "' to 'patches/resources'...");
            n = SetupWorkspace.extractJarTo(file3, file2);
            if (!file3.delete()) {
                System.err.println("ERROR: could not delete '" + file3.getName() + "'!");
            }
            System.out.println("Wrote " + n + " files.");
            System.out.println("Copying '" + ((File)comparable).getName() + "' to '" + ((File)serializable).getName() + "'...");
            if (((File)serializable).exists() && !((File)serializable).delete() || !((File)comparable).renameTo((File)serializable)) {
                System.err.println("ERROR: could not copy '" + ((File)comparable).getName() + "' to '" + ((File)serializable).getName() + "'!");
                System.err.println("Run the 'init' task again before proceeding");
                ((File)serializable).delete();
            }
            if (((File)comparable).exists()) {
                ((File)comparable).delete();
            }
            System.out.println("Deleting backup folder...");
            try {
                FileUtils.deleteDirectory(file);
            }
            catch (Throwable throwable) {
                System.err.println("ERROR: could not delete 'patches.bak/resources'!");
                System.err.println(throwable.getMessage());
            }
            System.out.println();
        }
        new File("./patches.bak").delete();
        System.out.println("Successfully merged pullrequest directory!");
        try {
            object = new SimpleDateFormat("MM-dd-yy");
            serializable = new SimpleDateFormat("kk:mm:ss");
            comparable = new Date();
            FileUtils.writeStringToFile(new File(file4, "merged.txt"), "This pullrequest was merged on " + ((DateFormat)object).format(new Date()) + " at " + ((DateFormat)serializable).format((Date)comparable) + ".", "UTF-8");
        }
        catch (IOException iOException) {
            System.err.println("ERROR: could not write 'merged.txt' in pullrequest directory!");
            System.err.println("Creating a file called 'merged.txt' is important to tell buildtools that the");
            System.err.println("existing pullrequest has already been merged! Do not try to merge it again!");
        }
        System.out.println("Backing up to 'pullrequest_merged_backup'...");
        object = file4.getAbsolutePath();
        if (((String)object).endsWith("/") || ((String)object).endsWith("\\")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        if (((File)(serializable = new File(String.valueOf(object) + "_merged_backup"))).exists() && !FileUtils.deleteQuietly((File)serializable)) {
            System.err.println("Could not delete old backup!");
            serializable = new File(String.valueOf(object) + "_merged_backup1");
            if (((File)serializable).exists() && !FileUtils.deleteQuietly((File)serializable)) {
                System.err.println("Could not delete 2nd old backup!");
                return true;
            }
        }
        try {
            FileUtils.moveDirectory(file4, (File)serializable);
        }
        catch (IOException iOException) {
            System.err.println("Could not create backup!");
        }
        return true;
    }

    private static void createMergeDiffs(File file, File file2, File file3) throws Throwable {
        Object object;
        Map<String, byte[]> map;
        FileInputStream fileInputStream;
        System.out.println("Creating patches from '" + file.getName() + "'...");
        System.out.println("Loading files from '" + file2.getName() + "'...");
        Object object2 = null;
        Serializable serializable = null;
        try {
            fileInputStream = new FileInputStream(file2);
            try {
                map = JARMemoryCache.loadJAR(fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object2 == null) {
                object2 = throwable;
            } else if (object2 != throwable) {
                ((Throwable)object2).addSuppressed(throwable);
            }
            throw object2;
        }
        if (map == null) {
            throw new IOException("Failed to load JAR into memory: '" + file2.getName());
        }
        System.out.println("Loading files from '" + file.getName() + "'...");
        serializable = null;
        fileInputStream = null;
        try {
            object = new FileInputStream(file);
            try {
                object2 = JARMemoryCache.loadJAR((InputStream)object);
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (Throwable throwable) {
            if (serializable == null) {
                serializable = throwable;
            } else if (serializable != throwable) {
                ((Throwable)serializable).addSuppressed(throwable);
            }
            throw serializable;
        }
        if (object2 == null) {
            throw new IOException("Failed to load JAR into memory: '" + file.getName());
        }
        serializable = new HashSet();
        serializable.addAll(map.keySet());
        System.out.println("Generating patch files..");
        System.out.println("(Writing to: " + file3.getName() + ")");
        System.out.println("(this may take a while)");
        System.out.print("   ");
        int n = 0;
        object = null;
        Object var8_14 = null;
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file3));){
            Object object3;
            Map.Entry entry2;
            zipOutputStream.setLevel(5);
            for (Map.Entry entry2 : object2.entrySet()) {
                object3 = (String)entry2.getKey();
                byte[] byArray = map.get(object3);
                if (byArray == null) {
                    System.err.println("Error: tried to patch file '" + (String)object3 + "' that doesn't exist in the minecraft source");
                    continue;
                }
                serializable.remove(object3);
                if (!MergePullRequest.writeDiff(byArray, (byte[])entry2.getValue(), (String)object3, zipOutputStream) || ++n % 75 != 74) continue;
                System.out.print(".");
            }
            System.out.println();
            System.out.println("Wrote " + n + " patch files.");
            zipOutputStream.putNextEntry(new ZipEntry("delete.txt"));
            entry2 = new PrintWriter(zipOutputStream);
            ((PrintWriter)((Object)entry2)).println("# " + serializable.size() + " files to delete:");
            object3 = serializable.iterator();
            while (object3.hasNext()) {
                String string = (String)object3.next();
                ((PrintWriter)((Object)entry2)).println(string);
            }
            ((PrintWriter)((Object)entry2)).flush();
            System.out.println("Wrote " + serializable.size() + " deletes.");
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private static boolean writeDiff(byte[] byArray, byte[] byArray2, String string, ZipOutputStream zipOutputStream) throws IOException {
        String string2;
        if (Arrays.equals(byArray, byArray2)) {
            return false;
        }
        String string3 = MergePullRequest.toStringIfValid(byArray);
        String string4 = string2 = string3 == null ? null : MergePullRequest.toStringIfValid(byArray2);
        if (string3 == null || string2 == null) {
            zipOutputStream.putNextEntry(new ZipEntry(MergePullRequest.makeName(string, "replace")));
            IOUtils.write(byArray2, (OutputStream)zipOutputStream);
            return true;
        }
        List<String> list = Lines.linesList(string3);
        List<String> list2 = Lines.linesList(string2);
        Patch<String> patch = DiffUtils.diff(list, list2);
        zipOutputStream.putNextEntry(new ZipEntry(MergePullRequest.makeName(string, "edit")));
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)zipOutputStream, "UTF-8"));
        EaglerContextRedacted.writeContextRedacted(patch, printWriter);
        printWriter.flush();
        return true;
    }

    private static String makeName(String string, String string2) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        if (n2 > n + 1) {
            return String.valueOf(string.substring(0, n2)) + "." + string2 + string.substring(n2);
        }
        return String.valueOf(string) + "." + string2;
    }

    private static String toStringIfValid(byte[] byArray) {
        CharBuffer charBuffer;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        try {
            charBuffer = utf8Decoder.decode(byteBuffer);
        }
        catch (Throwable throwable) {
            return null;
        }
        return charBuffer.toString();
    }

    public static boolean mergeDirect() {
        try {
            return MergePullRequest.mergeDirect0();
        }
        catch (Throwable throwable) {
            System.err.println();
            System.err.println("Exception encountered while running task 'merge_direct'!");
            throwable.printStackTrace();
            return false;
        }
    }

    private static boolean mergeDirect0() throws Throwable {
        if (!PullRequestTask.pullRequest()) {
            System.err.println();
            System.err.println("Error: could not create merge_direct pull request!");
            return false;
        }
        try {
            if (!MergePullRequest.mergeTask0()) {
                System.err.println();
                System.err.println("Exception encountered while running task 'merge_direct'!");
                return false;
            }
        }
        catch (Throwable throwable) {
            System.err.println();
            System.err.println("Exception encountered while running task 'merge_direct'!");
            throwable.printStackTrace();
            return false;
        }
        return true;
    }
}

