/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.decompiler;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class LocalVariableGenerator
extends SignatureVisitor {
    public static final Map<Character, String> primitiveNames = new HashMap<Character, String>();
    public static final Set<String> illegalVariableNames = new HashSet<String>();
    private String baseClass = null;
    private boolean isArray = false;
    private String typeParam1 = null;
    private boolean typeParam1IsArray = false;
    private String typeParam2 = null;
    private boolean typeParam2IsArray = false;
    public static final SignatureVisitor nopVisitor;

    static {
        primitiveNames.put(Character.valueOf('Z'), "Flag");
        primitiveNames.put(Character.valueOf('C'), "Char");
        primitiveNames.put(Character.valueOf('B'), "Byte");
        primitiveNames.put(Character.valueOf('S'), "Short");
        primitiveNames.put(Character.valueOf('I'), "Int");
        primitiveNames.put(Character.valueOf('F'), "Float");
        primitiveNames.put(Character.valueOf('J'), "Long");
        primitiveNames.put(Character.valueOf('D'), "Double");
        primitiveNames.put(Character.valueOf('V'), "Void");
        illegalVariableNames.addAll(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "const", "default", "do", "double", "else", "enum", "exports", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "var", "void", "volatile", "while", "string"));
        nopVisitor = new SignatureVisitor(327680){};
    }

    LocalVariableGenerator() {
        super(327680);
    }

    public static String createName(String string) {
        SignatureReader signatureReader = new SignatureReader(string);
        LocalVariableGenerator localVariableGenerator = new LocalVariableGenerator();
        signatureReader.acceptType(localVariableGenerator);
        return localVariableGenerator.getResult();
    }

    private String removePath(String string) {
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(36);
        if (n2 > n && n2 != string.length() - 1) {
            n = n2;
        }
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if (string.length() == 0 || Character.isDigit(string.charAt(0))) {
            string = "obj" + string;
        }
        return string;
    }

    String getResult() {
        String string = this.baseClass == null ? "Object" : this.removePath(this.baseClass);
        if (this.typeParam1 == null && this.typeParam2 == null) {
            if (this.isArray) {
                string = "ArrayOf" + string;
            }
        } else if (this.isArray) {
            string = String.valueOf(string) + "Array";
        }
        if (this.typeParam1 != null && this.typeParam2 == null) {
            if (this.typeParam1IsArray) {
                this.typeParam1 = String.valueOf(this.typeParam1) + "Array";
            }
            string = String.valueOf(string) + "Of" + this.removePath(this.typeParam1);
        } else if (this.typeParam1 != null && this.typeParam2 != null) {
            if (this.typeParam1IsArray) {
                this.typeParam1 = String.valueOf(this.typeParam1) + "Array";
            }
            if (this.typeParam2IsArray) {
                this.typeParam2 = String.valueOf(this.typeParam2) + "Array";
            }
            string = String.valueOf(string) + "Of" + this.removePath(this.typeParam1) + "And" + this.removePath(this.typeParam2);
        }
        return string;
    }

    @Override
    public SignatureVisitor visitArrayType() {
        if (this.baseClass == null) {
            this.isArray = true;
            return new ArrayTypeVisitor();
        }
        return nopVisitor;
    }

    @Override
    public void visitBaseType(char c) {
        if (this.baseClass == null) {
            this.baseClass = primitiveNames.get(Character.valueOf(c));
        }
    }

    @Override
    public SignatureVisitor visitClassBound() {
        return nopVisitor;
    }

    @Override
    public void visitClassType(String string) {
        if (this.baseClass == null) {
            this.baseClass = string;
        }
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        return nopVisitor;
    }

    @Override
    public void visitFormalTypeParameter(String string) {
    }

    @Override
    public void visitInnerClassType(String string) {
    }

    @Override
    public SignatureVisitor visitInterface() {
        return nopVisitor;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        return nopVisitor;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        return nopVisitor;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        return nopVisitor;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        return nopVisitor;
    }

    @Override
    public void visitTypeArgument() {
    }

    @Override
    public SignatureVisitor visitTypeArgument(char c) {
        if (this.typeParam1 == null) {
            return new TypeParamVisitor(1);
        }
        if (this.typeParam2 == null) {
            return new TypeParamVisitor(2);
        }
        return nopVisitor;
    }

    @Override
    public void visitTypeVariable(String string) {
    }

    public static String nextLocalVariableNameFromString(Map<String, Integer> map, String string, String string2) {
        String string3;
        Integer n;
        String string4;
        String string5 = string4 = string.length() == 1 ? primitiveNames.get(Character.valueOf(string.charAt(0))) : null;
        if (string4 == null) {
            string4 = LocalVariableGenerator.createName(string);
        }
        if ((n = map.get(string3 = string4.toLowerCase())) == null) {
            map.put(string3, 1);
            string4 = Character.isDigit(string4.charAt(string4.length() - 1)) ? String.valueOf(string4) + "_1" : (illegalVariableNames.contains(string4.toLowerCase()) ? String.valueOf(string4) + "1" : string4);
        } else {
            int n2 = n + 1;
            map.put(string3, n2);
            string4 = Character.isDigit(string4.charAt(string4.length() - 1)) || string4.contains("And") || string4.length() > 16 ? String.valueOf(string4) + "_" + n2 : String.valueOf(string4) + n2;
        }
        return string2 == null ? LocalVariableGenerator.camelCase(string4) : String.valueOf(string2) + string4;
    }

    public static String nextLocalVariableName(Map<String, Integer> map, LocalVariableGenerator localVariableGenerator, String string) {
        String string2 = localVariableGenerator.getResult();
        String string3 = string2.toLowerCase();
        Integer n = map.get(string3);
        if (n == null) {
            map.put(string3, 1);
            string2 = Character.isDigit(string2.charAt(string2.length() - 1)) ? String.valueOf(string2) + "_1" : (illegalVariableNames.contains(string2.toLowerCase()) ? String.valueOf(string2) + "1" : string2);
        } else {
            int n2 = n + 1;
            map.put(string3, n2);
            string2 = Character.isDigit(string2.charAt(string2.length() - 1)) || string2.contains("And") || string2.length() > 16 ? String.valueOf(string2) + "_" + n2 : String.valueOf(string2) + n2;
        }
        return string == null ? LocalVariableGenerator.camelCase(string2) : String.valueOf(string) + string2;
    }

    public static String camelCase(String string) {
        if (string == null || string.length() <= 0) {
            return "name";
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1))) {
            return "var" + string;
        }
        return String.valueOf(string.substring(0, 1).toLowerCase()) + string.substring(1);
    }

    private class ArrayTypeVisitor
    extends SignatureVisitor {
        protected ArrayTypeVisitor() {
            super(327680);
        }

        @Override
        public void visitBaseType(char c) {
            if (LocalVariableGenerator.this.baseClass == null) {
                LocalVariableGenerator.this.baseClass = primitiveNames.get(Character.valueOf(c));
            }
        }

        @Override
        public void visitClassType(String string) {
            if (LocalVariableGenerator.this.baseClass == null) {
                LocalVariableGenerator.this.baseClass = string;
            }
        }

        @Override
        public SignatureVisitor visitArrayType() {
            if (LocalVariableGenerator.this.baseClass == null) {
                LocalVariableGenerator.this.baseClass = "array";
            }
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitClassBound() {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitExceptionType() {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitInterface() {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitInterfaceBound() {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitParameterType() {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitTypeArgument(char c) {
            return nopVisitor;
        }

        @Override
        public SignatureVisitor visitReturnType() {
            return nopVisitor;
        }
    }

    private class TypeParamVisitor
    extends SignatureVisitor {
        private boolean hasVisited;
        private final int firstOrSecond;

        protected TypeParamVisitor(int n) {
            super(327680);
            this.hasVisited = false;
            this.firstOrSecond = n;
        }

        @Override
        public void visitBaseType(char c) {
            if (!this.hasVisited) {
                if (this.firstOrSecond == 1) {
                    if (LocalVariableGenerator.this.typeParam1 == null) {
                        LocalVariableGenerator.this.typeParam1 = primitiveNames.get(Character.valueOf(c));
                    }
                } else if (this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                    LocalVariableGenerator.this.typeParam2 = primitiveNames.get(Character.valueOf(c));
                }
                this.hasVisited = true;
            }
        }

        @Override
        public void visitClassType(String string) {
            if (!this.hasVisited) {
                if (this.firstOrSecond == 1) {
                    if (LocalVariableGenerator.this.typeParam1 == null) {
                        LocalVariableGenerator.this.typeParam1 = string;
                    }
                } else if (this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                    LocalVariableGenerator.this.typeParam2 = string;
                }
                this.hasVisited = true;
            }
        }

        @Override
        public SignatureVisitor visitArrayType() {
            if (!this.hasVisited) {
                if (this.firstOrSecond == 1) {
                    if (LocalVariableGenerator.this.typeParam1 == null) {
                        LocalVariableGenerator.this.typeParam1IsArray = true;
                        return new TypeParamArrayVisitor();
                    }
                } else if (this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                    LocalVariableGenerator.this.typeParam2IsArray = true;
                    return new TypeParamArrayVisitor();
                }
            }
            return nopVisitor;
        }

        private class TypeParamArrayVisitor
        extends SignatureVisitor {
            protected TypeParamArrayVisitor() {
                super(327680);
            }

            @Override
            public void visitBaseType(char c) {
                if (!TypeParamVisitor.this.hasVisited) {
                    if (TypeParamVisitor.this.firstOrSecond == 1) {
                        if (LocalVariableGenerator.this.typeParam1 == null) {
                            LocalVariableGenerator.this.typeParam1 = primitiveNames.get(Character.valueOf(c));
                        }
                    } else if (TypeParamVisitor.this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                        LocalVariableGenerator.this.typeParam2 = primitiveNames.get(Character.valueOf(c));
                    }
                    TypeParamVisitor.this.hasVisited = true;
                }
            }

            @Override
            public void visitClassType(String string) {
                if (!TypeParamVisitor.this.hasVisited) {
                    if (TypeParamVisitor.this.firstOrSecond == 1) {
                        if (LocalVariableGenerator.this.typeParam1 == null) {
                            LocalVariableGenerator.this.typeParam1 = string;
                        }
                    } else if (TypeParamVisitor.this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                        LocalVariableGenerator.this.typeParam2 = string;
                    }
                    TypeParamVisitor.this.hasVisited = true;
                }
            }

            @Override
            public SignatureVisitor visitArrayType() {
                if (!TypeParamVisitor.this.hasVisited) {
                    if (TypeParamVisitor.this.firstOrSecond == 1) {
                        if (LocalVariableGenerator.this.typeParam1 == null) {
                            LocalVariableGenerator.this.typeParam1 = "array";
                        }
                    } else if (TypeParamVisitor.this.firstOrSecond == 2 && LocalVariableGenerator.this.typeParam2 == null) {
                        LocalVariableGenerator.this.typeParam2 = "array";
                    }
                    TypeParamVisitor.this.hasVisited = true;
                }
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitClassBound() {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitExceptionType() {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitInterface() {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitInterfaceBound() {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitParameterType() {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitTypeArgument(char c) {
                return nopVisitor;
            }

            @Override
            public SignatureVisitor visitReturnType() {
                return nopVisitor;
            }
        }
    }
}

