/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceRulesList {
    private final List<ResourceRule> list;
    private static final ResourceRule defaultRule = new ResourceRule("", true, Action.EXCLUDE, 16000, 48, false);

    public static ResourceRulesList loadResourceRules(File file) throws IOException {
        ArrayList<ResourceRule> arrayList = new ArrayList<ResourceRule>();
        try {
            JSONArray jSONArray = new JSONObject(FileUtils.readFileToString(file, StandardCharsets.UTF_8)).getJSONArray("rules");
            int n = 0;
            int n2 = jSONArray.length();
            while (n < n2) {
                JSONObject jSONObject = jSONArray.getJSONObject(n);
                Iterator<String> iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    JSONObject jSONObject2;
                    String string = iterator.next();
                    JSONObject jSONObject3 = jSONObject.getJSONObject(string);
                    boolean bl = string.endsWith("*");
                    if (bl) {
                        string = string.substring(0, string.length() - 1);
                    }
                    Action action = Action.valueOf(jSONObject3.getString("action").toUpperCase());
                    int n3 = 16000;
                    int n4 = 48;
                    boolean bl2 = false;
                    if (action == Action.ENCODE && (jSONObject2 = jSONObject3.optJSONObject("ffmpeg", null)) != null) {
                        n3 = jSONObject2.optInt("samples", n3);
                        n4 = jSONObject2.optInt("bitrate", n4);
                        bl2 = jSONObject2.optBoolean("stereo", bl2);
                    }
                    arrayList.add(new ResourceRule(string, bl, action, n3, n4, bl2));
                }
                ++n;
            }
        }
        catch (JSONException jSONException) {
            throw new IOException("Invalid JSON file: " + file.getAbsolutePath(), jSONException);
        }
        return new ResourceRulesList(arrayList);
    }

    private ResourceRulesList(List<ResourceRule> list) {
        this.list = list;
    }

    public ResourceRule get(String string) {
        int n = 0;
        int n2 = this.list.size();
        while (n < n2) {
            ResourceRule resourceRule = this.list.get(n);
            if (resourceRule.wildcard ? string.startsWith(resourceRule.path) : string.equals(resourceRule.path)) {
                return resourceRule;
            }
            ++n;
        }
        return defaultRule;
    }

    public static enum Action {
        INCLUDE,
        EXCLUDE,
        ENCODE,
        LANGUAGES_ZIP;

    }

    public static class ResourceRule {
        private final String path;
        private final boolean wildcard;
        public final Action action;
        public final int ffmpegSamples;
        public final int ffmpegBitrate;
        public final boolean ffmpegStereo;

        protected ResourceRule(String string, boolean bl, Action action, int n, int n2, boolean bl2) {
            this.path = string;
            this.wildcard = bl;
            this.action = action;
            this.ffmpegSamples = n;
            this.ffmpegBitrate = n2;
            this.ffmpegStereo = bl2;
        }
    }
}

