/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildTools;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.FFMPEG;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.ResourceRulesList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class LoadResources {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadResources(File file, File file2, File file3, File file4, File file5) {
        System.out.println("Copying resources from '" + file.getName() + "' into '" + file3.getName() + "'");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file3));){
                Object object;
                ZipConstants zipConstants;
                ZipInputStream zipInputStream;
                zipOutputStream.setLevel(5);
                zipOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
                zipOutputStream.write("Manifest-Version: 1.0\nCreated-By: Eaglercraft BuildTools\n".getBytes(StandardCharsets.UTF_8));
                Object object2 = null;
                Throwable throwable2 = null;
                try {
                    zipInputStream = new ZipInputStream(new FileInputStream(file));
                    try {
                        while ((zipConstants = zipInputStream.getNextEntry()) != null) {
                            if (((ZipEntry)zipConstants).isDirectory()) continue;
                            object = ((ZipEntry)zipConstants).getName();
                            if (((String)object).startsWith("/")) {
                                object = ((String)object).substring(1);
                            }
                            if (((String)object).startsWith("META-INF") || ((String)object).endsWith(".class")) continue;
                            zipOutputStream.putNextEntry((ZipEntry)zipConstants);
                            IOUtils.copy((InputStream)zipInputStream, (OutputStream)zipOutputStream, 4096);
                        }
                    }
                    finally {
                        if (zipInputStream != null) {
                            zipInputStream.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (object2 == null) {
                        object2 = throwable3;
                        throw object2;
                    }
                    if (object2 == throwable3) throw object2;
                    ((Throwable)object2).addSuppressed(throwable3);
                    throw object2;
                }
                System.out.println();
                System.out.println("Reading 'assetsIndexTransformer.json'...");
                try {
                    object2 = ResourceRulesList.loadResourceRules(new File(EaglerBuildTools.repositoryRoot, "mcp918/assetsIndexTransformer.json"));
                }
                catch (IOException iOException) {
                    System.err.println();
                    System.err.println("ERROR: failed to read 'mcp918/assetsIndexTransformer.json'!");
                    iOException.printStackTrace();
                    if (zipOutputStream == null) return false;
                    zipOutputStream.close();
                    return false;
                }
                System.out.println();
                System.out.println("Reading asset index '" + file2.getAbsolutePath() + "'...");
                throwable2 = null;
                zipInputStream = null;
                try {
                    zipConstants = new ZipOutputStream(new FileOutputStream(file5));
                    try {
                        ((ZipOutputStream)zipConstants).setLevel(5);
                        try {
                            object = new JSONObject(FileUtils.readFileToString(file2, StandardCharsets.UTF_8)).getJSONObject("objects");
                            Iterator<String> iterator = ((JSONObject)object).keys();
                            System.out.println("Downloading assets from 'https://resources.download.minecraft.net/'...");
                            while (iterator.hasNext()) {
                                byte[] byArray;
                                String string;
                                block54: {
                                    ResourceRulesList.ResourceRule resourceRule;
                                    block53: {
                                        URL uRL;
                                        string = iterator.next();
                                        JSONObject jSONObject = ((JSONObject)object).getJSONObject(string);
                                        resourceRule = ((ResourceRulesList)object2).get(string);
                                        if (resourceRule.action == ResourceRulesList.Action.EXCLUDE) {
                                            System.out.println("Skipping file '" + string + "'");
                                            continue;
                                        }
                                        String string2 = jSONObject.getString("hash");
                                        int n = jSONObject.getInt("size");
                                        System.out.println("Downloading '" + string + "' (" + LoadResources.formatByteLength(n) + ") ...");
                                        try {
                                            uRL = new URL("https://resources.download.minecraft.net/" + string2.substring(0, 2) + "/" + string2);
                                        }
                                        catch (MalformedURLException malformedURLException) {
                                            System.err.println("Resource file '" + string + "' had an invalid URL!");
                                            malformedURLException.printStackTrace();
                                            continue;
                                        }
                                        byArray = new byte[n];
                                        try {
                                            Throwable throwable4 = null;
                                            Object var22_36 = null;
                                            try (InputStream inputStream = uRL.openStream();){
                                                String string3;
                                                StringBuilder stringBuilder;
                                                int n2 = 0;
                                                int n3 = 0;
                                                while (true) {
                                                    if (n2 == n || (n3 = inputStream.read(byArray, n2, n - n2)) <= 0) {
                                                        int n4 = inputStream.available();
                                                        if (n2 != n || n4 > 0) {
                                                            stringBuilder = new StringBuilder("File '").append(uRL.toString()).append("' was the wrong length! ");
                                                            if (n4 <= 0) break;
                                                            string3 = n4 + " bytes remaining";
                                                            throw new IOException(stringBuilder.append(string3).toString());
                                                        }
                                                        break block53;
                                                    }
                                                    n2 += n3;
                                                }
                                                string3 = n - n2 + " bytes missing";
                                                throw new IOException(stringBuilder.append(string3).toString());
                                            }
                                            catch (Throwable throwable5) {
                                                if (throwable4 == null) {
                                                    throwable4 = throwable5;
                                                    throw throwable4;
                                                }
                                                if (throwable4 == throwable5) throw throwable4;
                                                throwable4.addSuppressed(throwable5);
                                                throw throwable4;
                                            }
                                        }
                                        catch (IOException iOException) {
                                            System.err.println("Resource file '" + uRL.toString() + "' could not be downloaded!");
                                            iOException.printStackTrace();
                                            continue;
                                        }
                                    }
                                    if (resourceRule.action == ResourceRulesList.Action.ENCODE) {
                                        try {
                                            System.out.println(" - encoding ogg: " + resourceRule.ffmpegSamples / 1000 + "kHz, " + resourceRule.ffmpegBitrate + "kbps, " + (resourceRule.ffmpegStereo ? "stereo" : "mono"));
                                            byArray = FFMPEG.encodeOgg(file4, byArray, resourceRule.ffmpegSamples, resourceRule.ffmpegBitrate, resourceRule.ffmpegStereo);
                                            break block54;
                                        }
                                        catch (IOException iOException) {
                                            System.err.println("Resource file '" + string + "' could not be encoded!");
                                            iOException.printStackTrace();
                                            continue;
                                        }
                                    }
                                    if (resourceRule.action == ResourceRulesList.Action.LANGUAGES_ZIP) {
                                        int n = string.lastIndexOf(47);
                                        if (n != -1) {
                                            string = string.substring(n + 1);
                                        }
                                        System.out.println(" - writing language '" + string + "' to '" + file5.getName() + "'");
                                        ((ZipOutputStream)zipConstants).putNextEntry(new ZipEntry(string));
                                        ((FilterOutputStream)((Object)zipConstants)).write(byArray);
                                        continue;
                                    }
                                }
                                zipOutputStream.putNextEntry(new ZipEntry("assets/" + string));
                                zipOutputStream.write(byArray);
                            }
                        }
                        catch (IOException | JSONException exception) {
                            System.err.println("ERROR: failed to download additional assets from '" + file2.getName() + "'!");
                            exception.printStackTrace();
                            if (zipConstants != null) {
                                ((ZipOutputStream)zipConstants).close();
                            }
                            if (zipOutputStream == null) return false;
                            zipOutputStream.close();
                            return false;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (zipConstants == null) throw throwable6;
                        ((ZipOutputStream)zipConstants).close();
                        throw throwable6;
                    }
                }
                catch (Throwable throwable7) {
                    if (throwable2 == null) {
                        throwable2 = throwable7;
                        throw throwable2;
                    }
                    if (throwable2 == throwable7) throw throwable2;
                    throwable2.addSuppressed(throwable7);
                    throw throwable2;
                }
                if (zipConstants == null) return true;
                ((ZipOutputStream)zipConstants).close();
                return true;
            }
            catch (Throwable throwable8) {
                if (throwable == null) {
                    throwable = throwable8;
                    throw throwable;
                }
                if (throwable == throwable8) throw throwable;
                throwable.addSuppressed(throwable8);
                throw throwable;
            }
        }
        catch (IOException iOException) {
            System.err.println("ERROR: failed to copy from '" + file.getName() + "' -> '" + file3.getName() + "'!");
            iOException.printStackTrace();
            return false;
        }
    }

    private static String formatByteLength(int n) {
        if (n < 4096) {
            return "" + n;
        }
        if (n < 0x400000) {
            return n / 1024 + "k";
        }
        return n / 1024 / 1024 + "M";
    }
}

