/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FFMPEG {
    public static final boolean windows = System.getProperty("os.name").toLowerCase().contains("windows");
    public static String foundFFMPEG = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void confirmFFMPEG() {
        if (FFMPEG.checkFFMPEGOnPath()) {
            foundFFMPEG = "ffmpeg";
            return;
        }
        if (windows) {
            File file = new File("mcp918/ffmpeg.exe");
            if (file.isFile()) {
                foundFFMPEG = file.getAbsolutePath();
                return;
            }
            System.out.println();
            System.out.println("ERROR: 'ffmpeg.exe' wasn't found in the 'mcp918' folder!");
            System.out.println();
            System.out.println("Please visit one of the following URLs to download it:");
            System.out.println(" - https://www.gyan.dev/ffmpeg/builds/");
            System.out.println(" - https://github.com/BtbN/FFmpeg-Builds/releases");
            System.out.println();
            System.out.println("Locate 'bin/ffmpeg.exe' in the .zip file you download and");
            System.out.println("place it in the 'mcp918' folder and press enter to continue");
            System.out.println();
            try {
                while (System.in.read() != 10) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {}
            FFMPEG.confirmFFMPEG();
            return;
        }
        do {
            File file;
            if ((file = new File("mcp918/ffmpeg")).isFile() && file.canExecute()) {
                foundFFMPEG = file.getAbsolutePath();
                return;
            }
            System.out.println();
            System.out.println("ERROR: ffmpeg is not installed on this system!");
            System.out.println();
            System.out.println("Please install it to continue, you can use the package");
            System.out.println("manager on most distros to do this automatically:");
            System.out.println(" - Debian: apt install ffmpeg");
            System.out.println(" - Ubuntu: apt install ffmpeg");
            System.out.println(" - Fedora: dnf install ffmpeg");
            System.out.println(" - Arch: pacman -S ffmpeg");
            System.out.println();
            System.out.println("Alternatively, place the 'ffmpeg' executable in the");
            System.out.println("'mcp918' folder of this repository");
            System.out.println();
            System.out.println("Make sure it has chmod +x");
            System.out.println();
            System.out.println("Press enter to continue once it has installed");
            System.out.println();
            try {
                while (System.in.read() != 10) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {}
        } while (!FFMPEG.checkFFMPEGOnPath());
        foundFFMPEG = "ffmpeg";
    }

    public static int run(File file, String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        if (foundFFMPEG == null) {
            FFMPEG.confirmFFMPEG();
        }
        stringArray2[0] = foundFFMPEG;
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray2);
        processBuilder.directory(file);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        try {
            Process process = processBuilder.start();
            while (true) {
                try {
                    return process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            System.err.println("Could not start ffmpeg process!");
            iOException.printStackTrace();
            return -1;
        }
    }

    public static byte[] encodeOgg(File file, byte[] byArray, int n, int n2, boolean bl) throws IOException {
        File file2 = new File(file, "temp.src.ogg");
        FileUtils.writeByteArrayToFile(file2, byArray);
        File file3 = new File(file, "temp.dst.ogg");
        int n3 = bl ? FFMPEG.run(file, "-y", "-v", "error", "-i", "temp.src.ogg", "-c:a", "libvorbis", "-ac", "2", "-apply_phase_inv", "1", "-b:a", n2 + "k", "-ar", "" + n, "temp.dst.ogg") : FFMPEG.run(file, "-y", "-v", "error", "-i", "temp.src.ogg", "-c:a", "libvorbis", "-ac", "1", "-apply_phase_inv", "0", "-b:a", n2 + "k", "-ar", "" + n, "temp.dst.ogg");
        file2.delete();
        if (n3 != 0) {
            throw new IOException("FFMPEG returned error code: " + n3);
        }
        byte[] byArray2 = FileUtils.readFileToByteArray(file3);
        file3.delete();
        return byArray2;
    }

    public static boolean checkFFMPEGOnPath() {
        int n;
        Process process;
        ProcessBuilder processBuilder = new ProcessBuilder("ffmpeg", "-version");
        try {
            process = processBuilder.start();
        }
        catch (IOException iOException) {
            return false;
        }
        while (true) {
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return n == 0;
    }
}

