/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.init;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.lax1dude.eaglercraft.v1_8.buildtools.EaglerBuildToolsConfig;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.CSVMappings;
import net.lax1dude.eaglercraft.v1_8.buildtools.task.init.InsertJavaDoc;
import org.apache.commons.io.IOUtils;

public class CreateUnpatched {
    public static boolean createUnpatched() {
        try {
            return CreateUnpatched.createUnpatched0();
        }
        catch (Throwable throwable) {
            System.err.println();
            System.err.println("Exception encountered while running task 'unpatched'!");
            throwable.printStackTrace();
            return false;
        }
    }

    private static boolean createUnpatched0() throws Throwable {
        File file = EaglerBuildToolsConfig.getTemporaryDirectory();
        File file2 = new File(file, "ModCoderPack");
        File file3 = new File(file, "MinecraftSrc/minecraft_src.jar");
        File file4 = new File(file, "MinecraftSrc/minecraft_res.jar");
        File file5 = new File("./MinecraftSrc.zip");
        if (file5.exists()) {
            System.err.println("ERROR: The file 'MinecraftSrc.zip' already exists in this directory!");
            System.err.println("Delete it and re-run 'unpatched' to try again");
            return false;
        }
        if (!file2.isDirectory()) {
            System.err.println("The '" + file2.getName() + "' directory was not found in the temporary directory!");
            System.err.println("Please run the 'init' command to create it");
            return false;
        }
        if (!file3.isFile()) {
            System.err.println("The '" + file3.getName() + "' file was not found in the temporary directory!");
            System.err.println("Please run the 'init' command to create it");
            return false;
        }
        if (!file4.isFile()) {
            System.err.println("The '" + file4.getName() + "' file was not found in the temporary directory!");
            System.err.println("Please run the 'init' command to create it");
            return false;
        }
        File file6 = new File(file, "MinecraftSrc/minecraft_unpatched_javadoc.jar");
        System.out.println();
        System.out.println("Preparing source in '" + file3.getName() + "'...");
        System.out.println();
        CSVMappings cSVMappings = new CSVMappings();
        InsertJavaDoc.processSource(file3, file6, file2, cSVMappings, false);
        Throwable throwable = null;
        Object var8_9 = null;
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file5));){
            int n;
            FileInputStream fileInputStream;
            zipOutputStream.setLevel(0);
            System.out.println("Extracting '" + file6.getName() + "' into '" + file5.getName() + "'...");
            Throwable throwable2 = null;
            Object var12_15 = null;
            try {
                fileInputStream = new FileInputStream(file6);
                try {
                    n = CreateUnpatched.extractZipTo(new ZipInputStream(fileInputStream), zipOutputStream, "src");
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            System.out.println("Extracted " + n + " files.");
            System.out.println();
            System.out.println("Extracting '" + file4.getName() + "' into '" + file5.getName() + "'...");
            throwable2 = null;
            var12_15 = null;
            try {
                fileInputStream = new FileInputStream(file4);
                try {
                    n = CreateUnpatched.extractZipTo(new ZipInputStream(fileInputStream), zipOutputStream, "res");
                }
                finally {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                } else if (throwable2 != throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
            System.out.println("Extracted " + n + " files.");
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
        if (!file6.delete()) {
            System.err.println();
            System.err.println("ERROR: failed to delete '" + file6.getName() + "' from temporary directory!");
        }
        return true;
    }

    private static int extractZipTo(ZipInputStream zipInputStream, ZipOutputStream zipOutputStream, String string) throws IOException {
        ZipEntry zipEntry;
        int n = 0;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) continue;
            String string2 = zipEntry.getName();
            if (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            if (string2.startsWith("META-INF")) continue;
            ZipEntry zipEntry2 = new ZipEntry(String.valueOf(string) + "/" + string2);
            zipOutputStream.putNextEntry(zipEntry2);
            IOUtils.copy((InputStream)zipInputStream, (OutputStream)zipOutputStream, 8192);
            ++n;
        }
        return n;
    }
}

