/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.task.diff;

import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.ChangeDelta;
import com.github.difflib.patch.Chunk;
import com.github.difflib.patch.DeleteDelta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.InsertDelta;
import com.github.difflib.patch.Patch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class EaglerContextRedacted {
    public static void writeContextRedacted(Patch<String> patch, PrintWriter printWriter) {
        Date date = new Date();
        printWriter.println();
        printWriter.println("# Eagler Context Redacted Diff");
        printWriter.println("# Copyright (c) " + new SimpleDateFormat("yyyy").format(date) + " lax1dude. All rights reserved.");
        printWriter.println();
        printWriter.println("# Version: 1.0");
        printWriter.println("# Author: lax1dude");
        printWriter.println();
        int n = 0;
        int n2 = 0;
        List<AbstractDelta<String>> list = patch.getDeltas();
        int n3 = 0;
        int n4 = list.size();
        while (n3 < n4) {
            block9: {
                String string;
                String string2;
                AbstractDelta<String> abstractDelta = list.get(n3);
                DeltaType deltaType = abstractDelta.getType();
                switch (deltaType) {
                    case CHANGE: {
                        string2 = "> CHANGE";
                        string = "~ ";
                        break;
                    }
                    case DELETE: {
                        string2 = "> DELETE";
                        string = "- ";
                        break;
                    }
                    case EQUAL: {
                        break block9;
                    }
                    case INSERT: {
                        string2 = "> INSERT";
                        string = "+ ";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid type " + (Object)((Object)deltaType) + " for delta " + n3);
                    }
                }
                Chunk<String> chunk = abstractDelta.getSource();
                int n5 = chunk.getPosition();
                int n6 = chunk.getLines().size();
                int n7 = n5 - n;
                Chunk<String> chunk2 = abstractDelta.getTarget();
                int n8 = chunk2.getPosition();
                List<String> list2 = chunk2.getLines();
                int n9 = list2.size();
                int n10 = n8 - n2;
                printWriter.println(String.valueOf(string2) + "  " + n10 + (n9 > 0 ? " : " + (n10 + n9) : "") + "  @  " + n7 + (n6 > 0 ? " : " + (n7 + n6) : ""));
                printWriter.println();
                if (n9 > 0) {
                    int n11 = 0;
                    int n12 = list2.size();
                    while (n11 < n12) {
                        printWriter.println(String.valueOf(string) + list2.get(n11));
                        ++n11;
                    }
                    printWriter.println();
                }
                n = n5 + n6;
                n2 = n8 + n9;
            }
            ++n3;
        }
        printWriter.println("> EOF");
    }

    public static Patch<String> readContextRestricted(List<String> list, BufferedReader bufferedReader) throws IOException {
        String string;
        Patch<String> patch = new Patch<String>();
        DeltaType deltaType = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        ArrayList<String> arrayList = null;
        int n5 = 0;
        int n6 = 0;
        block17: while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 2) continue;
            if (string.charAt(1) != ' ') {
                throw new IOException("Unknown line type: " + string.substring(0, 2));
            }
            char c = string.charAt(0);
            String string2 = string.substring(2);
            switch (c) {
                case '#': {
                    Object object;
                    Object object2;
                    int n7 = string2.indexOf(58);
                    if (n7 <= 0 || !((String)(object2 = string2.substring(0, n7).trim().toLowerCase())).equals("version") || ((String)(object = string2.substring(n7 + 1).trim())).equals("1.0")) continue block17;
                    throw new IOException("Unsupported format version: " + (String)object);
                }
                case '>': {
                    Object object2 = string2.trim().split("[\\s]+");
                    if (((String[])object2).length == 1 && object2[0].equals("EOF")) break block17;
                    if (!(((String[])object2).length >= 4 && (((String)object2[2]).equals("@") && (((Object)object2).length == 4 || ((Object)object2).length == 6 && ((String)object2[4]).equals(":")) || ((String)object2[2]).equals(":") && (((Object)object2).length == 6 && ((String)object2[4]).equals("@") || ((Object)object2).length == 8 && ((String)object2[4]).equals("@") && ((String)object2[6]).equals(":"))))) {
                        throw new IOException("Invalid block: [ " + String.join((CharSequence)" ", (CharSequence[])object2) + " ]");
                    }
                    if (deltaType != null) {
                        patch.addDelta(EaglerContextRedacted.makeDelta(deltaType, n5 += n, n2, n6 += n3, n4, list, arrayList));
                        n5 += n2;
                        n6 += n4;
                    }
                    switch (object2[0]) {
                        case "CHANGE": {
                            deltaType = DeltaType.CHANGE;
                            break;
                        }
                        case "DELETE": {
                            deltaType = DeltaType.DELETE;
                            break;
                        }
                        case "INSERT": {
                            deltaType = DeltaType.INSERT;
                            break;
                        }
                        default: {
                            throw new IOException("Unknown line block: " + (String)object2[0]);
                        }
                    }
                    arrayList = null;
                    n3 = EaglerContextRedacted.parseInt((String)object2[1]);
                    if (((String)object2[2]).equals(":")) {
                        n4 = EaglerContextRedacted.parseInt((String)object2[3]) - n3;
                        n = EaglerContextRedacted.parseInt((String)object2[5]);
                        if (((Object)object2).length == 8) {
                            n2 = EaglerContextRedacted.parseInt((String)object2[7]) - n;
                            break;
                        }
                        n2 = 0;
                        break;
                    }
                    n4 = 0;
                    n = EaglerContextRedacted.parseInt((String)object2[3]);
                    if (((Object)object2).length == 6) {
                        n2 = EaglerContextRedacted.parseInt((String)object2[5]) - n;
                        break;
                    }
                    n2 = 0;
                    break;
                }
                case '~': {
                    if (deltaType != DeltaType.CHANGE) {
                        throw new IOException("Read an unexpected CHANGE line in a " + deltaType + " block: " + string);
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(string2);
                    break;
                }
                case '-': {
                    if (deltaType != DeltaType.DELETE) {
                        throw new IOException("Read an unexpected DELETE line in a " + deltaType + " block: " + string);
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(string2);
                    break;
                }
                case '+': {
                    if (deltaType != DeltaType.INSERT) {
                        throw new IOException("Read an unexpected INSERT line in a " + deltaType + " block: " + string);
                    }
                    if (arrayList == null) {
                        arrayList = new ArrayList();
                    }
                    arrayList.add(string2);
                    break;
                }
                default: {
                    throw new IOException("Unknown line type: " + c);
                }
            }
        }
        if (deltaType != null) {
            patch.addDelta(EaglerContextRedacted.makeDelta(deltaType, n5 += n, n2, n6 += n3, n4, list, arrayList));
            n5 += n2;
            n6 += n4;
        }
        return patch;
    }

    private static int parseInt(String string) throws IOException {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Value is not a valid integer: \"" + string + "\"");
        }
    }

    private static AbstractDelta<String> makeDelta(DeltaType deltaType, int n, int n2, int n3, int n4, List<String> list, List<String> list2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>(n2);
        int n5 = 0;
        while (n5 < n2) {
            arrayList.add(list.get(n + n5));
            ++n5;
        }
        if (list2 == null) {
            list2 = new ArrayList<String>(0);
        }
        if (n4 != list2.size()) {
            throw new IOException((Object)((Object)deltaType) + " block at sourceStart " + n + " is " + n4 + " lines long but only " + list2.size() + " lines were read!");
        }
        switch (deltaType) {
            case CHANGE: {
                return new ChangeDelta<String>(new Chunk(n, arrayList), new Chunk<String>(n3, list2));
            }
            case DELETE: {
                return new DeleteDelta<String>(new Chunk(n, arrayList), new Chunk<String>(n3, list2));
            }
            case INSERT: {
                return new InsertDelta<String>(new Chunk(n, arrayList), new Chunk<String>(n3, list2));
            }
        }
        throw new IllegalArgumentException("Invalid delta type: " + (Object)((Object)deltaType));
    }
}

