/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.gui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class MakeOfflineDownload {
    private static File currentJarFile = null;
    private static URLClassLoader classLoader = null;
    private static Method mainMethod = null;

    public static void compilerMain(File file, String[] stringArray) throws InvocationTargetException {
        if (currentJarFile != null && !currentJarFile.equals(file)) {
            throw new IllegalArgumentException("Cannot load two different MakeOfflineDownload versions into the same runtime");
        }
        if (mainMethod == null) {
            currentJarFile = file;
            try {
                if (classLoader == null) {
                    classLoader = new URLClassLoader(new URL[]{file.toURI().toURL()}, ClassLoader.getSystemClassLoader());
                }
                Class<?> clazz = classLoader.loadClass("net.lax1dude.eaglercraft.v1_8.buildtools.workspace.MakeOfflineDownload");
                mainMethod = clazz.getDeclaredMethod("main", String[].class);
            }
            catch (SecurityException | MalformedURLException exception) {
                throw new IllegalArgumentException("Illegal MakeOfflineDownload JAR path!", exception);
            }
            catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                throw new IllegalArgumentException("MakeOfflineDownload JAR does not contain main class: 'net.lax1dude.eaglercraft.v1_8.buildtools.workspace.MakeOfflineDownload'", reflectiveOperationException);
            }
        }
        try {
            mainMethod.invoke(null, new Object[]{stringArray});
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new IllegalArgumentException("MakeOfflineDownload JAR does not contain valid 'main' method", exception);
        }
    }

    public static void free() {
        if (classLoader != null) {
            try {
                classLoader.close();
                classLoader = null;
            }
            catch (IOException iOException) {
                System.err.println("Memory leak, failed to release MakeOfflineDownload ClassLoader!");
                iOException.printStackTrace();
            }
        }
    }
}

