/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.AsyncSkinProvider;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ICacheProvider;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ISkinService;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.JDBCCacheProvider;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinPackets;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.protocol.Property;
import org.apache.commons.codec.binary.Base64;

public class SkinService
implements ISkinService {
    public static final int masterRateLimitPerPlayer = 250;
    public static final int PACKET_MY_SKIN_PRESET = 1;
    public static final int PACKET_MY_SKIN_CUSTOM = 2;
    public static final int PACKET_GET_OTHER_SKIN = 3;
    public static final int PACKET_OTHER_SKIN_PRESET = 4;
    public static final int PACKET_OTHER_SKIN_CUSTOM = 5;
    public static final String CHANNEL = "EAG|Skins-1.8";
    private final Map<UUID, CachedPlayerSkin> onlinePlayersCache = new HashMap<UUID, CachedPlayerSkin>();
    private final Multimap<UUID, UUID> onlinePlayersFromTexturesMap = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Map<UUID, UUID> onlinePlayersToTexturesMap = new HashMap<UUID, UUID>();
    private final Map<UUID, CachedForeignSkin> foreignSkinCache = new HashMap<UUID, CachedForeignSkin>();
    private final Map<UUID, PendingTextureDownload> pendingTextures = new HashMap<UUID, PendingTextureDownload>();
    private final Map<UUID, PendingProfileUUIDLookup> pendingUUIDs = new HashMap<UUID, PendingProfileUUIDLookup>();
    private final Map<String, PendingProfileNameLookup> pendingNameLookups = new HashMap<String, PendingProfileNameLookup>();
    private final TObjectIntMap<UUID> antagonists = new TObjectIntHashMap();
    private long antagonistCooldown = System.currentTimeMillis();
    private final Consumer<Set<UUID>> antagonistLogger = new Consumer<Set<UUID>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Set<UUID> t) {
            if (t.size() == 1) {
                int limit = EaglerXBungee.getEagler().getConfig().getAntagonistsRateLimit() << 1;
                UUID offender = t.iterator().next();
                TObjectIntMap tObjectIntMap = SkinService.this.antagonists;
                synchronized (tObjectIntMap) {
                    int v = SkinService.this.antagonists.get((Object)offender);
                    if (v == SkinService.this.antagonists.getNoEntryValue()) {
                        SkinService.this.antagonists.put((Object)offender, 1);
                    } else if (v <= limit) {
                        SkinService.this.antagonists.put((Object)offender, v + 1);
                    }
                }
            }
        }
    };
    private ICacheProvider cacheProvider = null;
    private static final String hexString = "0123456789abcdef";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @Override
    public void init(String uri, String driverClass, String driverPath, int keepObjectsDays, int keepProfilesDays, int maxObjects, int maxProfiles) {
        this.antagonistCooldown = System.currentTimeMillis();
        if (this.cacheProvider == null) {
            this.cacheProvider = JDBCCacheProvider.initialize(uri, driverClass, driverPath, keepObjectsDays, keepProfilesDays, maxObjects, maxProfiles);
        }
        this.resetMaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processGetOtherSkin(UUID searchUUID, UserConnection sender) {
        CachedPlayerSkin maybeCachedPacket;
        EaglerInitialHandler eaglerHandler = (EaglerInitialHandler)sender.getPendingConnection();
        if (!eaglerHandler.skinLookupRateLimiter.rateLimit(250)) {
            return;
        }
        Map<UUID, CachedPlayerSkin> map = this.onlinePlayersCache;
        synchronized (map) {
            maybeCachedPacket = this.onlinePlayersCache.get(searchUUID);
        }
        if (maybeCachedPacket != null) {
            sender.sendData(CHANNEL, maybeCachedPacket.data);
        } else {
            UUID playerTexture;
            ProxiedPlayer player = BungeeCord.getInstance().getPlayer(searchUUID);
            Map<UUID, UUID> map2 = this.onlinePlayersToTexturesMap;
            synchronized (map2) {
                playerTexture = this.onlinePlayersToTexturesMap.get(searchUUID);
            }
            if (playerTexture != null) {
                CachedForeignSkin foreignSkin;
                boolean playersExist;
                Collection possiblePlayers;
                Multimap<UUID, UUID> multimap = this.onlinePlayersFromTexturesMap;
                synchronized (multimap) {
                    possiblePlayers = this.onlinePlayersFromTexturesMap.get((Object)playerTexture);
                }
                boolean bl = playersExist = possiblePlayers.size() > 0;
                if (playersExist) {
                    for (UUID uuid : possiblePlayers) {
                        Map<UUID, CachedPlayerSkin> map3 = this.onlinePlayersCache;
                        synchronized (map3) {
                            maybeCachedPacket = this.onlinePlayersCache.get(uuid);
                        }
                        if (maybeCachedPacket == null) continue;
                        byte[] rewritten = SkinPackets.rewriteUUID(searchUUID, maybeCachedPacket.data);
                        if (player != null) {
                            Map<UUID, CachedPlayerSkin> map4 = this.onlinePlayersCache;
                            synchronized (map4) {
                                this.onlinePlayersCache.put(searchUUID, new CachedPlayerSkin(rewritten, maybeCachedPacket.textureUUID, maybeCachedPacket.modelId));
                            }
                        }
                        sender.sendData(CHANNEL, rewritten);
                        return;
                    }
                }
                Map<UUID, Object> map5 = this.foreignSkinCache;
                synchronized (map5) {
                    foreignSkin = this.foreignSkinCache.get(playerTexture);
                }
                if (foreignSkin != null && foreignSkin.modelKnown != -1) {
                    if (player != null) {
                        map5 = this.onlinePlayersCache;
                        synchronized (map5) {
                            this.onlinePlayersCache.put(searchUUID, new CachedPlayerSkin(SkinPackets.rewriteUUID(searchUUID, foreignSkin.data), playerTexture, foreignSkin.modelKnown));
                        }
                        map5 = this.foreignSkinCache;
                        synchronized (map5) {
                            this.foreignSkinCache.remove(playerTexture);
                        }
                    }
                    foreignSkin.lastHit = System.currentTimeMillis();
                    sender.sendData(CHANNEL, foreignSkin.data);
                    return;
                }
            }
            if (player != null && player instanceof UserConnection) {
                Property[] props;
                LoginResult loginProfile;
                if (player instanceof UserConnection && (loginProfile = ((UserConnection)player).getPendingConnection().getLoginProfile()) != null && (props = loginProfile.getProperties()).length > 0) {
                    int i = 0;
                    while (i < props.length) {
                        block58: {
                            Property pp = props[i];
                            if (pp.getName().equals("textures")) {
                                try {
                                    CachedForeignSkin foreignSkin;
                                    JsonElement url;
                                    String jsonStr = SkinPackets.bytesToAscii(Base64.decodeBase64((String)pp.getValue()));
                                    JsonObject json = new JsonParser().parse(jsonStr).getAsJsonObject();
                                    JsonObject skinObj = json.getAsJsonObject("SKIN");
                                    if (skinObj == null || (url = json.get("url")) == null) break block58;
                                    String urlStr = url.getAsString();
                                    if ((urlStr = SkinService.sanitizeTextureURL(urlStr)) == null) break;
                                    int model = 0;
                                    JsonElement el = skinObj.get("metadata");
                                    if (el != null && el.isJsonObject() && (el = el.getAsJsonObject().get("model")) != null) {
                                        model = SkinPackets.getModelId(el.getAsString());
                                    }
                                    UUID skinUUID = SkinPackets.createEaglerURLSkinUUID(urlStr);
                                    Map<UUID, CachedForeignSkin> map6 = this.foreignSkinCache;
                                    synchronized (map6) {
                                        foreignSkin = this.foreignSkinCache.remove(skinUUID);
                                    }
                                    if (foreignSkin != null) {
                                        this.registerTextureToPlayerAssociation(skinUUID, searchUUID);
                                        byte[] rewrite = SkinPackets.rewriteUUIDModel(searchUUID, foreignSkin.data, model);
                                        Map<UUID, CachedPlayerSkin> map7 = this.onlinePlayersCache;
                                        synchronized (map7) {
                                            this.onlinePlayersCache.put(searchUUID, new CachedPlayerSkin(rewrite, skinUUID, model));
                                        }
                                        sender.sendData(CHANNEL, rewrite);
                                        return;
                                    }
                                    if (!this.isLimitedAsAntagonist(player.getUniqueId())) {
                                        this.processResolveURLTextureForOnline(sender, searchUUID, skinUUID, urlStr, model);
                                    }
                                    return;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        ++i;
                    }
                }
                if (!this.isLimitedAsAntagonist(player.getUniqueId())) {
                    if (player.getPendingConnection().isOnlineMode()) {
                        this.processResolveProfileTextureByUUIDForOnline(sender, searchUUID);
                    } else {
                        this.processResolveProfileTextureByNameForOnline(sender, player.getPendingConnection().getName(), searchUUID);
                    }
                }
            } else {
                CachedForeignSkin foreignSkin;
                Map<UUID, CachedForeignSkin> map8 = this.foreignSkinCache;
                synchronized (map8) {
                    foreignSkin = this.foreignSkinCache.get(searchUUID);
                }
                if (foreignSkin != null) {
                    foreignSkin.lastHit = System.currentTimeMillis();
                    sender.sendData(CHANNEL, foreignSkin.data);
                } else if (eaglerHandler.skinUUIDLookupRateLimiter.rateLimit(EaglerXBungee.getEagler().getConfig().getUuidRateLimitPlayer()) && !this.isLimitedAsAntagonist(sender.getUniqueId())) {
                    this.processResolveProfileTextureByUUIDForeign(sender, searchUUID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processGetOtherSkin(UUID searchUUID, String skinURL, UserConnection sender) {
        CachedForeignSkin foreignSkin;
        EaglerBungeeConfig config = EaglerXBungee.getEagler().getConfig();
        EaglerInitialHandler eaglerHandler = (EaglerInitialHandler)sender.getPendingConnection();
        if (!eaglerHandler.skinLookupRateLimiter.rateLimit(250)) {
            return;
        }
        Map<UUID, CachedForeignSkin> map = this.foreignSkinCache;
        synchronized (map) {
            foreignSkin = this.foreignSkinCache.get(searchUUID);
        }
        if (foreignSkin != null) {
            foreignSkin.lastHit = System.currentTimeMillis();
            sender.sendData(CHANNEL, foreignSkin.data);
        } else {
            boolean playersExist;
            Collection possiblePlayers;
            Multimap<UUID, UUID> multimap = this.onlinePlayersFromTexturesMap;
            synchronized (multimap) {
                possiblePlayers = this.onlinePlayersFromTexturesMap.get((Object)searchUUID);
            }
            boolean bl = playersExist = possiblePlayers.size() > 0;
            if (playersExist) {
                for (UUID uuid : possiblePlayers) {
                    CachedPlayerSkin maybeCachedPacket;
                    Map<UUID, CachedPlayerSkin> map2 = this.onlinePlayersCache;
                    synchronized (map2) {
                        maybeCachedPacket = this.onlinePlayersCache.get(uuid);
                    }
                    if (maybeCachedPacket == null) continue;
                    byte[] rewritten = SkinPackets.rewriteUUID(searchUUID, maybeCachedPacket.data);
                    Map<UUID, CachedPlayerSkin> map3 = this.onlinePlayersCache;
                    synchronized (map3) {
                        this.onlinePlayersCache.put(searchUUID, maybeCachedPacket);
                    }
                    sender.sendData(CHANNEL, rewritten);
                    return;
                }
            }
            if (eaglerHandler.skinTextureDownloadRateLimiter.rateLimit(config.getSkinRateLimitPlayer()) && !this.isLimitedAsAntagonist(sender.getUniqueId())) {
                this.processResolveURLTextureForForeign(sender, searchUUID, searchUUID, skinURL, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResolveURLTextureForOnline(final UserConnection initiator, final UUID onlineCacheUUID, final UUID skinUUID, String urlStr, final int modelId) {
        Map<UUID, PendingTextureDownload> map = this.pendingTextures;
        synchronized (map) {
            PendingTextureDownload alreadyPending = this.pendingTextures.get(skinUUID);
            if (alreadyPending != null) {
                if (alreadyPending.antagonists.add(initiator.getUniqueId())) {
                    alreadyPending.callbacks.add(new Consumer<byte[]>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(byte[] t) {
                            CachedPlayerSkin skin;
                            Map map = SkinService.this.onlinePlayersCache;
                            synchronized (map) {
                                skin = (CachedPlayerSkin)SkinService.this.onlinePlayersCache.get(onlineCacheUUID);
                            }
                            if (skin != null) {
                                initiator.sendData(SkinService.CHANNEL, skin.data);
                            }
                        }
                    });
                }
            } else {
                PendingTextureDownload newTask = new PendingTextureDownload(skinUUID, urlStr, initiator.getUniqueId(), new Consumer<byte[]>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(byte[] t) {
                        CachedPlayerSkin skin;
                        if (t != null) {
                            SkinService.this.registerTextureToPlayerAssociation(skinUUID, onlineCacheUUID);
                            skin = new CachedPlayerSkin(SkinPackets.makeCustomResponse(onlineCacheUUID, modelId, t), skinUUID, modelId);
                        } else {
                            skin = new CachedPlayerSkin(SkinPackets.makePresetResponse(onlineCacheUUID), null, -1);
                        }
                        Map map = SkinService.this.onlinePlayersCache;
                        synchronized (map) {
                            SkinService.this.onlinePlayersCache.put(onlineCacheUUID, skin);
                        }
                        initiator.sendData(SkinService.CHANNEL, skin.data);
                    }
                }, this.antagonistLogger);
                try {
                    AsyncSkinProvider.downloadSkin(skinUUID, urlStr, this.cacheProvider, newTask);
                }
                catch (AsyncSkinProvider.CancelException ex) {
                    return;
                }
                this.pendingTextures.put(skinUUID, newTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResolveURLTextureForForeign(final UserConnection initiator, final UUID foreignCacheUUID, UUID skinUUID, String urlStr, final int modelId) {
        Map<UUID, PendingTextureDownload> map = this.pendingTextures;
        synchronized (map) {
            PendingTextureDownload alreadyPending = this.pendingTextures.get(skinUUID);
            if (alreadyPending != null) {
                if (alreadyPending.antagonists.add(initiator.getUniqueId())) {
                    alreadyPending.callbacks.add(new Consumer<byte[]>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(byte[] t) {
                            CachedForeignSkin skin;
                            Map map = SkinService.this.foreignSkinCache;
                            synchronized (map) {
                                skin = (CachedForeignSkin)SkinService.this.foreignSkinCache.get(foreignCacheUUID);
                            }
                            if (skin != null) {
                                initiator.sendData(SkinService.CHANNEL, skin.data);
                            }
                        }
                    });
                }
            } else {
                PendingTextureDownload newTask = new PendingTextureDownload(skinUUID, urlStr, initiator.getUniqueId(), new Consumer<byte[]>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(byte[] t) {
                        CachedForeignSkin skin = t != null ? new CachedForeignSkin(foreignCacheUUID, SkinPackets.makeCustomResponse(foreignCacheUUID, modelId, t), modelId) : new CachedForeignSkin(foreignCacheUUID, SkinPackets.makePresetResponse(foreignCacheUUID), -1);
                        Map map = SkinService.this.foreignSkinCache;
                        synchronized (map) {
                            SkinService.this.foreignSkinCache.put(foreignCacheUUID, skin);
                        }
                        initiator.sendData(SkinService.CHANNEL, skin.data);
                    }
                }, this.antagonistLogger);
                try {
                    AsyncSkinProvider.downloadSkin(skinUUID, urlStr, this.cacheProvider, newTask);
                }
                catch (AsyncSkinProvider.CancelException ex) {
                    return;
                }
                this.pendingTextures.put(skinUUID, newTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResolveProfileTextureByUUIDForOnline(final UserConnection initiator, final UUID playerUUID) {
        Map<UUID, PendingProfileUUIDLookup> map = this.pendingUUIDs;
        synchronized (map) {
            PendingProfileUUIDLookup alreadyPending = this.pendingUUIDs.get(playerUUID);
            if (alreadyPending != null) {
                if (alreadyPending.antagonists.add(initiator.getUniqueId())) {
                    alreadyPending.callbacks.add(new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(AsyncSkinProvider.CacheFetchedProfile t) {
                            if (t == null || t.texture == null) {
                                CachedPlayerSkin skin;
                                Map map = SkinService.this.onlinePlayersCache;
                                synchronized (map) {
                                    skin = (CachedPlayerSkin)SkinService.this.onlinePlayersCache.get(playerUUID);
                                }
                                if (skin != null) {
                                    initiator.sendData(SkinService.CHANNEL, skin.data);
                                }
                            } else {
                                SkinService.this.processResolveURLTextureForOnline(initiator, playerUUID, t.textureUUID, t.texture, SkinPackets.getModelId(t.model));
                            }
                        }
                    });
                }
            } else {
                PendingProfileUUIDLookup newTask = new PendingProfileUUIDLookup(playerUUID, initiator.getUniqueId(), new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(AsyncSkinProvider.CacheFetchedProfile t) {
                        if (t == null || t.texture == null) {
                            CachedPlayerSkin skin = t == null ? new CachedPlayerSkin(SkinPackets.makePresetResponse(playerUUID), null, -1) : new CachedPlayerSkin(SkinPackets.makePresetResponse(playerUUID, SkinPackets.getModelId(t.model) == 1 ? 1 : 0), null, -1);
                            Map map = SkinService.this.onlinePlayersCache;
                            synchronized (map) {
                                SkinService.this.onlinePlayersCache.put(playerUUID, skin);
                            }
                            initiator.sendData(SkinService.CHANNEL, skin.data);
                        } else {
                            SkinService.this.processResolveURLTextureForOnline(initiator, playerUUID, t.textureUUID, t.texture, SkinPackets.getModelId(t.model));
                        }
                    }
                }, this.antagonistLogger);
                try {
                    AsyncSkinProvider.lookupProfileByUUID(playerUUID, this.cacheProvider, newTask);
                }
                catch (AsyncSkinProvider.CancelException ex) {
                    return;
                }
                this.pendingUUIDs.put(playerUUID, newTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResolveProfileTextureByNameForOnline(final UserConnection initiator, String playerName, final UUID mapUUID) {
        Map<String, PendingProfileNameLookup> map = this.pendingNameLookups;
        synchronized (map) {
            PendingProfileNameLookup alreadyPending = this.pendingNameLookups.get(playerName);
            if (alreadyPending != null) {
                if (alreadyPending.antagonists.add(initiator.getUniqueId())) {
                    alreadyPending.callbacks.add(new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(AsyncSkinProvider.CacheFetchedProfile t) {
                            if (t == null || t.texture == null) {
                                CachedPlayerSkin skin;
                                Map map = SkinService.this.onlinePlayersCache;
                                synchronized (map) {
                                    skin = (CachedPlayerSkin)SkinService.this.onlinePlayersCache.get(t.uuid);
                                }
                                if (skin != null) {
                                    initiator.sendData(SkinService.CHANNEL, skin.data);
                                }
                            } else {
                                SkinService.this.processResolveURLTextureForOnline(initiator, mapUUID, t.textureUUID, t.texture, SkinPackets.getModelId(t.model));
                            }
                        }
                    });
                }
            } else {
                PendingProfileNameLookup newTask = new PendingProfileNameLookup(playerName, initiator.getUniqueId(), new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(AsyncSkinProvider.CacheFetchedProfile t) {
                        if (t == null || t.texture == null) {
                            CachedPlayerSkin skin = t == null ? new CachedPlayerSkin(SkinPackets.makePresetResponse(mapUUID), null, -1) : new CachedPlayerSkin(SkinPackets.makePresetResponse(mapUUID, SkinPackets.getModelId(t.model) == 1 ? 1 : 0), null, -1);
                            Map map = SkinService.this.onlinePlayersCache;
                            synchronized (map) {
                                SkinService.this.onlinePlayersCache.put(mapUUID, skin);
                            }
                            initiator.sendData(SkinService.CHANNEL, skin.data);
                        } else {
                            SkinService.this.processResolveURLTextureForOnline(initiator, mapUUID, t.textureUUID, t.texture, SkinPackets.getModelId(t.model));
                        }
                    }
                }, this.antagonistLogger);
                try {
                    AsyncSkinProvider.lookupProfileByUsername(playerName, this.cacheProvider, newTask);
                }
                catch (AsyncSkinProvider.CancelException ex) {
                    return;
                }
                this.pendingNameLookups.put(playerName, newTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResolveProfileTextureByUUIDForeign(final UserConnection initiator, final UUID playerUUID) {
        Map<UUID, PendingProfileUUIDLookup> map = this.pendingUUIDs;
        synchronized (map) {
            PendingProfileUUIDLookup alreadyPending = this.pendingUUIDs.get(playerUUID);
            if (alreadyPending != null) {
                if (alreadyPending.antagonists.add(initiator.getUniqueId())) {
                    alreadyPending.callbacks.add(new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(AsyncSkinProvider.CacheFetchedProfile t) {
                            if (t == null || t.texture == null) {
                                CachedForeignSkin skin;
                                Map map = SkinService.this.foreignSkinCache;
                                synchronized (map) {
                                    skin = (CachedForeignSkin)SkinService.this.foreignSkinCache.get(playerUUID);
                                }
                                if (skin != null) {
                                    initiator.sendData(SkinService.CHANNEL, skin.data);
                                }
                            } else {
                                SkinService.this.processResolveURLTextureForForeign(initiator, playerUUID, t.textureUUID, t.texture, SkinPackets.getModelId(t.model));
                            }
                        }
                    });
                }
            } else {
                PendingProfileUUIDLookup newTask = new PendingProfileUUIDLookup(playerUUID, initiator.getUniqueId(), new Consumer<AsyncSkinProvider.CacheFetchedProfile>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void accept(AsyncSkinProvider.CacheFetchedProfile t) {
                        if (t == null || t.texture == null) {
                            CachedForeignSkin skin = t == null ? new CachedForeignSkin(playerUUID, SkinPackets.makePresetResponse(playerUUID), -1) : new CachedForeignSkin(playerUUID, SkinPackets.makePresetResponse(playerUUID, SkinPackets.getModelId(t.model) == 1 ? 1 : 0), -1);
                            Map map = SkinService.this.foreignSkinCache;
                            synchronized (map) {
                                SkinService.this.foreignSkinCache.put(playerUUID, skin);
                            }
                            initiator.sendData(SkinService.CHANNEL, skin.data);
                        } else {
                            SkinService.this.processResolveURLTextureForForeign(initiator, playerUUID, t.textureUUID, t.texture, SkinPackets.getModelId(t.model));
                        }
                    }
                }, this.antagonistLogger);
                try {
                    AsyncSkinProvider.lookupProfileByUUID(playerUUID, this.cacheProvider, newTask);
                }
                catch (AsyncSkinProvider.CancelException ex) {
                    return;
                }
                this.pendingUUIDs.put(playerUUID, newTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEaglercraftPlayer(UUID clientUUID, byte[] generatedPacket, int modelId) throws IOException {
        Map<UUID, Object> map = this.foreignSkinCache;
        synchronized (map) {
            this.foreignSkinCache.remove(clientUUID);
        }
        map = this.onlinePlayersCache;
        synchronized (map) {
            this.onlinePlayersCache.put(clientUUID, new CachedPlayerSkin(generatedPacket, null, modelId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterPlayer(UUID clientUUID) {
        CachedPlayerSkin data;
        Map<UUID, Object> map = this.onlinePlayersCache;
        synchronized (map) {
            data = this.onlinePlayersCache.remove(clientUUID);
        }
        if (data != null) {
            map = this.foreignSkinCache;
            synchronized (map) {
                this.foreignSkinCache.put(clientUUID, new CachedForeignSkin(clientUUID, data.data, data.modelId));
            }
            if (data.textureUUID != null) {
                map = this.foreignSkinCache;
                synchronized (map) {
                    this.foreignSkinCache.put(data.textureUUID, new CachedForeignSkin(data.textureUUID, data.data, data.modelId));
                }
            }
            this.deletePlayerTextureAssociation(clientUUID, data.textureUUID);
        } else {
            this.deletePlayerTextureAssociation(clientUUID, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePlayerTextureAssociation(UUID clientUUID, UUID textureUUID) {
        UUID removedUUID;
        if (textureUUID != null) {
            Map<UUID, UUID> map = this.onlinePlayersToTexturesMap;
            synchronized (map) {
                this.onlinePlayersToTexturesMap.remove(clientUUID);
            }
            map = this.onlinePlayersFromTexturesMap;
            synchronized (map) {
                this.onlinePlayersFromTexturesMap.remove((Object)textureUUID, (Object)clientUUID);
            }
        }
        Map<UUID, UUID> map = this.onlinePlayersToTexturesMap;
        synchronized (map) {
            removedUUID = this.onlinePlayersToTexturesMap.remove(clientUUID);
        }
        if (removedUUID != null) {
            map = this.onlinePlayersFromTexturesMap;
            synchronized (map) {
                this.onlinePlayersFromTexturesMap.remove((Object)removedUUID, (Object)clientUUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTextureToPlayerAssociation(UUID textureUUID, UUID playerUUID) {
        CachedForeignSkin foreign;
        Object object = this.onlinePlayersFromTexturesMap;
        synchronized (object) {
            this.onlinePlayersFromTexturesMap.put((Object)textureUUID, (Object)playerUUID);
        }
        object = this.onlinePlayersToTexturesMap;
        synchronized (object) {
            this.onlinePlayersToTexturesMap.put(playerUUID, textureUUID);
        }
        Map<UUID, Object> map = this.foreignSkinCache;
        synchronized (map) {
            foreign = this.foreignSkinCache.remove(textureUUID);
        }
        if (foreign != null) {
            map = this.onlinePlayersCache;
            synchronized (map) {
                this.onlinePlayersCache.put(playerUUID, new CachedPlayerSkin(foreign.data, textureUUID, foreign.modelKnown));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Consumer<byte[]> etr;
        Iterator<Object> itr;
        long millis = System.currentTimeMillis();
        Map<Object, Object> map = this.foreignSkinCache;
        synchronized (map) {
            itr = this.foreignSkinCache.values().iterator();
            while (itr.hasNext()) {
                if (millis - itr.next().lastHit <= 900000L) continue;
                itr.remove();
            }
        }
        map = this.pendingTextures;
        synchronized (map) {
            itr = this.pendingTextures.values().iterator();
            while (itr.hasNext()) {
                etr = (PendingTextureDownload)itr.next();
                if (millis - etr.initializedTime <= (etr.finalized ? 5000L : 10000L)) continue;
                itr.remove();
                try {
                    etr.antagonistsCallback.accept(etr.antagonists);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        map = this.pendingUUIDs;
        synchronized (map) {
            itr = this.pendingUUIDs.values().iterator();
            while (itr.hasNext()) {
                etr = (PendingProfileUUIDLookup)itr.next();
                if (millis - ((PendingProfileUUIDLookup)etr).initializedTime <= (((PendingProfileUUIDLookup)etr).finalized ? 5000L : 10000L)) continue;
                itr.remove();
                try {
                    ((PendingProfileUUIDLookup)etr).antagonistsCallback.accept(((PendingProfileUUIDLookup)etr).antagonists);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        map = this.pendingNameLookups;
        synchronized (map) {
            itr = this.pendingNameLookups.values().iterator();
            while (itr.hasNext()) {
                etr = (PendingProfileNameLookup)itr.next();
                if (millis - ((PendingProfileNameLookup)etr).initializedTime <= (((PendingProfileNameLookup)etr).finalized ? 5000L : 10000L)) continue;
                itr.remove();
                try {
                    ((PendingProfileNameLookup)etr).antagonistsCallback.accept(((PendingProfileNameLookup)etr).antagonists);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        int cooldownPeriod = 60000 / EaglerXBungee.getEagler().getConfig().getAntagonistsRateLimit();
        int elapsedCooldown = (int)(millis - this.antagonistCooldown);
        if ((elapsedCooldown /= cooldownPeriod) > 0) {
            this.antagonistCooldown += (long)(elapsedCooldown * cooldownPeriod);
            TObjectIntMap<UUID> tObjectIntMap = this.antagonists;
            synchronized (tObjectIntMap) {
                Iterator itr2 = this.antagonists.keySet().iterator();
                while (itr2.hasNext()) {
                    UUID key = (UUID)itr2.next();
                    int i = this.antagonists.get((Object)key) - elapsedCooldown;
                    if (i <= 0) {
                        itr2.remove();
                        continue;
                    }
                    this.antagonists.put((Object)key, i);
                }
            }
        }
        this.cacheProvider.flush();
    }

    @Override
    public void shutdown() {
        this.resetMaps();
        if (this.cacheProvider != null) {
            this.cacheProvider.destroy();
        }
        this.cacheProvider = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLimitedAsAntagonist(UUID uuid) {
        int limit = EaglerXBungee.getEagler().getConfig().getAntagonistsRateLimit();
        limit += limit >> 1;
        TObjectIntMap<UUID> tObjectIntMap = this.antagonists;
        synchronized (tObjectIntMap) {
            int i = this.antagonists.get((Object)uuid);
            return i != this.antagonists.getNoEntryValue() && i > limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetMaps() {
        Map<Object, Object> map = this.onlinePlayersCache;
        synchronized (map) {
            this.onlinePlayersCache.clear();
        }
        map = this.onlinePlayersFromTexturesMap;
        synchronized (map) {
            this.onlinePlayersFromTexturesMap.clear();
        }
        map = this.onlinePlayersToTexturesMap;
        synchronized (map) {
            this.onlinePlayersToTexturesMap.clear();
        }
        map = this.foreignSkinCache;
        synchronized (map) {
            this.foreignSkinCache.clear();
        }
        map = this.pendingTextures;
        synchronized (map) {
            this.pendingTextures.clear();
        }
        map = this.pendingUUIDs;
        synchronized (map) {
            this.pendingUUIDs.clear();
        }
        map = this.pendingNameLookups;
        synchronized (map) {
            this.pendingNameLookups.clear();
        }
        map = this.antagonists;
        synchronized (map) {
            this.antagonists.clear();
        }
    }

    public static String sanitizeTextureURL(String url) {
        try {
            String path;
            StringBuilder builder;
            URI uri;
            block22: {
                uri = URI.create(url);
                builder = new StringBuilder();
                String scheme = uri.getScheme();
                if (scheme == null) {
                }
                String host = uri.getHost();
                if (host == null) {
                }
                scheme = scheme.toLowerCase();
                builder.append(scheme).append("://");
                builder.append(host);
                int port = uri.getPort();
                if (port == -1) break block22;
                switch (scheme) {
                    case "http": {
                        if (port != 80) break;
                        port = -1;
                        break;
                    }
                    case "https": {
                        if (port != 443) break;
                        port = -1;
                        break;
                    }
                    default: 
                }
                if (port != -1) {
                    builder.append(":").append(port);
                }
            }
            if ((path = uri.getRawPath()) != null) {
                int len;
                if (path.contains("//")) {
                    path = String.join((CharSequence)"/", path.split("[\\/]+"));
                }
                if ((len = path.length()) > 1 && path.charAt(len - 1) == '/') {
                    path = path.substring(0, len - 1);
                }
                builder.append(path);
            }
            return builder.toString();
        }
        finally {
            return null;
        }
    }

    public static String getMojangUUID(UUID uuid) {
        char[] ret = new char[32];
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        int i = 0;
        while (i < 16) {
            int j = 15 - i << 2;
            ret[i] = HEX[(int)(msb >> j & 0xFL)];
            ret[i + 16] = HEX[(int)(lsb >> j & 0xFL)];
            ++i;
        }
        return new String(ret);
    }

    public static UUID parseMojangUUID(String uuid) {
        long msb = 0L;
        long lsb = 0L;
        int i = 0;
        while (i < 16) {
            int j = 15 - i << 2;
            msb |= (long)hexString.indexOf(uuid.charAt(i)) << j;
            lsb |= (long)hexString.indexOf(uuid.charAt(i + 16)) << j;
            ++i;
        }
        return new UUID(msb, lsb);
    }

    public static boolean isAlex(UUID skinUUID) {
        return (skinUUID.hashCode() & 1) != 0;
    }

    protected static class CachedForeignSkin {
        protected final UUID uuid;
        protected final byte[] data;
        protected final int modelKnown;
        protected long lastHit;

        protected CachedForeignSkin(UUID uuid, byte[] data, int modelKnown) {
            this.uuid = uuid;
            this.data = data;
            this.modelKnown = modelKnown;
            this.lastHit = System.currentTimeMillis();
        }
    }

    protected static class CachedPlayerSkin {
        protected final byte[] data;
        protected final UUID textureUUID;
        protected final int modelId;

        protected CachedPlayerSkin(byte[] data, UUID textureUUID, int modelId) {
            this.data = data;
            this.textureUUID = textureUUID;
            this.modelId = modelId;
        }
    }

    protected class PendingProfileNameLookup
    implements Consumer<AsyncSkinProvider.CacheFetchedProfile> {
        protected final String profileName;
        protected final Set<UUID> antagonists;
        protected final List<Consumer<AsyncSkinProvider.CacheFetchedProfile>> callbacks;
        protected final Consumer<Set<UUID>> antagonistsCallback;
        protected final long initializedTime;
        protected boolean finalized;

        protected PendingProfileNameLookup(String profileName, UUID caller, Consumer<AsyncSkinProvider.CacheFetchedProfile> callback, Consumer<Set<UUID>> antagonistsCallback) {
            this.profileName = profileName;
            this.antagonists = new LinkedHashSet<UUID>();
            this.antagonists.add(caller);
            this.callbacks = new LinkedList<Consumer<AsyncSkinProvider.CacheFetchedProfile>>();
            this.callbacks.add(callback);
            this.antagonistsCallback = antagonistsCallback;
            this.initializedTime = System.currentTimeMillis();
            this.finalized = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(AsyncSkinProvider.CacheFetchedProfile t) {
            int i = 0;
            int l = this.callbacks.size();
            while (i < l) {
                try {
                    this.callbacks.get(i).accept(t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++i;
            }
            if (t != null) {
                Map map = SkinService.this.pendingNameLookups;
                synchronized (map) {
                    this.finalized = true;
                    SkinService.this.pendingNameLookups.remove(this.profileName);
                }
            }
        }
    }

    protected class PendingProfileUUIDLookup
    implements Consumer<AsyncSkinProvider.CacheFetchedProfile> {
        protected final UUID profileUUID;
        protected final Set<UUID> antagonists;
        protected final List<Consumer<AsyncSkinProvider.CacheFetchedProfile>> callbacks;
        protected final Consumer<Set<UUID>> antagonistsCallback;
        protected final long initializedTime;
        protected boolean finalized;

        protected PendingProfileUUIDLookup(UUID profileUUID, UUID caller, Consumer<AsyncSkinProvider.CacheFetchedProfile> callback, Consumer<Set<UUID>> antagonistsCallback) {
            this.profileUUID = profileUUID;
            this.antagonists = new LinkedHashSet<UUID>();
            this.antagonists.add(caller);
            this.callbacks = new LinkedList<Consumer<AsyncSkinProvider.CacheFetchedProfile>>();
            this.callbacks.add(callback);
            this.antagonistsCallback = antagonistsCallback;
            this.initializedTime = System.currentTimeMillis();
            this.finalized = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(AsyncSkinProvider.CacheFetchedProfile t) {
            int i = 0;
            int l = this.callbacks.size();
            while (i < l) {
                try {
                    this.callbacks.get(i).accept(t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++i;
            }
            if (t != null) {
                Map map = SkinService.this.pendingUUIDs;
                synchronized (map) {
                    this.finalized = true;
                    SkinService.this.pendingUUIDs.remove(this.profileUUID);
                }
            }
        }
    }

    protected class PendingTextureDownload
    implements Consumer<byte[]> {
        protected final UUID textureUUID;
        protected final String textureURL;
        protected final Set<UUID> antagonists;
        protected final List<Consumer<byte[]>> callbacks;
        protected final Consumer<Set<UUID>> antagonistsCallback;
        protected final long initializedTime;
        protected boolean finalized;

        protected PendingTextureDownload(UUID textureUUID, String textureURL, UUID caller, Consumer<byte[]> callback, Consumer<Set<UUID>> antagonistsCallback) {
            this.textureUUID = textureUUID;
            this.textureURL = textureURL;
            this.antagonists = new LinkedHashSet<UUID>();
            this.antagonists.add(caller);
            this.callbacks = new LinkedList<Consumer<byte[]>>();
            this.callbacks.add(callback);
            this.antagonistsCallback = antagonistsCallback;
            this.initializedTime = System.currentTimeMillis();
            this.finalized = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(byte[] t) {
            int i = 0;
            int l = this.callbacks.size();
            while (i < l) {
                try {
                    this.callbacks.get(i).accept(t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++i;
            }
            if (t != null) {
                Map map = SkinService.this.pendingTextures;
                synchronized (map) {
                    this.finalized = true;
                    SkinService.this.pendingTextures.remove(this.textureUUID);
                }
            }
        }
    }
}

