/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ICacheProvider;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinService;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.sqlite.EaglerDrivers;

public class JDBCCacheProvider
implements ICacheProvider {
    protected final Connection connection;
    protected final String uri;
    protected final PreparedStatement discardExpiredObjects;
    protected final PreparedStatement discardExpiredProfiles;
    protected final PreparedStatement getTotalObjects;
    protected final PreparedStatement getTotalProfiles;
    protected final PreparedStatement deleteSomeOldestObjects;
    protected final PreparedStatement deleteSomeOldestProfiles;
    protected final PreparedStatement querySkinByUUID;
    protected final PreparedStatement queryProfileByUUID;
    protected final PreparedStatement queryProfileByUsername;
    protected final PreparedStatement cacheNewSkin;
    protected final PreparedStatement cacheNewProfile;
    protected final PreparedStatement cacheHasSkin;
    protected final PreparedStatement cacheHasProfile;
    protected final PreparedStatement cacheUpdateSkin;
    protected final PreparedStatement cacheUpdateProfile;
    protected long lastFlush;
    protected int keepObjectsDays;
    protected int keepProfilesDays;
    protected int maxObjects;
    protected int maxProfiles;

    public static JDBCCacheProvider initialize(String uri, String driverClass, String driverPath, int keepObjectsDays, int keepProfilesDays, int maxObjects, int maxProfiles) throws ICacheProvider.CacheException {
        Connection conn;
        try {
            conn = EaglerDrivers.connectToDatabase(uri, driverClass, driverPath, new Properties());
            if (conn == null) {
                throw new IllegalStateException("Connection is null");
            }
        }
        catch (Throwable t) {
            throw new ICacheProvider.CacheException("Could not initialize '" + uri + "'!", t);
        }
        EaglerXBungee.logger().info("Connected to database: " + uri);
        try {
            t = null;
            Object var9_13 = null;
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE IF NOT EXISTS \"eaglercraft_skins_objects\" (\"TextureUUID\" TEXT(32) NOT NULL,\"TextureURL\" VARCHAR(256) NOT NULL,\"TextureTime\" DATETIME NOT NULL,\"TextureData\" BLOB,\"TextureLength\" INT(24) NOT NULL,PRIMARY KEY(\"TextureUUID\"))");
                stmt.execute("CREATE TABLE IF NOT EXISTS \"eaglercraft_skins_profiles\" (\"ProfileUUID\" TEXT(32) NOT NULL,\"ProfileName\" TEXT(16) NOT NULL,\"ProfileTime\" DATETIME NOT NULL,\"ProfileTexture\" VARCHAR(256),\"ProfileModel\" VARCHAR(16) NOT NULL,PRIMARY KEY(\"ProfileUUID\"))");
                stmt.execute("CREATE INDEX IF NOT EXISTS \"profile_name_index\" ON \"eaglercraft_skins_profiles\" (\"ProfileName\")");
            }
            catch (Throwable throwable) {
                if (t == null) {
                    t = throwable;
                } else if (t != throwable) {
                    t.addSuppressed(throwable);
                }
                throw t;
            }
            JDBCCacheProvider cacheProvider = new JDBCCacheProvider(conn, uri, keepObjectsDays, keepProfilesDays, maxObjects, maxProfiles);
            cacheProvider.flush();
            return cacheProvider;
        }
        catch (ICacheProvider.CacheException ex) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw ex;
        }
        catch (Throwable t) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new ICacheProvider.CacheException("Could not initialize '" + uri + "'!", t);
        }
    }

    protected JDBCCacheProvider(Connection conn, String uri, int keepObjectsDays, int keepProfilesDays, int maxObjects, int maxProfiles) throws SQLException {
        this.connection = conn;
        this.uri = uri;
        this.lastFlush = 0L;
        this.keepObjectsDays = keepObjectsDays;
        this.keepProfilesDays = keepProfilesDays;
        this.maxObjects = maxObjects;
        this.maxProfiles = maxProfiles;
        this.discardExpiredObjects = this.connection.prepareStatement("DELETE FROM eaglercraft_skins_objects WHERE textureTime < ?");
        this.discardExpiredProfiles = this.connection.prepareStatement("DELETE FROM eaglercraft_skins_profiles WHERE profileTime < ?");
        this.getTotalObjects = this.connection.prepareStatement("SELECT COUNT(*) AS total_objects FROM eaglercraft_skins_objects");
        this.getTotalProfiles = this.connection.prepareStatement("SELECT COUNT(*) AS total_profiles FROM eaglercraft_skins_profiles");
        this.deleteSomeOldestObjects = this.connection.prepareStatement("DELETE FROM eaglercraft_skins_objects WHERE TextureUUID IN (SELECT TextureUUID FROM eaglercraft_skins_objects ORDER BY TextureTime ASC LIMIT ?)");
        this.deleteSomeOldestProfiles = this.connection.prepareStatement("DELETE FROM eaglercraft_skins_profiles WHERE ProfileUUID IN (SELECT ProfileUUID FROM eaglercraft_skins_profiles ORDER BY ProfileTime ASC LIMIT ?)");
        this.querySkinByUUID = this.connection.prepareStatement("SELECT TextureURL,TextureData,TextureLength FROM eaglercraft_skins_objects WHERE TextureUUID = ? LIMIT 1");
        this.queryProfileByUUID = this.connection.prepareStatement("SELECT ProfileName,ProfileTexture,ProfileModel FROM eaglercraft_skins_profiles WHERE ProfileUUID = ? LIMIT 1");
        this.queryProfileByUsername = this.connection.prepareStatement("SELECT ProfileUUID,ProfileTexture,ProfileModel FROM eaglercraft_skins_profiles WHERE ProfileName = ? LIMIT 1");
        this.cacheNewSkin = this.connection.prepareStatement("INSERT INTO eaglercraft_skins_objects (TextureUUID, TextureURL, TextureTime, TextureData, TextureLength) VALUES(?, ?, ?, ?, ?)");
        this.cacheNewProfile = this.connection.prepareStatement("INSERT INTO eaglercraft_skins_profiles (ProfileUUID, ProfileName, ProfileTime, ProfileTexture, ProfileModel) VALUES(?, ?, ?, ?, ?)");
        this.cacheHasSkin = this.connection.prepareStatement("SELECT COUNT(TextureUUID) AS has_object FROM eaglercraft_skins_objects WHERE TextureUUID = ? LIMIT 1");
        this.cacheHasProfile = this.connection.prepareStatement("SELECT COUNT(ProfileUUID) AS has_profile FROM eaglercraft_skins_profiles WHERE ProfileUUID = ? LIMIT 1");
        this.cacheUpdateSkin = this.connection.prepareStatement("UPDATE eaglercraft_skins_objects SET TextureURL = ?, TextureTime = ?, TextureData = ?, TextureLength = ? WHERE TextureUUID = ?");
        this.cacheUpdateProfile = this.connection.prepareStatement("UPDATE eaglercraft_skins_profiles SET ProfileName = ?, ProfileTime = ?, ProfileTexture = ?, ProfileModel = ? WHERE ProfileUUID = ?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ICacheProvider.CacheLoadedSkin loadSkinByUUID(UUID uuid) throws ICacheProvider.CacheException {
        int queriedLength;
        byte[] queriedTexture;
        String queriedUrls;
        String uuidString = SkinService.getMojangUUID(uuid);
        try {
            PreparedStatement preparedStatement = this.querySkinByUUID;
            synchronized (preparedStatement) {
                this.querySkinByUUID.setString(1, uuidString);
                Throwable throwable = null;
                Object var8_8 = null;
                try (ResultSet resultSet = this.querySkinByUUID.executeQuery();){
                    if (!resultSet.next()) return null;
                    queriedUrls = resultSet.getString(1);
                    queriedTexture = resultSet.getBytes(2);
                    queriedLength = resultSet.getInt(3);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
        }
        catch (SQLException ex) {
            throw new ICacheProvider.CacheException("SQL query failure while loading cached skin", ex);
        }
        if (queriedLength == 0) {
            return new ICacheProvider.CacheLoadedSkin(uuid, queriedUrls, new byte[0]);
        }
        byte[] decompressed = new byte[queriedLength];
        try {
            GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(queriedTexture));
            int i = 0;
            int j = 0;
            while (j < queriedLength) {
                i = is.read(decompressed, j, queriedLength - j);
                if (i == -1) {
                    return new ICacheProvider.CacheLoadedSkin(uuid, queriedUrls, decompressed);
                }
                j += i;
            }
            return new ICacheProvider.CacheLoadedSkin(uuid, queriedUrls, decompressed);
        }
        catch (IOException ex) {
            throw new ICacheProvider.CacheException("SQL query failure while loading cached skin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheSkinByUUID(UUID uuid, String url, byte[] textureBlob) throws ICacheProvider.CacheException {
        byte[] textureBlobCompressed;
        int len;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        try {
            GZIPOutputStream deflateOut = new GZIPOutputStream(bao);
            deflateOut.write(textureBlob);
            deflateOut.close();
        }
        catch (IOException ex) {
            throw new ICacheProvider.CacheException("Skin compression error", ex);
        }
        if (textureBlob == null || textureBlob.length == 0) {
            len = 0;
            textureBlobCompressed = null;
        } else {
            len = textureBlob.length;
            textureBlobCompressed = bao.toByteArray();
        }
        try {
            String uuidString = SkinService.getMojangUUID(uuid);
            PreparedStatement preparedStatement = this.cacheNewSkin;
            synchronized (preparedStatement) {
                boolean has;
                this.cacheHasSkin.setString(1, uuidString);
                Throwable throwable = null;
                Object var11_14 = null;
                try (ResultSet resultSet = this.cacheHasSkin.executeQuery();){
                    has = resultSet.next() ? resultSet.getInt(1) > 0 : false;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (has) {
                    this.cacheUpdateSkin.setString(1, url);
                    this.cacheUpdateSkin.setDate(2, new Date(System.currentTimeMillis()));
                    this.cacheUpdateSkin.setBytes(3, textureBlobCompressed);
                    this.cacheUpdateSkin.setInt(4, len);
                    this.cacheUpdateSkin.setString(5, uuidString);
                    this.cacheUpdateSkin.executeUpdate();
                } else {
                    this.cacheNewSkin.setString(1, uuidString);
                    this.cacheNewSkin.setString(2, url);
                    this.cacheNewSkin.setDate(3, new Date(System.currentTimeMillis()));
                    this.cacheNewSkin.setBytes(4, textureBlobCompressed);
                    this.cacheNewSkin.setInt(5, len);
                    this.cacheNewSkin.executeUpdate();
                }
            }
        }
        catch (SQLException ex) {
            throw new ICacheProvider.CacheException("SQL query failure while caching new skin", ex);
        }
    }

    @Override
    public ICacheProvider.CacheLoadedProfile loadProfileByUUID(UUID uuid) throws ICacheProvider.CacheException {
        String uuidString = SkinService.getMojangUUID(uuid);
        PreparedStatement preparedStatement = this.queryProfileByUUID;
        synchronized (preparedStatement) {
            ResultSet resultSet;
            block17: {
                ICacheProvider.CacheLoadedProfile cacheLoadedProfile;
                block18: {
                    this.queryProfileByUUID.setString(1, uuidString);
                    Throwable throwable = null;
                    Object var5_7 = null;
                    resultSet = this.queryProfileByUUID.executeQuery();
                    try {
                        if (!resultSet.next()) break block17;
                        String profileName = resultSet.getString(1);
                        String profileTexture = resultSet.getString(2);
                        String profileModel = resultSet.getString(3);
                        cacheLoadedProfile = new ICacheProvider.CacheLoadedProfile(uuid, profileName, profileTexture, profileModel);
                        if (resultSet == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (SQLException ex) {
                            throw new ICacheProvider.CacheException("SQL query failure while loading profile by uuid", ex);
                        }
                    }
                    resultSet.close();
                }
                return cacheLoadedProfile;
            }
            if (resultSet != null) {
                resultSet.close();
            }
            return null;
        }
    }

    @Override
    public ICacheProvider.CacheLoadedProfile loadProfileByUsername(String username) throws ICacheProvider.CacheException {
        PreparedStatement preparedStatement = this.queryProfileByUsername;
        synchronized (preparedStatement) {
            ResultSet resultSet;
            block17: {
                ICacheProvider.CacheLoadedProfile cacheLoadedProfile;
                block18: {
                    this.queryProfileByUsername.setString(1, username);
                    Throwable throwable = null;
                    Object var4_6 = null;
                    resultSet = this.queryProfileByUsername.executeQuery();
                    try {
                        if (!resultSet.next()) break block17;
                        UUID profileUUID = SkinService.parseMojangUUID(resultSet.getString(1));
                        String profileTexture = resultSet.getString(2);
                        String profileModel = resultSet.getString(3);
                        cacheLoadedProfile = new ICacheProvider.CacheLoadedProfile(profileUUID, username, profileTexture, profileModel);
                        if (resultSet == null) break block18;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                if (resultSet != null) {
                                    resultSet.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (SQLException ex) {
                            throw new ICacheProvider.CacheException("SQL query failure while loading profile by username", ex);
                        }
                    }
                    resultSet.close();
                }
                return cacheLoadedProfile;
            }
            if (resultSet != null) {
                resultSet.close();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheProfileByUUID(UUID uuid, String username, String texture, String model) throws ICacheProvider.CacheException {
        try {
            String uuidString = SkinService.getMojangUUID(uuid);
            PreparedStatement preparedStatement = this.cacheNewProfile;
            synchronized (preparedStatement) {
                boolean has;
                this.cacheHasProfile.setString(1, uuidString);
                Throwable throwable = null;
                Object var9_10 = null;
                try (ResultSet resultSet = this.cacheHasProfile.executeQuery();){
                    has = resultSet.next() ? resultSet.getInt(1) > 0 : false;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (has) {
                    this.cacheUpdateProfile.setString(1, username);
                    this.cacheUpdateProfile.setDate(2, new Date(System.currentTimeMillis()));
                    this.cacheUpdateProfile.setString(3, texture);
                    this.cacheUpdateProfile.setString(4, model);
                    this.cacheUpdateProfile.setString(5, uuidString);
                    this.cacheUpdateProfile.executeUpdate();
                } else {
                    this.cacheNewProfile.setString(1, uuidString);
                    this.cacheNewProfile.setString(2, username);
                    this.cacheNewProfile.setDate(3, new Date(System.currentTimeMillis()));
                    this.cacheNewProfile.setString(4, texture);
                    this.cacheNewProfile.setString(5, model);
                    this.cacheNewProfile.executeUpdate();
                }
            }
        }
        catch (SQLException ex) {
            throw new ICacheProvider.CacheException("SQL query failure while caching new profile", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        block44: {
            long millis = System.currentTimeMillis();
            if (millis - this.lastFlush > 1200000L) {
                this.lastFlush = millis;
                try {
                    int totalProfiles;
                    int totalObjects;
                    ResultSet resultSet;
                    Object var9_13;
                    Object object;
                    Date expiryObjects = new Date(millis - (long)this.keepObjectsDays * 86400000L);
                    Date expiryProfiles = new Date(millis - (long)this.keepProfilesDays * 86400000L);
                    PreparedStatement preparedStatement = this.discardExpiredObjects;
                    synchronized (preparedStatement) {
                        this.discardExpiredObjects.setDate(1, expiryObjects);
                        this.discardExpiredObjects.execute();
                    }
                    preparedStatement = this.discardExpiredProfiles;
                    synchronized (preparedStatement) {
                        this.discardExpiredProfiles.setDate(1, expiryProfiles);
                        this.discardExpiredProfiles.execute();
                    }
                    PreparedStatement preparedStatement2 = this.getTotalObjects;
                    synchronized (preparedStatement2) {
                        block42: {
                            object = null;
                            var9_13 = null;
                            try {
                                resultSet = this.getTotalObjects.executeQuery();
                                try {
                                    if (resultSet.next()) {
                                        totalObjects = resultSet.getInt(1);
                                        break block42;
                                    }
                                    throw new SQLException("Empty ResultSet recieved when checking \"eaglercraft_skins_objects\" row count");
                                }
                                finally {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                if (object == null) {
                                    object = throwable;
                                } else if (object != throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                throw object;
                            }
                        }
                    }
                    preparedStatement2 = this.getTotalProfiles;
                    synchronized (preparedStatement2) {
                        block43: {
                            object = null;
                            var9_13 = null;
                            try {
                                resultSet = this.getTotalProfiles.executeQuery();
                                try {
                                    if (resultSet.next()) {
                                        totalProfiles = resultSet.getInt(1);
                                        break block43;
                                    }
                                    throw new SQLException("Empty ResultSet recieved when checking \"eaglercraft_skins_profiles\" row count");
                                }
                                finally {
                                    if (resultSet != null) {
                                        resultSet.close();
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                if (object == null) {
                                    object = throwable;
                                } else if (object != throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                throw object;
                            }
                        }
                    }
                    if (totalObjects > this.maxObjects) {
                        int deleteCount = totalObjects - this.maxObjects + (this.maxObjects >> 3);
                        EaglerXBungee.logger().warning("Skin object cache has passed " + this.maxObjects + " skins in size (" + totalObjects + "), deleting " + deleteCount + " skins from the cache to free space");
                        object = this.deleteSomeOldestObjects;
                        synchronized (object) {
                            this.deleteSomeOldestObjects.setInt(1, deleteCount);
                            this.deleteSomeOldestObjects.executeUpdate();
                        }
                    }
                    if (totalProfiles <= this.maxProfiles) break block44;
                    int deleteCount = totalProfiles - this.maxProfiles + (this.maxProfiles >> 3);
                    EaglerXBungee.logger().warning("Skin profile cache has passed " + this.maxProfiles + " profiles in size (" + totalProfiles + "), deleting " + deleteCount + " profiles from the cache to free space");
                    object = this.deleteSomeOldestProfiles;
                    synchronized (object) {
                        this.deleteSomeOldestProfiles.setInt(1, deleteCount);
                        this.deleteSomeOldestProfiles.executeUpdate();
                    }
                }
                catch (SQLException ex) {
                    throw new ICacheProvider.CacheException("SQL query failure while flushing cache!", ex);
                }
            }
        }
    }

    private void destroyStatement(Statement stmt) {
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void destroy() {
        this.destroyStatement(this.discardExpiredObjects);
        this.destroyStatement(this.discardExpiredProfiles);
        this.destroyStatement(this.getTotalObjects);
        this.destroyStatement(this.getTotalProfiles);
        this.destroyStatement(this.deleteSomeOldestObjects);
        this.destroyStatement(this.deleteSomeOldestProfiles);
        this.destroyStatement(this.querySkinByUUID);
        this.destroyStatement(this.queryProfileByUUID);
        this.destroyStatement(this.queryProfileByUsername);
        this.destroyStatement(this.cacheNewSkin);
        this.destroyStatement(this.cacheNewProfile);
        this.destroyStatement(this.cacheHasSkin);
        this.destroyStatement(this.cacheHasProfile);
        this.destroyStatement(this.cacheUpdateSkin);
        this.destroyStatement(this.cacheUpdateProfile);
        try {
            this.connection.close();
            EaglerXBungee.logger().info("Successfully disconnected from database '" + this.uri + "'");
        }
        catch (SQLException e) {
            EaglerXBungee.logger().log(Level.WARNING, "Exception disconnecting from database '" + this.uri + "'!", e);
        }
    }
}

