/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.bungeeprotocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Iterator;
import java.util.function.Supplier;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.EntityStatus;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;
import net.md_5.bungee.protocol.packet.Title;

public enum EaglerBungeeProtocol {
    HANDSHAKE{
        {
            this.TO_SERVER.registerPacket(Handshake.class, Handshake::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
        }
    }
    ,
    GAME{
        {
            this.TO_CLIENT.registerPacket(KeepAlive.class, KeepAlive::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
            this.TO_CLIENT.registerPacket(Login.class, Login::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1)});
            this.TO_CLIENT.registerPacket(Chat.class, Chat::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 2)});
            this.TO_CLIENT.registerPacket(Respawn.class, Respawn::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 7)});
            this.TO_CLIENT.registerPacket(PlayerListItem.class, PlayerListItem::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 56)});
            this.TO_CLIENT.registerPacket(TabCompleteResponse.class, TabCompleteResponse::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 58)});
            this.TO_CLIENT.registerPacket(ScoreboardObjective.class, ScoreboardObjective::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 59)});
            this.TO_CLIENT.registerPacket(ScoreboardScore.class, ScoreboardScore::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 60)});
            this.TO_CLIENT.registerPacket(ScoreboardDisplay.class, ScoreboardDisplay::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 61)});
            this.TO_CLIENT.registerPacket(Team.class, Team::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 62)});
            this.TO_CLIENT.registerPacket(PluginMessage.class, PluginMessage::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 63)});
            this.TO_CLIENT.registerPacket(Kick.class, Kick::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 64)});
            this.TO_CLIENT.registerPacket(Title.class, Title::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 69)});
            this.TO_CLIENT.registerPacket(PlayerListHeaderFooter.class, PlayerListHeaderFooter::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 71)});
            this.TO_CLIENT.registerPacket(EntityStatus.class, EntityStatus::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 26)});
            this.TO_SERVER.registerPacket(KeepAlive.class, KeepAlive::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
            this.TO_SERVER.registerPacket(Chat.class, Chat::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1)});
            this.TO_SERVER.registerPacket(TabCompleteRequest.class, TabCompleteRequest::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 20)});
            this.TO_SERVER.registerPacket(ClientSettings.class, ClientSettings::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 21)});
            this.TO_SERVER.registerPacket(PluginMessage.class, PluginMessage::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 23)});
        }
    }
    ,
    STATUS{
        {
            this.TO_CLIENT.registerPacket(StatusResponse.class, StatusResponse::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
            this.TO_CLIENT.registerPacket(PingPacket.class, PingPacket::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1)});
            this.TO_SERVER.registerPacket(StatusRequest.class, StatusRequest::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
            this.TO_SERVER.registerPacket(PingPacket.class, PingPacket::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1)});
        }
    }
    ,
    LOGIN{
        {
            this.TO_CLIENT.registerPacket(Kick.class, Kick::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
            this.TO_CLIENT.registerPacket(EncryptionRequest.class, EncryptionRequest::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1)});
            this.TO_CLIENT.registerPacket(LoginSuccess.class, LoginSuccess::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 2)});
            this.TO_CLIENT.registerPacket(SetCompression.class, SetCompression::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 3)});
            this.TO_SERVER.registerPacket(LoginRequest.class, LoginRequest::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 0)});
            this.TO_SERVER.registerPacket(EncryptionResponse.class, EncryptionResponse::new, new ProtocolMapping[]{EaglerBungeeProtocol.map(47, 1)});
        }
    }
    ,
    CONFIGURATION{};

    public static final int MAX_PACKET_ID = 255;
    public final DirectionData TO_SERVER = new DirectionData(this, ProtocolConstants.Direction.TO_SERVER);
    public final DirectionData TO_CLIENT = new DirectionData(this, ProtocolConstants.Direction.TO_CLIENT);

    private EaglerBungeeProtocol() {
    }

    public static void main(String[] args) {
        Iterator iterator = ProtocolConstants.SUPPORTED_VERSION_IDS.iterator();
        while (iterator.hasNext()) {
            int version = (Integer)iterator.next();
            EaglerBungeeProtocol.dump(version);
        }
    }

    private static void dump(int version) {
        EaglerBungeeProtocol[] eaglerBungeeProtocolArray = EaglerBungeeProtocol.values();
        int n = eaglerBungeeProtocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            EaglerBungeeProtocol protocol = eaglerBungeeProtocolArray[n2];
            EaglerBungeeProtocol.dump(version, protocol);
            ++n2;
        }
    }

    private static void dump(int version, EaglerBungeeProtocol protocol) {
        EaglerBungeeProtocol.dump(version, protocol.TO_CLIENT);
        EaglerBungeeProtocol.dump(version, protocol.TO_SERVER);
    }

    private static void dump(int version, DirectionData data) {
        int id = 0;
        while (id < 255) {
            DefinedPacket packet = data.createPacket(id, version);
            if (packet != null) {
                System.out.println(String.valueOf(version) + " " + (Object)((Object)data.protocolPhase) + " " + data.direction + " " + id + " " + packet.getClass().getSimpleName());
            }
            ++id;
        }
    }

    private static ProtocolMapping map(int protocol, int id) {
        return new ProtocolMapping(protocol, id);
    }

    /* synthetic */ EaglerBungeeProtocol(String string, int n, EaglerBungeeProtocol eaglerBungeeProtocol) {
        this();
    }

    public static final class DirectionData {
        private final TIntObjectMap<ProtocolData> protocols = new TIntObjectHashMap();
        private final EaglerBungeeProtocol protocolPhase;
        private final ProtocolConstants.Direction direction;

        public DirectionData(EaglerBungeeProtocol protocolPhase, ProtocolConstants.Direction direction) {
            this.protocolPhase = protocolPhase;
            this.direction = direction;
            Iterator iterator = ProtocolConstants.SUPPORTED_VERSION_IDS.iterator();
            while (iterator.hasNext()) {
                int protocol = (Integer)iterator.next();
                this.protocols.put(protocol, (Object)new ProtocolData(protocol));
            }
        }

        private ProtocolData getProtocolData(int version) {
            ProtocolData protocol = (ProtocolData)this.protocols.get(version);
            if (protocol == null && this.protocolPhase != GAME) {
                protocol = (ProtocolData)Iterables.getFirst((Iterable)this.protocols.valueCollection(), null);
            }
            return protocol;
        }

        public final DefinedPacket createPacket(int id, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version " + version);
            }
            if (id > 255 || id < 0) {
                throw new BadPacketException("Packet with id " + id + " outside of range");
            }
            Supplier constructor = protocolData.packetConstructors[id];
            return constructor == null ? null : (DefinedPacket)constructor.get();
        }

        private void registerPacket(Class<? extends DefinedPacket> packetClass, Supplier<? extends DefinedPacket> constructor, ProtocolMapping ... mappings) {
            int mappingIndex = 0;
            ProtocolMapping mapping = mappings[mappingIndex];
            Iterator iterator = ProtocolConstants.SUPPORTED_VERSION_IDS.iterator();
            while (iterator.hasNext()) {
                ProtocolMapping nextMapping;
                int protocol = (Integer)iterator.next();
                if (protocol < mapping.protocolVersion) continue;
                if (mapping.protocolVersion < protocol && mappingIndex + 1 < mappings.length && (nextMapping = mappings[mappingIndex + 1]).protocolVersion == protocol) {
                    Preconditions.checkState((nextMapping.packetID != mapping.packetID ? 1 : 0) != 0, (String)"Duplicate packet mapping (%s, %s)", (int)mapping.protocolVersion, (int)nextMapping.protocolVersion);
                    mapping = nextMapping;
                    ++mappingIndex;
                }
                if (mapping.packetID < 0) break;
                ProtocolData data = (ProtocolData)this.protocols.get(protocol);
                data.packetMap.put(packetClass, mapping.packetID);
                ((ProtocolData)data).packetConstructors[((ProtocolMapping)mapping).packetID] = constructor;
            }
        }

        public boolean hasPacket(Class<? extends DefinedPacket> packet, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            return protocolData.packetMap.containsKey(packet);
        }

        final int getId(Class<? extends DefinedPacket> packet, int version) {
            ProtocolData protocolData = this.getProtocolData(version);
            if (protocolData == null) {
                throw new BadPacketException("Unsupported protocol version");
            }
            Preconditions.checkArgument((boolean)protocolData.packetMap.containsKey(packet), (String)"Cannot get ID for packet %s in phase %s with direction %s", packet, (Object)((Object)this.protocolPhase), (Object)this.direction);
            return protocolData.packetMap.get(packet);
        }
    }

    private static class ProtocolData {
        private final int protocolVersion;
        private final TObjectIntMap<Class<? extends DefinedPacket>> packetMap = new TObjectIntHashMap(255);
        private final Supplier<? extends DefinedPacket>[] packetConstructors = new Supplier[255];

        private ProtocolData(int protocolVersion) {
            this.protocolVersion = protocolVersion;
        }
    }

    private static class ProtocolMapping {
        private final int protocolVersion;
        private final int packetID;

        private ProtocolMapping(int protocolVersion, int packetID) {
            this.protocolVersion = protocolVersion;
            this.packetID = packetID;
        }
    }
}

