/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import gnu.trove.set.TIntSet;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Logger;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerConnectionInstance;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerUpdateSvc;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.HttpHandshakeHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpWebServer;

public class EaglerPipeline {
    public static final AttributeKey<EaglerListenerConfig> LISTENER = AttributeKey.valueOf((String)"ListenerInfo");
    public static final AttributeKey<InetSocketAddress> LOCAL_ADDRESS = AttributeKey.valueOf((String)"LocalAddress");
    public static final AttributeKey<EaglerConnectionInstance> CONNECTION_INSTANCE = AttributeKey.valueOf((String)"EaglerConnectionInstance");
    public static final AttributeKey<InetAddress> REAL_ADDRESS = AttributeKey.valueOf((String)"RealAddress");
    public static final AttributeKey<String> HOST = AttributeKey.valueOf((String)"Host");
    public static final AttributeKey<String> ORIGIN = AttributeKey.valueOf((String)"Origin");
    public static final Collection<Channel> openChannels = new LinkedList<Channel>();
    public static final String UPDATE_CERT_CHANNEL = "EAG|UpdateCert-1.8";
    public static final TimerTask closeInactive = new TimerTask(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block22: {
                Logger log = EaglerXBungee.logger();
                try {
                    ArrayList<Channel> channelsList;
                    EaglerBungeeConfig conf = EaglerXBungee.getEagler().getConfig();
                    long handshakeTimeout = conf.getWebsocketHandshakeTimeout();
                    long keepAliveTimeout = conf.getWebsocketKeepAliveTimeout();
                    Collection<Channel> collection = openChannels;
                    synchronized (collection) {
                        long millis = System.currentTimeMillis();
                        Iterator<Channel> channelIterator = openChannels.iterator();
                        while (channelIterator.hasNext()) {
                            Channel c = channelIterator.next();
                            EaglerConnectionInstance i = (EaglerConnectionInstance)c.attr(CONNECTION_INSTANCE).get();
                            long handshakeTimeoutForConnection = 500L;
                            if (i.isRegularHttp) {
                                handshakeTimeoutForConnection = 10000L;
                            }
                            if (i.isWebSocket) {
                                handshakeTimeoutForConnection = handshakeTimeout;
                            }
                            if (i == null || !i.hasBeenForwarded && millis - i.creationTime > handshakeTimeoutForConnection || millis - i.lastClientPongPacket > keepAliveTimeout || !c.isActive()) {
                                if (c.isActive()) {
                                    c.close();
                                }
                                channelIterator.remove();
                                continue;
                            }
                            long pingRate = 5000L;
                            if (pingRate + 700L > keepAliveTimeout && (pingRate = keepAliveTimeout - 500L) < 500L) {
                                keepAliveTimeout = 500L;
                            }
                            if (millis - i.lastServerPingPacket <= pingRate) continue;
                            i.lastServerPingPacket = millis;
                            c.write((Object)new PingWebSocketFrame());
                        }
                        channelsList = new ArrayList<Channel>(openChannels);
                    }
                    for (EaglerListenerConfig lst : conf.getServerListeners()) {
                        HttpWebServer srv = lst.getWebServer();
                        if (srv == null) continue;
                        try {
                            srv.flushCache();
                        }
                        catch (Throwable t) {
                            log.severe("Failed to flush web server cache for: " + lst.getAddress().toString());
                            t.printStackTrace();
                        }
                    }
                    if (conf.getUpdateConfig().isBlockAllClientUpdates()) break block22;
                    int sizeTracker = 0;
                    for (Channel c : channelsList) {
                        boolean bb;
                        EaglerConnectionInstance conn = (EaglerConnectionInstance)c.attr(CONNECTION_INSTANCE).get();
                        if (conn.userConnection == null) continue;
                        EaglerInitialHandler i = (EaglerInitialHandler)conn.userConnection.getPendingConnection();
                        Object certHolder = null;
                        Set<EaglerInitialHandler.ClientCertificateHolder> handshakeTimeoutForConnection = i.certificatesToSend;
                        synchronized (handshakeTimeoutForConnection) {
                            if (i.certificatesToSend.size() > 0) {
                                Iterator<EaglerInitialHandler.ClientCertificateHolder> itr = i.certificatesToSend.iterator();
                                certHolder = itr.next();
                                itr.remove();
                            }
                        }
                        if (certHolder == null) continue;
                        int identityHash = certHolder.hashCode();
                        TIntSet tIntSet = i.certificatesSent;
                        synchronized (tIntSet) {
                            bb = i.certificatesSent.add(identityHash);
                        }
                        if (!bb) continue;
                        conn.userConnection.sendData(EaglerPipeline.UPDATE_CERT_CHANNEL, ((EaglerInitialHandler.ClientCertificateHolder)certHolder).data);
                        if ((sizeTracker += ((EaglerInitialHandler.ClientCertificateHolder)certHolder).data.length) > conf.getUpdateConfig().getCertPacketDataRateLimit() / 4) break;
                    }
                    EaglerUpdateSvc.updateTick();
                }
                catch (Throwable t) {
                    log.severe("Exception in thread \"" + Thread.currentThread().getName() + "\"! " + t.toString());
                    t.printStackTrace();
                }
            }
        }
    };
    public static final ChannelInitializer<Channel> SERVER_CHILD = new ChannelInitializer<Channel>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void initChannel(Channel channel) throws Exception {
            ChannelPipeline pipeline = channel.pipeline();
            pipeline.addLast("HttpServerCodec", (ChannelHandler)new HttpServerCodec());
            pipeline.addLast("HttpObjectAggregator", (ChannelHandler)new HttpObjectAggregator(65535));
            int compressionLevel = EaglerXBungee.getEagler().getConfig().getHttpWebsocketCompressionLevel();
            if (compressionLevel > 0) {
                if (compressionLevel > 9) {
                    compressionLevel = 9;
                }
                DeflateFrameServerExtensionHandshaker deflateExtensionHandshaker = new DeflateFrameServerExtensionHandshaker(compressionLevel);
                PerMessageDeflateServerExtensionHandshaker perMessageDeflateExtensionHandshaker = new PerMessageDeflateServerExtensionHandshaker(compressionLevel, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, false, false);
                pipeline.addLast("HttpCompressionHandler", (ChannelHandler)new WebSocketServerExtensionHandler(new WebSocketServerExtensionHandshaker[]{deflateExtensionHandshaker, perMessageDeflateExtensionHandshaker}));
            }
            pipeline.addLast("HttpHandshakeHandler", (ChannelHandler)new HttpHandshakeHandler((EaglerListenerConfig)((Object)channel.attr(LISTENER).get())));
            channel.attr(CONNECTION_INSTANCE).set((Object)new EaglerConnectionInstance(channel));
            Collection<Channel> collection = openChannels;
            synchronized (collection) {
                openChannels.add(channel);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeChannel(Channel channel) {
        Collection<Channel> collection = openChannels;
        synchronized (collection) {
            openChannels.remove(channel);
        }
    }
}

