/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import java.lang.reflect.Method;
import java.util.List;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.bungeeprotocol.EaglerBungeeProtocol;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.bungeeprotocol.EaglerProtocolAccessProxy;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EaglerMinecraftEncoder
extends MessageToMessageEncoder<DefinedPacket> {
    private EaglerBungeeProtocol protocol;
    private boolean server;
    private int protocolVersion;
    private static Method meth = null;

    protected void encode(ChannelHandlerContext ctx, DefinedPacket msg, List<Object> out) throws Exception {
        Protocol bungeeProtocol = null;
        switch (this.protocol) {
            case GAME: {
                bungeeProtocol = Protocol.GAME;
                break;
            }
            case HANDSHAKE: {
                bungeeProtocol = Protocol.HANDSHAKE;
                break;
            }
            case LOGIN: {
                bungeeProtocol = Protocol.LOGIN;
                break;
            }
            case STATUS: {
                bungeeProtocol = Protocol.STATUS;
            }
        }
        ByteBuf buf = Unpooled.buffer();
        int pk = EaglerProtocolAccessProxy.getPacketId(this.protocol, this.protocolVersion, msg, this.server);
        DefinedPacket.writeVarInt((int)pk, (ByteBuf)buf);
        try {
            msg.write(buf, bungeeProtocol, this.server ? ProtocolConstants.Direction.TO_CLIENT : ProtocolConstants.Direction.TO_SERVER, this.protocolVersion);
        }
        catch (NoSuchMethodError e) {
            try {
                if (meth == null) {
                    meth = DefinedPacket.class.getDeclaredMethod("write", ByteBuf.class, ProtocolConstants.Direction.class, Integer.TYPE);
                }
                meth.invoke((Object)msg, buf, this.server ? ProtocolConstants.Direction.TO_CLIENT : ProtocolConstants.Direction.TO_SERVER, this.protocolVersion);
            }
            catch (Exception e1) {
                buf.release();
                buf = Unpooled.EMPTY_BUFFER;
            }
        }
        catch (Exception e) {
            buf.release();
            buf = Unpooled.EMPTY_BUFFER;
        }
        out.add(new BinaryWebSocketFrame(buf));
    }

    public EaglerMinecraftEncoder(EaglerBungeeProtocol protocol, boolean server, int protocolVersion) {
        this.protocol = protocol;
        this.server = server;
        this.protocolVersion = protocolVersion;
    }

    public void setProtocol(EaglerBungeeProtocol protocol) {
        this.protocol = protocol;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public EaglerBungeeProtocol getProtocol() {
        return this.protocol;
    }
}

