/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config;

import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.config.Configuration;

public class EaglerAuthConfig {
    private boolean enableAuthentication;
    private boolean useBuiltInAuthentication;
    private final String databaseURI;
    private final String driverClass;
    private final String driverPath;
    private final String passwordPromptScreenText;
    private final String wrongPasswordScreenText;
    private final String notRegisteredScreenText;
    private final String eaglerCommandName;
    private final String useRegisterCommandText;
    private final String useChangeCommandText;
    private final String commandSuccessText;
    private final String lastEaglerLoginMessage;
    private final String tooManyRegistrationsMessage;
    private final String needVanillaToRegisterMessage;
    private final boolean overrideEaglerToVanillaSkins;
    private final int maxRegistrationsPerIP;

    static EaglerAuthConfig loadConfig(Configuration config) {
        boolean enableAuthentication = config.getBoolean("enable_authentication_system");
        boolean useBuiltInAuthentication = config.getBoolean("use_onboard_eaglerx_system");
        String databaseURI = config.getString("auth_db_uri");
        String driverClass = config.getString("sql_driver_class", "internal");
        String driverPath = config.getString("sql_driver_path", null);
        String passwordPromptScreenText = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("password_prompt_screen_text", ""));
        String notRegisteredScreenText = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("not_registered_screen_text", ""));
        String wrongPasswordScreenText = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("wrong_password_screen_text", ""));
        String eaglerCommandName = config.getString("eagler_command_name");
        String useRegisterCommandText = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("use_register_command_text", ""));
        String useChangeCommandText = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("use_change_command_text", ""));
        String commandSuccessText = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("command_success_text", ""));
        String lastEaglerLoginMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("last_eagler_login_message", ""));
        String tooManyRegistrationsMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("too_many_registrations_message", ""));
        String needVanillaToRegisterMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("need_vanilla_to_register_message", ""));
        boolean overrideEaglerToVanillaSkins = config.getBoolean("override_eagler_to_vanilla_skins");
        int maxRegistrationsPerIP = config.getInt("max_registration_per_ip", -1);
        return new EaglerAuthConfig(enableAuthentication, useBuiltInAuthentication, databaseURI, driverClass, driverPath, passwordPromptScreenText, wrongPasswordScreenText, notRegisteredScreenText, eaglerCommandName, useRegisterCommandText, useChangeCommandText, commandSuccessText, lastEaglerLoginMessage, tooManyRegistrationsMessage, needVanillaToRegisterMessage, overrideEaglerToVanillaSkins, maxRegistrationsPerIP);
    }

    private EaglerAuthConfig(boolean enableAuthentication, boolean useBuiltInAuthentication, String databaseURI, String driverClass, String driverPath, String passwordPromptScreenText, String wrongPasswordScreenText, String notRegisteredScreenText, String eaglerCommandName, String useRegisterCommandText, String useChangeCommandText, String commandSuccessText, String lastEaglerLoginMessage, String tooManyRegistrationsMessage, String needVanillaToRegisterMessage, boolean overrideEaglerToVanillaSkins, int maxRegistrationsPerIP) {
        this.enableAuthentication = enableAuthentication;
        this.useBuiltInAuthentication = useBuiltInAuthentication;
        this.databaseURI = databaseURI;
        this.driverClass = driverClass;
        this.driverPath = driverPath;
        this.passwordPromptScreenText = passwordPromptScreenText;
        this.wrongPasswordScreenText = wrongPasswordScreenText;
        this.notRegisteredScreenText = notRegisteredScreenText;
        this.eaglerCommandName = eaglerCommandName;
        this.useRegisterCommandText = useRegisterCommandText;
        this.useChangeCommandText = useChangeCommandText;
        this.commandSuccessText = commandSuccessText;
        this.lastEaglerLoginMessage = lastEaglerLoginMessage;
        this.tooManyRegistrationsMessage = tooManyRegistrationsMessage;
        this.needVanillaToRegisterMessage = needVanillaToRegisterMessage;
        this.overrideEaglerToVanillaSkins = overrideEaglerToVanillaSkins;
        this.maxRegistrationsPerIP = maxRegistrationsPerIP;
    }

    public boolean isEnableAuthentication() {
        return this.enableAuthentication;
    }

    public boolean isUseBuiltInAuthentication() {
        return this.useBuiltInAuthentication;
    }

    public void triggerOnlineModeDisabled() {
        this.enableAuthentication = false;
        this.useBuiltInAuthentication = false;
    }

    public String getDatabaseURI() {
        return this.databaseURI;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public String getDriverPath() {
        return this.driverPath;
    }

    public String getPasswordPromptScreenText() {
        return this.passwordPromptScreenText;
    }

    public String getWrongPasswordScreenText() {
        return this.wrongPasswordScreenText;
    }

    public String getNotRegisteredScreenText() {
        return this.notRegisteredScreenText;
    }

    public String getEaglerCommandName() {
        return this.eaglerCommandName;
    }

    public String getUseRegisterCommandText() {
        return this.useRegisterCommandText;
    }

    public String getUseChangeCommandText() {
        return this.useChangeCommandText;
    }

    public String getCommandSuccessText() {
        return this.commandSuccessText;
    }

    public String getLastEaglerLoginMessage() {
        return this.lastEaglerLoginMessage;
    }

    public String getTooManyRegistrationsMessage() {
        return this.tooManyRegistrationsMessage;
    }

    public String getNeedVanillaToRegisterMessage() {
        return this.needVanillaToRegisterMessage;
    }

    public boolean getOverrideEaglerToVanillaSkins() {
        return this.overrideEaglerToVanillaSkins;
    }

    public int getMaxRegistrationsPerIP() {
        return this.maxRegistrationsPerIP;
    }
}

