/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.DefaultAuthSystem;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.command.CommandConfirmCode;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.command.CommandDomain;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.command.CommandEaglerPurge;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.command.CommandEaglerRegister;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.command.CommandRatelimit;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerBungeeConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.handlers.EaglerPacketEventListener;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.handlers.EaglerPluginEventListener;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerPipeline;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpWebServer;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.shit.CompatWarning;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.BinaryHttpClient;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.ISkinService;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinService;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinServiceOffline;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.netty.PipelineUtils;

public class EaglerXBungee
extends Plugin {
    public static final String NATIVE_BUNGEECORD_BUILD = "1.20-R0.3-SNAPSHOT:eda268b:1797";
    public static final String NATIVE_WATERFALL_BUILD = "1.20-R0.2-SNAPSHOT:92b5149:562";
    public static final String NATIVE_FLAMECORD_BUILD = "1.1.1";
    private static EaglerXBungee instance;
    private EaglerBungeeConfig conf = null;
    private EventLoopGroup eventLoopGroup;
    private Collection<Channel> openChannels;
    private final Timer closeInactiveConnections;
    private Timer skinServiceTasks = null;
    private Timer authServiceTasks = null;
    private final ChannelFutureListener newChannelListener;
    private ISkinService skinService;
    private DefaultAuthSystem defaultAuthSystem;

    static {
        CompatWarning.displayCompatWarning();
        instance = null;
    }

    public EaglerXBungee() {
        instance = this;
        this.openChannels = new LinkedList<Channel>();
        this.closeInactiveConnections = new Timer("EaglerXBungee: Network Tick Tasks");
        this.newChannelListener = new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture ch) throws Exception {
                Collection collection = EaglerXBungee.this.openChannels;
                synchronized (collection) {
                    if (ch.isSuccess()) {
                        EaglerXBungee.logger().info("Eaglercraft is listening on: " + ((InetSocketAddress)ch.channel().attr(EaglerPipeline.LOCAL_ADDRESS).get()).toString());
                        EaglerXBungee.this.openChannels.add(ch.channel());
                    } else {
                        EaglerXBungee.logger().severe("Eaglercraft could not bind port: " + ((InetSocketAddress)ch.channel().attr(EaglerPipeline.LOCAL_ADDRESS).get()).toString());
                        EaglerXBungee.logger().severe("Reason: " + ch.cause().toString());
                    }
                }
            }
        };
    }

    public void onLoad() {
        try {
            this.eventLoopGroup = ((BungeeCord)this.getProxy()).eventLoops;
        }
        catch (NoSuchFieldError e) {
            try {
                this.eventLoopGroup = (EventLoopGroup)BungeeCord.class.getField("workerEventLoopGroup").get(this.getProxy());
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                throw new RuntimeException(ex);
            }
        }
        this.reloadConfig();
        this.closeInactiveConnections.scheduleAtFixedRate(EaglerPipeline.closeInactive, 0L, 250L);
    }

    public void onEnable() {
        boolean downloadSkins;
        PluginManager mgr = this.getProxy().getPluginManager();
        mgr.registerListener((Plugin)this, (Listener)new EaglerPluginEventListener(this));
        mgr.registerListener((Plugin)this, (Listener)new EaglerPacketEventListener(this));
        mgr.registerCommand((Plugin)this, (Command)new CommandRatelimit());
        mgr.registerCommand((Plugin)this, (Command)new CommandConfirmCode());
        mgr.registerCommand((Plugin)this, (Command)new CommandDomain());
        EaglerAuthConfig authConf = this.conf.getAuthConfig();
        if (authConf.isEnableAuthentication() && authConf.isUseBuiltInAuthentication()) {
            if (!BungeeCord.getInstance().getConfig().isOnlineMode()) {
                this.getLogger().severe("Online mode is set to false! Authentication system has been disabled");
                authConf.triggerOnlineModeDisabled();
            } else {
                mgr.registerCommand((Plugin)this, (Command)new CommandEaglerRegister(authConf.getEaglerCommandName()));
                mgr.registerCommand((Plugin)this, (Command)new CommandEaglerPurge(authConf.getEaglerCommandName()));
            }
        }
        this.getProxy().registerChannel("EAG|Skins-1.8");
        this.getProxy().registerChannel("EAG|UpdateCert-1.8");
        this.startListeners();
        if (this.skinServiceTasks != null) {
            this.skinServiceTasks.cancel();
            this.skinServiceTasks = null;
        }
        if (downloadSkins = this.conf.getDownloadVanillaSkins()) {
            if (this.skinService == null) {
                this.skinService = new SkinService();
            } else if (this.skinService instanceof SkinServiceOffline) {
                this.skinService.shutdown();
                this.skinService = new SkinService();
            }
        } else if (this.skinService == null) {
            this.skinService = new SkinServiceOffline();
        } else if (this.skinService instanceof SkinService) {
            this.skinService.shutdown();
            this.skinService = new SkinServiceOffline();
        }
        this.skinService.init(this.conf.getSkinCacheURI(), this.conf.getSQLiteDriverClass(), this.conf.getSQLiteDriverPath(), this.conf.getKeepObjectsDays(), this.conf.getKeepProfilesDays(), this.conf.getMaxObjects(), this.conf.getMaxProfiles());
        if (this.skinService instanceof SkinService) {
            this.skinServiceTasks = new Timer("EaglerXBungee: Skin Service Tasks");
            this.skinServiceTasks.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        EaglerXBungee.this.skinService.flush();
                    }
                    catch (Throwable t) {
                        EaglerXBungee.logger().log(Level.SEVERE, "Error flushing skin cache!", t);
                    }
                }
            }, 1000L, 1000L);
        }
        if (authConf.isEnableAuthentication() && authConf.isUseBuiltInAuthentication()) {
            try {
                this.defaultAuthSystem = DefaultAuthSystem.initializeAuthSystem(authConf);
            }
            catch (DefaultAuthSystem.AuthSystemException ex) {
                EaglerXBungee.logger().log(Level.SEVERE, "Could not load authentication system!", ex);
            }
            if (this.defaultAuthSystem != null) {
                this.authServiceTasks = new Timer("EaglerXBungee: Auth Service Tasks");
                this.authServiceTasks.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            EaglerXBungee.this.defaultAuthSystem.flush();
                        }
                        catch (Throwable t) {
                            EaglerXBungee.logger().log(Level.SEVERE, "Error flushing auth cache!", t);
                        }
                    }
                }, 60000L, 60000L);
            }
        }
    }

    public void onDisable() {
        PluginManager mgr = this.getProxy().getPluginManager();
        mgr.unregisterListeners((Plugin)this);
        mgr.unregisterCommands((Plugin)this);
        this.getProxy().unregisterChannel("EAG|Skins-1.8");
        this.getProxy().unregisterChannel("EAG|UpdateCert-1.8");
        this.stopListeners();
        if (this.skinServiceTasks != null) {
            this.skinServiceTasks.cancel();
            this.skinServiceTasks = null;
        }
        this.skinService.shutdown();
        if (this.defaultAuthSystem != null) {
            this.defaultAuthSystem.destroy();
            this.defaultAuthSystem = null;
            if (this.authServiceTasks != null) {
                this.authServiceTasks.cancel();
                this.authServiceTasks = null;
            }
        }
        BinaryHttpClient.killEventLoop();
    }

    public void reload() {
        this.stopListeners();
        this.reloadConfig();
        this.startListeners();
    }

    private void reloadConfig() {
        try {
            this.conf = EaglerBungeeConfig.loadConfig(this.getDataFolder());
            if (this.conf == null) {
                throw new IOException("Config failed to parse!");
            }
            HttpWebServer.regenerate404Pages();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void startListeners() {
        for (EaglerListenerConfig conf : this.conf.getServerListeners()) {
            if (conf.getAddress() != null) {
                this.makeListener(conf, conf.getAddress());
            }
            if (conf.getAddressV6() == null) continue;
            this.makeListener(conf, conf.getAddressV6());
        }
    }

    private void makeListener(EaglerListenerConfig confData, InetSocketAddress addr) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.TCP_NODELAY, (Object)true).channel(PipelineUtils.getServerChannel((SocketAddress)addr))).group(this.eventLoopGroup).childAttr(EaglerPipeline.LISTENER, (Object)confData).attr(EaglerPipeline.LOCAL_ADDRESS, (Object)addr)).localAddress((SocketAddress)addr)).childHandler(EaglerPipeline.SERVER_CHILD).bind().addListener((GenericFutureListener)this.newChannelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListeners() {
        Collection<Channel> collection = this.openChannels;
        synchronized (collection) {
            for (Channel c : this.openChannels) {
                c.close().syncUninterruptibly();
                EaglerXBungee.logger().info("Eaglercraft listener closed: " + ((InetSocketAddress)c.attr(EaglerPipeline.LOCAL_ADDRESS).get()).toString());
            }
            this.openChannels.clear();
        }
        collection = EaglerPipeline.openChannels;
        synchronized (collection) {
            EaglerPipeline.openChannels.clear();
        }
    }

    public EaglerBungeeConfig getConfig() {
        return this.conf;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.eventLoopGroup;
    }

    public ISkinService getSkinService() {
        return this.skinService;
    }

    public DefaultAuthSystem getAuthService() {
        return this.defaultAuthSystem;
    }

    public static EaglerXBungee getEagler() {
        return instance;
    }

    public static Logger logger() {
        return instance.getLogger();
    }
}

