/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.query;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.query.EaglerQuerySimpleHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.api.query.MOTDConnection;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.MOTDCacheConfiguration;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class MOTDQueryHandler
extends EaglerQuerySimpleHandler
implements MOTDConnection {
    private long creationTime = 0L;
    private String line1;
    private String line2;
    private List<String> players;
    private int[] bitmap;
    private int onlinePlayers;
    private int maxPlayers;
    private boolean hasIcon;
    private boolean iconDirty;
    private String subType;
    private String returnType;

    @Override
    protected void begin(String queryType) {
        this.creationTime = System.currentTimeMillis();
        this.subType = queryType;
        this.returnType = "MOTD";
        EaglerListenerConfig listener = this.getListener();
        String[] lns = listener.getMotd().split("\n");
        if (lns.length >= 1) {
            this.line1 = lns[0];
        }
        if (lns.length >= 2) {
            this.line2 = lns[1];
        }
        this.maxPlayers = listener.getMaxPlayers();
        this.onlinePlayers = ProxyServer.getInstance().getOnlineCount();
        this.players = new ArrayList<String>();
        for (ProxiedPlayer pp : ProxyServer.getInstance().getPlayers()) {
            this.players.add(pp.getDisplayName());
            if (this.players.size() < 9) continue;
            this.players.add(ChatColor.GRAY + ChatColor.ITALIC + "(" + (this.onlinePlayers - this.players.size()) + " more)");
            break;
        }
        this.bitmap = new int[4096];
        int i = queryType.indexOf(46);
        if (i > 0) {
            this.subType = queryType.substring(i + 1);
            if (this.subType.length() == 0) {
                this.subType = "motd";
            }
        } else {
            this.subType = "motd";
        }
        if (!this.subType.startsWith("noicon") && !this.subType.startsWith("cache.noicon")) {
            int[] maybeIcon = listener.getServerIconPixels();
            this.hasIcon = maybeIcon != null;
            this.iconDirty = this.hasIcon;
            if (this.hasIcon) {
                System.arraycopy(maybeIcon, 0, this.bitmap, 0, 4096);
            }
        }
    }

    @Override
    public long getConnectionTimestamp() {
        return this.creationTime;
    }

    @Override
    public void sendToUser() {
        if (!this.isClosed()) {
            JsonObject obj = new JsonObject();
            if (this.subType.startsWith("cache.anim")) {
                obj.addProperty("unsupported", Boolean.valueOf(true));
                this.sendJsonResponseAndClose(this.returnType, obj);
                return;
            }
            if (this.subType.startsWith("cache")) {
                JsonArray cacheControl = new JsonArray();
                MOTDCacheConfiguration cc = this.getListener().getMOTDCacheConfig();
                if (cc.cacheServerListAnimation) {
                    cacheControl.add("animation");
                }
                if (cc.cacheServerListResults) {
                    cacheControl.add("results");
                }
                if (cc.cacheServerListTrending) {
                    cacheControl.add("trending");
                }
                if (cc.cacheServerListPortfolios) {
                    cacheControl.add("portfolio");
                }
                obj.add("cache", (JsonElement)cacheControl);
                obj.addProperty("ttl", (Number)cc.cacheTTL);
            } else {
                MOTDCacheConfiguration cc = this.getListener().getMOTDCacheConfig();
                obj.addProperty("cache", Boolean.valueOf(cc.cacheServerListAnimation || cc.cacheServerListResults || cc.cacheServerListTrending || cc.cacheServerListPortfolios));
            }
            boolean noIcon = this.subType.startsWith("noicon") || this.subType.startsWith("cache.noicon");
            JsonArray motd = new JsonArray();
            if (this.line1 != null && this.line1.length() > 0) {
                motd.add(this.line1);
            }
            if (this.line2 != null && this.line2.length() > 0) {
                motd.add(this.line2);
            }
            obj.add("motd", (JsonElement)motd);
            obj.addProperty("icon", Boolean.valueOf(this.hasIcon && !noIcon));
            obj.addProperty("online", (Number)this.onlinePlayers);
            obj.addProperty("max", (Number)this.maxPlayers);
            JsonArray playerz = new JsonArray();
            for (String s : this.players) {
                playerz.add(s);
            }
            obj.add("players", (JsonElement)playerz);
            this.sendJsonResponse(this.returnType, obj);
            if (this.hasIcon && !noIcon && this.iconDirty && this.bitmap != null) {
                byte[] iconPixels = new byte[16384];
                int i = 0;
                while (i < 4096) {
                    int j = i << 2;
                    iconPixels[j] = (byte)(this.bitmap[i] >> 16 & 0xFF);
                    iconPixels[j + 1] = (byte)(this.bitmap[i] >> 8 & 0xFF);
                    iconPixels[j + 2] = (byte)(this.bitmap[i] & 0xFF);
                    iconPixels[j + 3] = (byte)(this.bitmap[i] >> 24 & 0xFF);
                    ++i;
                }
                this.sendBinaryResponse(iconPixels);
                this.iconDirty = false;
            }
            if (this.subType.startsWith("cache")) {
                this.close();
            }
        }
    }

    @Override
    public String getLine1() {
        return this.line1;
    }

    @Override
    public String getLine2() {
        return this.line2;
    }

    @Override
    public List<String> getPlayerList() {
        return this.players;
    }

    @Override
    public int[] getBitmap() {
        return this.bitmap;
    }

    @Override
    public int getOnlinePlayers() {
        return this.onlinePlayers;
    }

    @Override
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @Override
    public String getSubType() {
        return this.subType;
    }

    @Override
    public void setLine1(String p) {
        this.line1 = p;
    }

    @Override
    public void setLine2(String p) {
        this.line2 = p;
    }

    @Override
    public void setPlayerList(List<String> p) {
        this.players = p;
    }

    @Override
    public void setPlayerList(String ... p) {
        this.players = Arrays.asList(p);
    }

    @Override
    public void setBitmap(int[] p) {
        this.hasIcon = true;
        this.iconDirty = true;
        this.bitmap = p;
    }

    @Override
    public void setOnlinePlayers(int i) {
        this.onlinePlayers = i;
    }

    @Override
    public void setMaxPlayers(int i) {
        this.maxPlayers = i;
    }
}

