/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server;

import gnu.trove.set.TIntSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.SHA1Digest;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerUpdateConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class EaglerUpdateSvc {
    private static final List<EaglerInitialHandler.ClientCertificateHolder> certs = new ArrayList<EaglerInitialHandler.ClientCertificateHolder>();
    private static final Map<String, CachedClientCertificate> certsCache = new HashMap<String, CachedClientCertificate>();
    private static long lastDownload = 0L;
    private static long lastEnumerate = 0L;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void updateTick() {
        Logger log = EaglerXBungee.logger();
        long millis = System.currentTimeMillis();
        EaglerUpdateConfig conf = EaglerXBungee.getEagler().getConfig().getUpdateConfig();
        if (conf.isDownloadLatestCerts() && millis - lastDownload > (long)conf.getCheckForUpdatesEvery() * 1000L) {
            lastDownload = millis;
            lastEnumerate = 0L;
            try {
                EaglerUpdateSvc.downloadUpdates();
            }
            catch (Throwable t) {
                log.severe("Uncaught exception downloading certificates!");
                t.printStackTrace();
            }
            millis = System.currentTimeMillis();
        }
        if (conf.isEnableEagcertFolder() && millis - lastEnumerate > 5000L) {
            lastEnumerate = millis;
            try {
                EaglerUpdateSvc.enumerateEagcertDirectory();
            }
            catch (Throwable t) {
                log.severe("Uncaught exception reading eagcert directory!");
                t.printStackTrace();
            }
        }
    }

    private static void downloadUpdates() throws Throwable {
        Logger log = EaglerXBungee.logger();
        EaglerUpdateConfig conf = EaglerXBungee.getEagler().getConfig().getUpdateConfig();
        File eagcert = new File(EaglerXBungee.getEagler().getDataFolder(), "eagcert");
        if (!eagcert.isDirectory() && !eagcert.mkdirs()) {
            log.severe("Could not create directory: " + eagcert.getAbsolutePath());
            return;
        }
        HashSet<String> filenames = new HashSet<String>();
        for (String str : conf.getDownloadCertURLs()) {
            try {
                URL url = new URL(str);
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setDoInput(true);
                con.setDoOutput(false);
                con.setRequestMethod("GET");
                con.setConnectTimeout(30000);
                con.setReadTimeout(30000);
                con.setRequestProperty("User-Agent", "Mozilla/5.0 EaglerXBungee/" + EaglerXBungee.getEagler().getDescription().getVersion());
                con.connect();
                int code = con.getResponseCode();
                if (code / 100 != 2) {
                    con.disconnect();
                    throw new IOException("Response code was " + code);
                }
                ByteArrayOutputStream bao = new ByteArrayOutputStream(Short.MAX_VALUE);
                Throwable throwable = null;
                Object var11_16 = null;
                try (InputStream is = con.getInputStream();){
                    int c;
                    byte[] readBuffer = new byte[1024];
                    while ((c = is.read(readBuffer, 0, 1024)) != -1) {
                        bao.write(readBuffer, 0, c);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                byte[] done = bao.toByteArray();
                SHA1Digest digest = new SHA1Digest();
                digest.update(done, 0, done.length);
                byte[] hash = new byte[20];
                digest.doFinal(hash, 0);
                char[] hexchars = new char[40];
                int i = 0;
                while (i < 20) {
                    hexchars[i << 1] = hex[hash[i] >> 4 & 0xF];
                    hexchars[(i << 1) + 1] = hex[hash[i] & 0xF];
                    ++i;
                }
                String strr = "$dl." + new String(hexchars) + ".cert";
                filenames.add(strr);
                File cacheFile = new File(eagcert, strr);
                if (cacheFile.exists()) continue;
                Throwable throwable3 = null;
                Object var17_25 = null;
                try (FileOutputStream os = new FileOutputStream(cacheFile);){
                    ((OutputStream)os).write(done);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
                log.info("Downloading new certificate: " + str);
            }
            catch (Throwable t) {
                log.severe("Failed to download certificate: " + str);
                log.severe("Reason: " + t.toString());
            }
        }
        long millis = System.currentTimeMillis();
        File[] dirList = eagcert.listFiles();
        int i = 0;
        while (i < dirList.length) {
            File f = dirList[i];
            String n = f.getName();
            if (n.startsWith("$dl.") && millis - f.lastModified() > 86400000L && !filenames.contains(n)) {
                log.warning("Deleting stale certificate: " + n);
                if (!f.delete()) {
                    log.severe("Failed to delete: " + n);
                }
            }
            ++i;
        }
    }

    private static void enumerateEagcertDirectory() throws Throwable {
        Logger log = EaglerXBungee.logger();
        File eagcert = new File(EaglerXBungee.getEagler().getDataFolder(), "eagcert");
        if (!eagcert.isDirectory() && !eagcert.mkdirs()) {
            log.severe("Could not create directory: " + eagcert.getAbsolutePath());
            return;
        }
        boolean dirty = false;
        File[] dirList = eagcert.listFiles();
        HashSet<String> existingFiles = new HashSet<String>();
        int i = 0;
        while (i < dirList.length) {
            Object ch;
            int k;
            int j;
            FileInputStream fis;
            Object var13_17;
            byte[] fileData;
            File f = dirList[i];
            String n = f.getName();
            long lastModified = f.lastModified();
            existingFiles.add(n);
            CachedClientCertificate cc = certsCache.get(n);
            if (cc != null) {
                if (cc.lastModified != lastModified) {
                    try {
                        fileData = new byte[(int)f.length()];
                        if (fileData.length > 65535) {
                            throw new IOException("File is too long! Max: 65535 bytes");
                        }
                        Throwable throwable = null;
                        var13_17 = null;
                        try {
                            fis = new FileInputStream(f);
                            try {
                                j = 0;
                                while ((k = fis.read(fileData, j, fileData.length - j)) != -1 && j < fileData.length) {
                                    j += k;
                                }
                            }
                            finally {
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        certsCache.remove(n);
                        ch = EaglerUpdateSvc.tryMakeHolder(fileData);
                        certsCache.put(n, new CachedClientCertificate((EaglerInitialHandler.ClientCertificateHolder)ch, lastModified));
                        dirty = true;
                        EaglerUpdateSvc.sendCertificateToPlayers((EaglerInitialHandler.ClientCertificateHolder)ch);
                        log.info("Reloaded certificate: " + f.getAbsolutePath());
                    }
                    catch (IOException ex) {
                        log.severe("Failed to read: " + f.getAbsolutePath());
                        log.severe("Reason: " + ex.toString());
                    }
                }
            } else {
                try {
                    fileData = new byte[(int)f.length()];
                    if (fileData.length > 65535) {
                        throw new IOException("File is too long! Max: 65535 bytes");
                    }
                    ch = null;
                    var13_17 = null;
                    try {
                        fis = new FileInputStream(f);
                        try {
                            j = 0;
                            while (j < fileData.length && (k = fis.read(fileData, j, fileData.length - j)) != -1) {
                                j += k;
                            }
                        }
                        finally {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (ch == null) {
                            ch = throwable;
                        } else if (ch != throwable) {
                            ((Throwable)ch).addSuppressed(throwable);
                        }
                        throw ch;
                    }
                    ch = EaglerUpdateSvc.tryMakeHolder(fileData);
                    certsCache.put(n, new CachedClientCertificate((EaglerInitialHandler.ClientCertificateHolder)ch, lastModified));
                    dirty = true;
                    EaglerUpdateSvc.sendCertificateToPlayers((EaglerInitialHandler.ClientCertificateHolder)ch);
                    log.info("Loaded certificate: " + f.getAbsolutePath());
                }
                catch (IOException ex) {
                    log.severe("Failed to read: " + f.getAbsolutePath());
                    log.severe("Reason: " + ex.toString());
                }
            }
            ++i;
        }
        Iterator<String> itr = certsCache.keySet().iterator();
        while (itr.hasNext()) {
            String etr = itr.next();
            if (existingFiles.contains(etr)) continue;
            itr.remove();
            dirty = true;
            log.warning("Certificate was deleted: " + etr);
        }
        if (dirty) {
            EaglerUpdateSvc.remakeCertsList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remakeCertsList() {
        List<EaglerInitialHandler.ClientCertificateHolder> list = certs;
        synchronized (list) {
            certs.clear();
            for (CachedClientCertificate cc : certsCache.values()) {
                certs.add(cc.cert);
            }
        }
    }

    public static List<EaglerInitialHandler.ClientCertificateHolder> getCertList() {
        return certs;
    }

    public static EaglerInitialHandler.ClientCertificateHolder tryMakeHolder(byte[] data) {
        int hash = Arrays.hashCode(data);
        EaglerInitialHandler.ClientCertificateHolder ret = EaglerUpdateSvc.tryGetHolder(data, hash);
        if (ret == null) {
            ret = new EaglerInitialHandler.ClientCertificateHolder(data, hash);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EaglerInitialHandler.ClientCertificateHolder tryGetHolder(byte[] data, int hash) {
        List<EaglerInitialHandler.ClientCertificateHolder> list = certs;
        synchronized (list) {
            for (EaglerInitialHandler.ClientCertificateHolder cc : certs) {
                if (cc.hash != hash || !Arrays.equals(cc.data, data)) continue;
                return cc;
            }
        }
        for (ProxiedPlayer p : ProxyServer.getInstance().getPlayers()) {
            if (!(p.getPendingConnection() instanceof EaglerInitialHandler)) continue;
            EaglerInitialHandler pp = (EaglerInitialHandler)p.getPendingConnection();
            if (pp.clientCertificate == null || pp.clientCertificate.hash != hash || !Arrays.equals(pp.clientCertificate.data, data)) continue;
            return pp.clientCertificate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendCertificateToPlayers(EaglerInitialHandler.ClientCertificateHolder holder) {
        for (ProxiedPlayer p : ProxyServer.getInstance().getPlayers()) {
            Set<EaglerInitialHandler.ClientCertificateHolder> set;
            boolean bb;
            if (!(p.getPendingConnection() instanceof EaglerInitialHandler)) continue;
            EaglerInitialHandler pp = (EaglerInitialHandler)p.getPendingConnection();
            TIntSet tIntSet = pp.certificatesSent;
            synchronized (tIntSet) {
                bb = pp.certificatesSent.contains(holder.hashCode());
            }
            if (bb) continue;
            Set<EaglerInitialHandler.ClientCertificateHolder> set2 = set = pp.certificatesToSend;
            synchronized (set2) {
                set.add(holder);
            }
        }
    }

    private static class CachedClientCertificate {
        private final EaglerInitialHandler.ClientCertificateHolder cert;
        private final long lastModified;

        public CachedClientCertificate(EaglerInitialHandler.ClientCertificateHolder cert, long lastModified) {
            this.cert = cert;
            this.lastModified = lastModified;
        }
    }
}

