/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.handlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.auth.DefaultAuthSystem;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.EaglerInitialHandler;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinPackets;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.skins.SkinService;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.event.EventHandler;
import net.md_5.bungee.protocol.Property;
import org.apache.commons.codec.binary.Base64;

public class EaglerPacketEventListener
implements Listener {
    public final EaglerXBungee plugin;

    public EaglerPacketEventListener(EaglerXBungee plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPluginMessage(final PluginMessageEvent event) {
        if (event.getSender() instanceof UserConnection) {
            if ("EAG|Skins-1.8".equals(event.getTag())) {
                event.setCancelled(true);
                final UserConnection sender = (UserConnection)event.getSender();
                if (sender.getPendingConnection() instanceof EaglerInitialHandler) {
                    ProxyServer.getInstance().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SkinPackets.processPacket(event.getData(), sender, EaglerPacketEventListener.this.plugin.getSkinService());
                            }
                            catch (IOException e) {
                                event.getSender().disconnect((BaseComponent)new TextComponent("Skin packet error!"));
                                EaglerXBungee.logger().log(Level.SEVERE, "Eagler user \"" + sender.getName() + "\" raised an exception handling skins!", e);
                            }
                        }
                    });
                } else {
                    event.getSender().disconnect((BaseComponent)new TextComponent("Cannot send \"EAG|Skins-1.8\" on a non-eagler connection!"));
                }
            }
        } else if (event.getSender() instanceof Server && event.getReceiver() instanceof UserConnection) {
            UserConnection player = (UserConnection)event.getReceiver();
            if ("EAG|GetDomain".equals(event.getTag()) && player.getPendingConnection() instanceof EaglerInitialHandler) {
                String domain = ((EaglerInitialHandler)player.getPendingConnection()).getOrigin();
                if (domain == null) {
                    ((Server)event.getSender()).sendData("EAG|Domain", new byte[1]);
                } else {
                    ((Server)event.getSender()).sendData("EAG|Domain", domain.getBytes(StandardCharsets.UTF_8));
                }
            }
        }
    }

    @EventHandler
    public void onPostLogin(PostLoginEvent event) {
        ProxiedPlayer p = event.getPlayer();
        if (p instanceof UserConnection) {
            DefaultAuthSystem srv;
            EaglerAuthConfig authConf;
            Property[] props;
            UserConnection player = (UserConnection)p;
            InitialHandler handler = player.getPendingConnection();
            LoginResult res = handler.getLoginProfile();
            if (res != null && (props = res.getProperties()).length > 0) {
                int i = 0;
                while (i < props.length) {
                    Property pp = props[i];
                    if (pp.getName().equals("textures")) {
                        try {
                            JsonElement url;
                            String jsonStr = SkinPackets.bytesToAscii(Base64.decodeBase64((String)pp.getValue()));
                            JsonObject json = new JsonParser().parse(jsonStr).getAsJsonObject();
                            JsonObject skinObj = json.getAsJsonObject("SKIN");
                            if (skinObj != null && (url = json.get("url")) != null) {
                                String urlStr = SkinService.sanitizeTextureURL(url.getAsString());
                                this.plugin.getSkinService().registerTextureToPlayerAssociation(urlStr, player.getUniqueId());
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            if ((authConf = EaglerXBungee.getEagler().getConfig().getAuthConfig()).isEnableAuthentication() && authConf.isUseBuiltInAuthentication() && (srv = EaglerXBungee.getEagler().getAuthService()) != null) {
                srv.handleVanillaLogin(event);
            }
        }
    }

    @EventHandler
    public void onConnectionLost(PlayerDisconnectEvent event) {
        this.plugin.getSkinService().unregisterPlayer(event.getPlayer().getUniqueId());
    }
}

