/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import javax.imageio.ImageIO;

class ServerIconLoader {
    ServerIconLoader() {
    }

    static int[] createServerIcon(BufferedImage awtIcon) {
        BufferedImage icon = awtIcon;
        boolean gotScaled = false;
        if (icon.getWidth() != 64 || icon.getHeight() != 64) {
            int nh;
            int nw;
            icon = new BufferedImage(64, 64, awtIcon.getType());
            Graphics2D g = (Graphics2D)icon.getGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, awtIcon.getWidth() < 64 || awtIcon.getHeight() < 64 ? RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR : RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setBackground(new Color(0, true));
            g.clearRect(0, 0, 64, 64);
            int ow = awtIcon.getWidth();
            int oh = awtIcon.getHeight();
            float aspectRatio = (float)oh / (float)ow;
            if (aspectRatio >= 1.0f) {
                nw = (int)(64.0f / aspectRatio);
                nh = 64;
            } else {
                nw = 64;
                nh = (int)(64.0f * aspectRatio);
            }
            g.drawImage(awtIcon, (64 - nw) / 2, (64 - nh) / 2, (64 - nw) / 2 + nw, (64 - nh) / 2 + nh, 0, 0, awtIcon.getWidth(), awtIcon.getHeight(), null);
            g.dispose();
            gotScaled = true;
        }
        int[] pxls = icon.getRGB(0, 0, 64, 64, new int[4096], 0, 64);
        if (gotScaled) {
            int i = 0;
            while (i < pxls.length) {
                if ((pxls[i] & 0xFFFFFF) == 0) {
                    pxls[i] = 0;
                }
                ++i;
            }
        }
        return pxls;
    }

    static int[] createServerIcon(InputStream f) {
        try {
            return ServerIconLoader.createServerIcon(ImageIO.read(f));
        }
        catch (Throwable t) {
            return null;
        }
    }

    static int[] createServerIcon(File f) {
        try {
            return ServerIconLoader.createServerIcon(ImageIO.read(f));
        }
        catch (Throwable t) {
            return null;
        }
    }
}

