/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config;

import java.util.Collection;
import java.util.List;
import net.md_5.bungee.config.Configuration;

public class EaglerUpdateConfig {
    private final boolean blockAllClientUpdates;
    private final boolean discardLoginPacketCerts;
    private final int certPacketDataRateLimit;
    private final boolean enableEagcertFolder;
    private final boolean downloadLatestCerts;
    private final int checkForUpdatesEvery;
    private final Collection<String> downloadCertURLs;

    static EaglerUpdateConfig loadConfig(Configuration config) {
        boolean blockAllClientUpdates = config.getBoolean("block_all_client_updates", false);
        boolean discardLoginPacketCerts = config.getBoolean("discard_login_packet_certs", false);
        int certPacketDataRateLimit = config.getInt("cert_packet_data_rate_limit", 524288);
        boolean enableEagcertFolder = config.getBoolean("enable_eagcert_folder", true);
        boolean downloadLatestCerts = config.getBoolean("download_latest_certs", true);
        int checkForUpdatesEvery = config.getInt("check_for_update_every", 900);
        List downloadCertURLs = config.getList("download_certs_from");
        return new EaglerUpdateConfig(blockAllClientUpdates, discardLoginPacketCerts, certPacketDataRateLimit, enableEagcertFolder, downloadLatestCerts, checkForUpdatesEvery, downloadCertURLs);
    }

    public EaglerUpdateConfig(boolean blockAllClientUpdates, boolean discardLoginPacketCerts, int certPacketDataRateLimit, boolean enableEagcertFolder, boolean downloadLatestCerts, int checkForUpdatesEvery, Collection<String> downloadCertURLs) {
        this.blockAllClientUpdates = blockAllClientUpdates;
        this.discardLoginPacketCerts = discardLoginPacketCerts;
        this.certPacketDataRateLimit = certPacketDataRateLimit;
        this.enableEagcertFolder = enableEagcertFolder;
        this.downloadLatestCerts = downloadLatestCerts;
        this.checkForUpdatesEvery = checkForUpdatesEvery;
        this.downloadCertURLs = downloadCertURLs;
    }

    public boolean isBlockAllClientUpdates() {
        return this.blockAllClientUpdates;
    }

    public boolean isDiscardLoginPacketCerts() {
        return this.discardLoginPacketCerts;
    }

    public int getCertPacketDataRateLimit() {
        return this.certPacketDataRateLimit;
    }

    public boolean isEnableEagcertFolder() {
        return this.enableEagcertFolder;
    }

    public boolean isDownloadLatestCerts() {
        return this.downloadLatestCerts && this.enableEagcertFolder;
    }

    public int getCheckForUpdatesEvery() {
        return this.checkForUpdatesEvery;
    }

    public Collection<String> getDownloadCertURLs() {
        return this.downloadCertURLs;
    }
}

