/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.EaglerXBungee;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerAuthConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerListenerConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.EaglerUpdateConfig;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.config.VanillaDefaultSkinProfileLoader;
import net.lax1dude.eaglercraft.v1_8.plugin.gateway_bungeecord.server.web.HttpContentType;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.md_5.bungee.protocol.Property;

public class EaglerBungeeConfig {
    public static final Property isEaglerProperty = new Property("isEaglerPlayer", "true");
    private final String serverName;
    private final UUID serverUUID;
    private final long websocketKeepAliveTimeout;
    private final long websocketHandshakeTimeout;
    private final int httpWebsocketCompressionLevel;
    private final Map<String, EaglerListenerConfig> serverListeners;
    private final Map<String, HttpContentType> contentTypes;
    private final boolean downloadVanillaSkins;
    private final Collection<String> validSkinUrls;
    private final int uuidRateLimitPlayer;
    private final int uuidRateLimitGlobal;
    private final int skinRateLimitPlayer;
    private final int skinRateLimitGlobal;
    private final String skinCacheURI;
    private final int keepObjectsDays;
    private final int keepProfilesDays;
    private final int maxObjects;
    private final int maxProfiles;
    private final int antagonistsRateLimit;
    private final String sqliteDriverClass;
    private final String sqliteDriverPath;
    private final String eaglerPlayersVanillaSkin;
    private final EaglerAuthConfig authConfig;
    private final EaglerUpdateConfig updateConfig;
    Property[] eaglerPlayersVanillaSkinCached = new Property[]{isEaglerProperty};

    public static EaglerBungeeConfig loadConfig(File directory) throws IOException {
        FileInputStream is22;
        Throwable throwable;
        HashMap<String, HttpContentType> contentTypes = new HashMap<String, HttpContentType>();
        try {
            Throwable throwable2 = null;
            throwable = null;
            try {
                is22 = new FileInputStream(EaglerBungeeConfig.getConfigFile(directory, "http_mime_types.json"));
                try {
                    EaglerBungeeConfig.loadMimeTypes(is22, contentTypes);
                }
                finally {
                    if (is22 != null) {
                        ((InputStream)is22).close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable t) {
            try {
                throwable = null;
                is22 = null;
                try (InputStream is = EaglerBungeeConfig.class.getResourceAsStream("default_http_mime_types.json");){
                    EaglerBungeeConfig.loadMimeTypes(is, contentTypes);
                }
                catch (Throwable is22) {
                    if (throwable == null) {
                        throwable = is22;
                    } else if (throwable != is22) {
                        throwable.addSuppressed(is22);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                EaglerXBungee.logger().severe("Could not load default_http_mime_types.json!");
                throw new RuntimeException(ex);
            }
        }
        directory.mkdirs();
        ConfigurationProvider prov = ConfigurationProvider.getProvider(YamlConfiguration.class);
        Configuration configYml = prov.load(EaglerBungeeConfig.getConfigFile(directory, "settings.yml"));
        String serverName = configYml.getString("server_name", "EaglercraftXBungee Server");
        String serverUUIDString = configYml.getString("server_uuid", null);
        if (serverUUIDString == null) {
            throw new IOException("You must specify a server_uuid!");
        }
        UUID serverUUID = null;
        try {
            serverUUID = UUID.fromString(serverUUIDString);
        }
        catch (Throwable throwable4) {
            // empty catch block
        }
        if (serverUUID == null) {
            throw new IOException("The server_uuid \"" + serverUUIDString + "\" is invalid!");
        }
        Configuration listenerYml = prov.load(EaglerBungeeConfig.getConfigFile(directory, "listeners.yml"));
        Iterator listeners = listenerYml.getKeys().iterator();
        HashMap<String, EaglerListenerConfig> serverListeners = new HashMap<String, EaglerListenerConfig>();
        while (listeners.hasNext()) {
            String name = (String)listeners.next();
            EaglerListenerConfig conf = EaglerListenerConfig.loadConfig(listenerYml.getSection(name), contentTypes);
            if (conf != null) {
                serverListeners.put(name, conf);
                continue;
            }
            EaglerXBungee.logger().severe("Invalid listener config: " + name);
        }
        if (serverListeners.size() == 0) {
            EaglerXBungee.logger().severe("No Listeners Configured!");
        }
        Configuration authserivceYml = prov.load(EaglerBungeeConfig.getConfigFile(directory, "authservice.yml"));
        EaglerAuthConfig authConfig = EaglerAuthConfig.loadConfig(authserivceYml);
        Configuration updatesYml = prov.load(EaglerBungeeConfig.getConfigFile(directory, "updates.yml"));
        EaglerUpdateConfig updatesConfig = EaglerUpdateConfig.loadConfig(updatesYml);
        if (authConfig.isEnableAuthentication()) {
            for (EaglerListenerConfig lst : serverListeners.values()) {
                if (lst.getRatelimitLogin() != null) {
                    lst.getRatelimitLogin().setDivisor(2);
                }
                if (lst.getRatelimitIp() == null) continue;
                lst.getRatelimitIp().setDivisor(2);
            }
        }
        long websocketKeepAliveTimeout = configYml.getInt("websocket_connection_timeout", 15000);
        long websocketHandshakeTimeout = configYml.getInt("websocket_handshake_timeout", 5000);
        int websocketCompressionLevel = configYml.getInt("http_websocket_compression_level", 6);
        boolean downloadVanillaSkins = configYml.getBoolean("download_vanilla_skins_to_clients", false);
        List validSkinUrls = configYml.getList("valid_skin_download_urls");
        int uuidRateLimitPlayer = configYml.getInt("uuid_lookup_ratelimit_player", 50);
        int uuidRateLimitGlobal = configYml.getInt("uuid_lookup_ratelimit_global", 175);
        int skinRateLimitPlayer = configYml.getInt("skin_download_ratelimit_player", 1000);
        int skinRateLimitGlobal = configYml.getInt("skin_download_ratelimit_global", 30000);
        String skinCacheURI = configYml.getString("skin_cache_db_uri", "jdbc:sqlite:eaglercraft_skins_cache.db");
        int keepObjectsDays = configYml.getInt("skin_cache_keep_objects_days", 45);
        int keepProfilesDays = configYml.getInt("skin_cache_keep_profiles_days", 7);
        int maxObjects = configYml.getInt("skin_cache_max_objects", 32768);
        int maxProfiles = configYml.getInt("skin_cache_max_profiles", 32768);
        int antagonistsRateLimit = configYml.getInt("skin_cache_antagonists_ratelimit", 15);
        String sqliteDriverClass = configYml.getString("sql_driver_class", "internal");
        String sqliteDriverPath = configYml.getString("sql_driver_path", null);
        String eaglerPlayersVanillaSkin = configYml.getString("eagler_players_vanilla_skin", null);
        if (eaglerPlayersVanillaSkin != null && eaglerPlayersVanillaSkin.length() == 0) {
            eaglerPlayersVanillaSkin = null;
        }
        EaglerBungeeConfig ret = new EaglerBungeeConfig(serverName, serverUUID, websocketKeepAliveTimeout, websocketHandshakeTimeout, websocketCompressionLevel, serverListeners, contentTypes, downloadVanillaSkins, validSkinUrls, uuidRateLimitPlayer, uuidRateLimitGlobal, skinRateLimitPlayer, skinRateLimitGlobal, skinCacheURI, keepObjectsDays, keepProfilesDays, maxObjects, maxProfiles, antagonistsRateLimit, sqliteDriverClass, sqliteDriverPath, eaglerPlayersVanillaSkin, authConfig, updatesConfig);
        if (eaglerPlayersVanillaSkin != null) {
            VanillaDefaultSkinProfileLoader.lookupVanillaSkinUser(ret);
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getConfigFile(File directory, String fileName) throws IOException {
        File file = new File(directory, fileName);
        if (file.isFile()) return file;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            BufferedReader is = new BufferedReader(new InputStreamReader(EaglerBungeeConfig.class.getResourceAsStream("default_" + fileName), StandardCharsets.UTF_8));
            try {
                try (PrintWriter os = new PrintWriter(new FileWriter(file));){
                    String line;
                    while ((line = is.readLine()) != null) {
                        if (line.contains("${")) {
                            line = line.replace("${random_uuid}", UUID.randomUUID().toString());
                        }
                        os.println(line);
                    }
                }
                if (is == null) return file;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return file;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void loadMimeTypes(InputStream file, Map<String, HttpContentType> contentTypes) throws IOException {
        JsonObject obj = EaglerBungeeConfig.parseJsonObject(file);
        for (Map.Entry etr : obj.entrySet()) {
            String mime = (String)etr.getKey();
            try {
                JsonObject e = ((JsonElement)etr.getValue()).getAsJsonObject();
                JsonArray arr = e.getAsJsonArray("files");
                if (arr == null || arr.size() == 0) {
                    EaglerXBungee.logger().warning("MIME type '" + mime + "' defines no extensions!");
                    continue;
                }
                HashSet<String> exts = new HashSet<String>();
                int i = 0;
                int l = arr.size();
                while (i < l) {
                    exts.add(arr.get(i).getAsString());
                    ++i;
                }
                long expires = 0L;
                JsonElement ex = e.get("expires");
                if (ex != null) {
                    expires = (long)ex.getAsInt() * 1000L;
                }
                String charset = null;
                ex = e.get("charset");
                if (ex != null) {
                    charset = ex.getAsString();
                }
                HttpContentType typeObj = new HttpContentType(exts, mime, charset, expires);
                for (String s : exts) {
                    contentTypes.put(s, typeObj);
                }
            }
            catch (Throwable t) {
                EaglerXBungee.logger().warning("Exception parsing MIME type '" + mime + "' - " + t.toString());
            }
        }
    }

    private static JsonObject parseJsonObject(InputStream file) throws IOException {
        int i;
        StringBuilder str = new StringBuilder();
        byte[] buffer = new byte[8192];
        while ((i = file.read(buffer)) > 0) {
            str.append(new String(buffer, 0, i, "UTF-8"));
        }
        try {
            return new JsonParser().parse(str.toString()).getAsJsonObject();
        }
        catch (JsonSyntaxException ex) {
            throw new IOException("Invalid JSONObject", ex);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public UUID getServerUUID() {
        return this.serverUUID;
    }

    public long getWebsocketKeepAliveTimeout() {
        return this.websocketKeepAliveTimeout;
    }

    public long getWebsocketHandshakeTimeout() {
        return this.websocketHandshakeTimeout;
    }

    public int getHttpWebsocketCompressionLevel() {
        return this.httpWebsocketCompressionLevel;
    }

    public Collection<EaglerListenerConfig> getServerListeners() {
        return this.serverListeners.values();
    }

    public EaglerListenerConfig getServerListenersByName(String name) {
        return this.serverListeners.get(name);
    }

    public Map<String, HttpContentType> getContentType() {
        return this.contentTypes;
    }

    public Map<String, HttpContentType> getContentTypes() {
        return this.contentTypes;
    }

    public boolean getDownloadVanillaSkins() {
        return this.downloadVanillaSkins;
    }

    public Collection<String> getValidSkinUrls() {
        return this.validSkinUrls;
    }

    public boolean isValidSkinHost(String host) {
        host = host.toLowerCase();
        for (String str : this.validSkinUrls) {
            if (str.length() <= 0 || !((str = str.toLowerCase()).charAt(0) == '*' ? host.endsWith(str.substring(1)) : host.equals(str))) continue;
            return true;
        }
        return false;
    }

    public int getUuidRateLimitPlayer() {
        return this.uuidRateLimitPlayer;
    }

    public int getUuidRateLimitGlobal() {
        return this.uuidRateLimitGlobal;
    }

    public int getSkinRateLimitPlayer() {
        return this.skinRateLimitPlayer;
    }

    public int getSkinRateLimitGlobal() {
        return this.skinRateLimitGlobal;
    }

    public String getSkinCacheURI() {
        return this.skinCacheURI;
    }

    public String getSQLiteDriverClass() {
        return this.sqliteDriverClass;
    }

    public String getSQLiteDriverPath() {
        return this.sqliteDriverPath;
    }

    public int getKeepObjectsDays() {
        return this.keepObjectsDays;
    }

    public int getKeepProfilesDays() {
        return this.keepProfilesDays;
    }

    public int getMaxObjects() {
        return this.maxObjects;
    }

    public int getMaxProfiles() {
        return this.maxProfiles;
    }

    public int getAntagonistsRateLimit() {
        return this.antagonistsRateLimit;
    }

    public String getEaglerPlayersVanillaSkin() {
        return this.eaglerPlayersVanillaSkin;
    }

    public Property[] getEaglerPlayersVanillaSkinProperties() {
        return this.eaglerPlayersVanillaSkinCached;
    }

    public boolean isCracked() {
        return true;
    }

    public EaglerAuthConfig getAuthConfig() {
        return this.authConfig;
    }

    public EaglerUpdateConfig getUpdateConfig() {
        return this.updateConfig;
    }

    private EaglerBungeeConfig(String serverName, UUID serverUUID, long websocketKeepAliveTimeout, long websocketHandshakeTimeout, int httpWebsocketCompressionLevel, Map<String, EaglerListenerConfig> serverListeners, Map<String, HttpContentType> contentTypes, boolean downloadVanillaSkins, Collection<String> validSkinUrls, int uuidRateLimitPlayer, int uuidRateLimitGlobal, int skinRateLimitPlayer, int skinRateLimitGlobal, String skinCacheURI, int keepObjectsDays, int keepProfilesDays, int maxObjects, int maxProfiles, int antagonistsRateLimit, String sqliteDriverClass, String sqliteDriverPath, String eaglerPlayersVanillaSkin, EaglerAuthConfig authConfig, EaglerUpdateConfig updateConfig) {
        this.serverName = serverName;
        this.serverUUID = serverUUID;
        this.serverListeners = serverListeners;
        this.websocketHandshakeTimeout = websocketHandshakeTimeout;
        this.websocketKeepAliveTimeout = websocketKeepAliveTimeout;
        this.httpWebsocketCompressionLevel = httpWebsocketCompressionLevel;
        this.contentTypes = contentTypes;
        this.downloadVanillaSkins = downloadVanillaSkins;
        this.validSkinUrls = validSkinUrls;
        this.uuidRateLimitPlayer = uuidRateLimitPlayer;
        this.uuidRateLimitGlobal = uuidRateLimitGlobal;
        this.skinRateLimitPlayer = skinRateLimitPlayer;
        this.skinRateLimitGlobal = skinRateLimitGlobal;
        this.skinCacheURI = skinCacheURI;
        this.keepObjectsDays = keepObjectsDays;
        this.keepProfilesDays = keepProfilesDays;
        this.maxObjects = maxObjects;
        this.maxProfiles = maxProfiles;
        this.antagonistsRateLimit = antagonistsRateLimit;
        this.sqliteDriverClass = sqliteDriverClass;
        this.sqliteDriverPath = sqliteDriverPath;
        this.eaglerPlayersVanillaSkin = eaglerPlayersVanillaSkin;
        this.authConfig = authConfig;
        this.updateConfig = updateConfig;
    }
}

