/*
 * Decompiled with CFR 0.152.
 */
package net.lax1dude.eaglercraft.v1_8.buildtools.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JavaC {
    public static final boolean windows;
    public static File jdkHome;
    public static final List<String> compilerFlags;
    private static int debugSourceFileCount;

    static {
        compilerFlags = Arrays.asList("-Xlint:-unchecked", "-Xlint:-options", "-Xlint:-deprecation", "-source", "1.8", "-target", "1.8");
        debugSourceFileCount = 0;
        windows = System.getProperty("os.name").toLowerCase().contains("windows");
        String string = windows ? "javac.exe" : "javac";
        File file = new File(System.getProperty("java.home"));
        jdkHome = new File(file, "bin/" + string).isFile() ? file : (new File(file, "../bin/" + string).isFile() ? file.getParentFile() : null);
    }

    public static int runJavaC(File file, File file2, File file3, String[] stringArray, File ... fileArray) throws IOException {
        int n;
        Object object;
        InputStream inputStream;
        Appendable appendable;
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Could not create output directory: " + file2.getAbsolutePath());
        }
        if (!file3.exists() && !file3.mkdirs()) {
            throw new IOException("Could not create temporary directory: " + file2.getAbsolutePath());
        }
        File file4 = new File(file3, "MinecraftSrc/src_javadoc_tmp");
        if (!file4.exists() && !file4.mkdirs()) {
            throw new IOException("Could not create temporary directory: " + file4.getAbsolutePath());
        }
        debugSourceFileCount = 0;
        File file5 = new File(file3, "sourceFiles.txt");
        Serializable serializable = null;
        String string = null;
        try {
            appendable = new PrintWriter(new FileWriter(file5));
            try {
                System.out.println("Extracting decompiled source...");
                byte[] byArray = new byte[16384];
                Throwable throwable = null;
                inputStream = null;
                try {
                    object = new ZipInputStream(new FileInputStream(file));
                    try {
                        ZipEntry zipEntry;
                        while ((zipEntry = ((ZipInputStream)object).getNextEntry()) != null && !zipEntry.isDirectory()) {
                            String string2 = zipEntry.getName();
                            if (!string2.endsWith(".java")) continue;
                            File file6 = new File(file4, string2);
                            File file7 = file6.getParentFile();
                            if (!file7.exists() && !file7.mkdirs()) {
                                throw new IOException("Could not create temporary directory: " + file7.getAbsolutePath());
                            }
                            Throwable throwable2 = null;
                            Object var20_33 = null;
                            try (FileOutputStream fileOutputStream = new FileOutputStream(file6);){
                                while ((n = ((FilterInputStream)object).read(byArray)) != -1) {
                                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                            ((PrintWriter)appendable).println("\"" + file6.getAbsolutePath().replace('\\', '/') + "\"");
                            ++debugSourceFileCount;
                        }
                    }
                    finally {
                        if (object != null) {
                            ((ZipInputStream)object).close();
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
                System.out.println("Scanning source folder paths...");
                int n2 = 0;
                while (n2 < fileArray.length) {
                    JavaC.discoverSourceFiles(fileArray[n2], (PrintWriter)appendable);
                    ++n2;
                }
            }
            finally {
                if (appendable != null) {
                    ((PrintWriter)appendable).close();
                }
            }
        }
        catch (Throwable throwable) {
            if (serializable == null) {
                serializable = throwable;
            } else if (serializable != throwable) {
                ((Throwable)serializable).addSuppressed(throwable);
            }
            throw serializable;
        }
        serializable = new ArrayList();
        if (windows) {
            serializable.add(new File(jdkHome, "bin/javac.exe").getAbsolutePath());
        } else {
            serializable.add(new File(jdkHome, "bin/javac").getAbsolutePath());
        }
        serializable.addAll(compilerFlags);
        string = System.getProperty("path.separator");
        serializable.add("-classpath");
        serializable.add(String.join((CharSequence)string, stringArray));
        serializable.add("-sourcepath");
        appendable = new StringBuilder();
        ((StringBuilder)appendable).append(file.getAbsolutePath());
        int n3 = 0;
        while (n3 < fileArray.length) {
            ((StringBuilder)appendable).append(string).append(fileArray[n3].getAbsolutePath());
            ++n3;
        }
        serializable.add(((StringBuilder)appendable).toString());
        serializable.add("-d");
        serializable.add(file2.getAbsolutePath());
        serializable.add("@" + file5.getAbsolutePath());
        System.out.println();
        n3 = 0;
        n = serializable.size();
        while (n3 < n) {
            String string3 = (String)serializable.get(n3);
            if (string3.indexOf(32) != -1) {
                System.out.print("\"" + string3 + "\"");
            } else {
                System.out.print(string3);
            }
            System.out.print(' ');
            ++n3;
        }
        System.out.println();
        System.out.println();
        System.out.println("Compiling " + debugSourceFileCount + " source files...");
        ProcessBuilder processBuilder = new ProcessBuilder((List<String>)((Object)serializable));
        processBuilder.directory(file3);
        Process process = processBuilder.start();
        InputStream inputStream2 = process.getInputStream();
        inputStream = process.getErrorStream();
        object = new byte[128];
        do {
            boolean bl = false;
            int n4 = inputStream2.available();
            if (n4 > 0) {
                if (n4 > 128) {
                    n4 = 128;
                }
                inputStream2.read((byte[])object, 0, n4);
                System.out.write((byte[])object, 0, n4);
                bl = true;
            }
            if ((n4 = inputStream.available()) > 0) {
                if (n4 > 128) {
                    n4 = 128;
                }
                inputStream.read((byte[])object, 0, n4);
                System.err.write((byte[])object, 0, n4);
                bl = true;
            }
            if (bl) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        } while (process.isAlive());
        while (true) {
            try {
                return process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static void discoverSourceFiles(File file, PrintWriter printWriter) throws IOException {
        File[] fileArray = file.listFiles();
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            String string = file2.getAbsolutePath();
            if (file2.isDirectory()) {
                JavaC.discoverSourceFiles(file2, printWriter);
            } else if (string.endsWith(".java")) {
                printWriter.println("\"" + string.replace('\\', '/') + "\"");
                ++debugSourceFileCount;
            }
            ++n;
        }
    }
}

